/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.order;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;
import kd.occ.ocepfp.common.util.DateUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class ReturnApplyList
extends OcbaseFormMobPlugin
implements TabSelectListener,
ListRowClickListener,
MobileSearchTextChangeListener,
CreateListDataProviderListener {
    private static final String[] billStatusArray = new String[]{"A", "B", "C"};
    private static final String op_billlistap = "billlistap";
    private static final String op_tabap = "tabap";
    private static final String op_ordersearch = "ordersearch";
    private static final String op_btnedit = "btnedit";
    private static final String op_delete = "btndelete";
    private static final String op_flexnodatapanel = "flexnodatapanel";
    private static final String orderdatespan = "orderdatespan";
    private static final String startdate = "startdate";
    private static final String enddate = "enddate";
    private static final String page_edit = "ocsaa_retorder_req_add";
    private static final String page_view = "ocsaa_retorder_req_view";
    private static final String UNBTNSUBMIT = "unsubmit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addTabSelectListener(this, new String[]{op_tabap});
        this.addClickListeners(new String[]{op_btnedit, op_delete, UNBTNSUBMIT});
        MobileSearch search = (MobileSearch)this.getControl(op_ordersearch);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(op_billlistap);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(op_billlistap);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlVisiable();
    }

    public void afterCreateNewData(EventObject e) {
        Object opKey = this.getParameter("opkey");
        if (StringUtil.isNotNull((Object)opKey)) {
            Tab tab = (Tab)this.getControl(op_tabap);
            String tbKey = opKey.toString();
            tab.selectTab(tbKey);
            tab.activeTab(tbKey);
        }
        this.refleshBillList();
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.showEditForm(OperationStatus.VIEW, page_view);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "enddate": 
            case "startdate": 
            case "orderdatespan": {
                this.refleshBillList();
                break;
            }
        }
    }

    private void refleshBillList() {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Tab tab = (Tab)this.getControl(op_tabap);
        String curTabKey = tab.getCurrentTab();
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getOrderFilter(curTabKey)});
    }

    private void setControlVisiable() {
        BillList billList = (BillList)this.getControl(op_billlistap);
        int pageRow = billList.getCurrentListAllRowCollection().size();
        if (pageRow == 0) {
            this.setDisVisible(new String[]{op_billlistap});
            this.setVisible(new String[]{op_flexnodatapanel});
        } else {
            this.setDisVisible(new String[]{op_flexnodatapanel});
            this.setVisible(new String[]{op_billlistap});
        }
    }

    private QFilter getOrderFilter(String key) {
        Date endDate;
        QFilter filter = null;
        DynamicObjectCollection authorityCustomerList = ChannelUserHelper.getAuthorityCustomerList();
        filter = authorityCustomerList != null && authorityCustomerList.size() > 0 ? new QFilter("returnchannel", "in", authorityCustomerList.stream().map(r -> r.getLong("owner")).collect(Collectors.toList())) : new QFilter("returnchannel", "=", null);
        switch (key) {
            case "tp_all": {
                filter.and("billstatus", "in", Arrays.asList(billStatusArray));
                break;
            }
            default: {
                filter.and("billstatus", "=", (Object)key.toUpperCase());
            }
        }
        MobileSearch search = (MobileSearch)this.getControl(op_ordersearch);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"billno,itementry.itemid.name,itementry.itemid.number"}));
        }
        Object orderDateSpan = this.getValue(orderdatespan);
        String selectDate = "B";
        if (!CommonUtils.isNull((Object)orderDateSpan)) {
            selectDate = orderDateSpan.toString();
        }
        switch (selectDate) {
            case "A": {
                filter.and("billdate", ">", (Object)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(7L)));
                break;
            }
            case "C": {
                filter.and("billdate", ">", (Object)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L)));
                break;
            }
            default: {
                filter.and("billdate", ">", (Object)DateUtil.getFirstDayOfMonth());
            }
        }
        Date startDate = (Date)this.getValue(startdate);
        if (startDate != null) {
            filter.and("billdate", ">=", (Object)startDate);
        }
        if ((endDate = (Date)this.getValue(enddate)) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(endDate);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            endDate = cal.getTime();
            filter.and("billdate", "<=", (Object)endDate);
        }
        return filter;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String key;
        switch (key = ((Control)tabSelectEvent.getSource()).getKey().toLowerCase()) {
            case "tabap": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getOrderFilter(tabSelectEvent.getTabKey())});
                break;
            }
        }
        this.setControlVisiable();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "unsubmit": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("B")) {
                    Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                    DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ocbsoc_returnorder");
                    OperationResult result = OperationUtil.invokeOperation((DynamicObject)order, (String)UNBTNSUBMIT);
                    if (!result.isSuccess()) break;
                    this.refleshBillList();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5f85\u5ba1\u6838\u7684\u8ba2\u5355\u3002", (String)"ReturnApplyList_0", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        switch (callBackId) {
            case "btndelete": {
                BillList billList = (BillList)this.getControl(op_billlistap);
                Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ocbsoc_returnorder");
                OperationResult delResult = OperationUtil.invokeOperation((DynamicObject)order, (String)"delete");
                if (!delResult.isSuccess()) break;
                this.refleshBillList();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        BillList billList = (BillList)this.getControl(op_billlistap);
        switch (key) {
            case "btnedit": {
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("A")) {
                    this.showEditForm(OperationStatus.EDIT, page_edit);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u6682\u5b58\u7684\u9000\u8d27\u7533\u8bf7\u3002", (String)"ReturnApplyList_1", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btndelete": {
                if (billList.getCurrentSelectedRowInfo().getBillStatus().equals("A")) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(op_delete, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u9009\u4e2d\u9000\u8d27\u7533\u8bf7\uff1f", (String)"ReturnApplyList_2", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u6682\u5b58\u7684\u9000\u8d27\u7533\u8bf7\u3002", (String)"ReturnApplyList_3", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showEditForm(OperationStatus operationStatus, String formId) {
        BillList billList = (BillList)this.getControl(op_billlistap);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(formId);
        mobileFormShowParameter.setStatus(operationStatus);
        mobileFormShowParameter.setCustomParam("orderId", pkId);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String key;
        switch (key = ((Control)mobileSearchTextChangeEvent.getSource()).getKey()) {
            case "ordersearch": {
                this.refleshBillList();
                break;
            }
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                QFilter filter;
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                HashSet<Long> orderIds = new HashSet<Long>(rows.size());
                for (DynamicObject row : rows) {
                    orderIds.add(row.getLong("id"));
                }
                String selectField = String.join((CharSequence)",", "id", String.join((CharSequence)".", "itementry", "qty"), "sumtaxamount");
                DynamicObjectCollection orders = QueryServiceHelper.query((String)"ocbsoc_returnorder", (String)selectField, (QFilter[])(filter = new QFilter("id", "in", orderIds)).toArray());
                if (orders.isEmpty()) {
                    return null;
                }
                HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
                HashMap<Long, BigDecimal> amountMap = new HashMap<Long, BigDecimal>();
                for (DynamicObject order : orders) {
                    long key = order.getLong("id");
                    BigDecimal qty = (BigDecimal)map.get(key);
                    qty = qty == null ? order.getBigDecimal(String.join((CharSequence)".", "itementry", "qty")) : qty.add(order.getBigDecimal(String.join((CharSequence)".", "itementry", "qty")));
                    amountMap.put(key, order.getBigDecimal("sumtaxamount"));
                    map.put(key, qty);
                }
                for (DynamicObject row : rows) {
                    long orderId = row.getLong("id");
                    if (map.get(orderId) != null) {
                        row.set("remark", (Object)((BigDecimal)map.get(orderId)).stripTrailingZeros().toPlainString());
                    }
                    if (amountMap.get(orderId) == null) continue;
                    row.set("sumtaxamount", (Object)((BigDecimal)amountMap.get(orderId)).stripTrailingZeros().toPlainString());
                }
                return rows;
            }
        });
    }
}

