/*
 * Decompiled with CFR 0.152.
 */
package kd.odc.hjm.mservice.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbjm.common.util.HBJMDynamicObjectUtils;

public class TestToolsPlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(TestToolsPlugin.class);
    private static final String SEARCHMSGBTN = "searchmsg";
    private static final String MSGNUMBER = "msgnumber";
    private static final String MSGENTRY = "msgentry";
    private static final String SERVICEBTN = "servicebtn";
    private static final String CLOUDID = "cloudid";
    private static final String APPID = "appid";
    private static final String SERVICENAME = "servicename";
    private static final String METHODNAME = "methodname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAMARRTYPE = "paramarrtype";
    private static final String PARAMKEY = "paramkey";
    private static final String PARAMDATA = "paramdata";
    private static String PARAMRESULT = "issuccess";
    private static String PARAMS = "params";
    private static String SERVICERESPONSE = "serviceresponse";
    private static String APPID_HJM = "hjm";
    private static String CACHE_KEY_PRE = "TestToolsPlugin-CACHE-";
    private static int MAX_PARAM_SIZE = 10;
    private static int INIT_HASH_SIZE = 8;
    private static int MAX_LIST_SIZE = 500;
    private static final String LISTENTRYENTITY = "listentryentity";
    private static final String LISTCLOUDID = "listcloudid";
    private static final String LISTAPPID = "listappid";
    private static final String LISTSERVICENAME = "listservicename";
    private static final String LISTMETHODNAME = "listmethodname";
    private static final String LISTPARAMS = "listparams";
    private static final String SERVICEDATE = "servicedate";
    private static final String SEARCHSERVICEBTN = "searchservicebtn";
    private static final String COPYSERVICEBTN = "copyservicebtn";
    private static final String DECRYPTION = "decryption";
    private static List<String> MSG_SHOW_COLs = Arrays.asList("number", "msgtitle", "msgtag", "sendtime", "params");

    public void registerListener(EventObject evn) {
        super.registerListener(evn);
        Button buttonmsg = (Button)this.getView().getControl(SEARCHMSGBTN);
        buttonmsg.addClickListener((ClickListener)this);
        Button servicebtn = (Button)this.getView().getControl(SERVICEBTN);
        servicebtn.addClickListener((ClickListener)this);
        Button searchservicebtn = (Button)this.getView().getControl(SEARCHSERVICEBTN);
        searchservicebtn.addClickListener((ClickListener)this);
        Button decryption = (Button)this.getView().getControl(DECRYPTION);
        decryption.addClickListener((ClickListener)this);
        Button jsonbtn = (Button)this.getView().getControl("jsonbtn");
        jsonbtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        DynamicObject data = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)SEARCHMSGBTN, (String)source.getKey())) {
            this.getModel().deleteEntryData(MSGENTRY);
            String msgNumber = data.getString(MSGNUMBER);
            if (HRStringUtils.isEmpty((String)msgNumber)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6d88\u606f\u7f16\u7801\u8fdb\u884c\u67e5\u8be2", (String)"TestToolsPlugin_0", (String)"odc-hjm-mservice", (Object[])new Object[0]));
                return;
            }
            HRBaseServiceHelper service = new HRBaseServiceHelper("hrcs_msgcenter");
            DynamicObject msg = service.loadDynamicObject(new QFilter("number", "=", (Object)msgNumber));
            if (ObjectUtils.isEmpty((Object)msg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", (String)"TestToolsPlugin_1", (String)"odc-hjm-mservice", (Object[])new Object[0]));
                return;
            }
            this.setMsgInfo(msg);
        } else if (HRStringUtils.equals((String)SEARCHSERVICEBTN, (String)source.getKey())) {
            this.getDataFromCache();
        } else if (DECRYPTION.equals(source.getKey())) {
            String schemeId = this.getModel().getDataEntity().getString("schemaid");
            FilterScheme filterScheme = new SchemeQuery().getScheme(schemeId);
            if (filterScheme == null) {
                return;
            }
            String scheme = filterScheme.getScheme();
            if (StringUtils.isEmpty((CharSequence)scheme)) {
                return;
            }
            List rows = (List)SerializationUtils.deSerializeFromBase64((String)scheme);
            scheme = ((List)((Map)rows.get(0)).get("FieldName")).get(0).toString();
            CodeEdit edit = (CodeEdit)this.getView().getControl("schemadetails");
            edit.setText(scheme);
        } else if ("jsonbtn".equals(source.getKey())) {
            try {
                CodeEdit edit = (CodeEdit)this.getView().getControl("requestparam");
                String requestparam = edit.getText();
                String cloudId = data.getString(CLOUDID);
                String appId = data.getString(APPID);
                String serviceName = data.getString(SERVICENAME);
                String classpath = data.getString("classpath");
                if (StringUtils.isEmpty((CharSequence)classpath)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u63a5\u53e3\u7c7b\u5168\u8def\u5f84", (String)"TestToolsPlugin_2", (String)"odc-hjm-mservice", (Object[])new Object[0]));
                }
                String methodName = data.getString(METHODNAME);
                Class<?> serviceClass = null;
                try {
                    serviceClass = Class.forName(classpath);
                }
                catch (ClassNotFoundException e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
                if (serviceClass == null) {
                    return;
                }
                for (Method method : serviceClass.getMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Class<?> parameterType = parameterTypes[0];
                    Object request = JSON.parseObject((String)requestparam, parameterType);
                    Object result = HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{request});
                    ValueFilter valueFilter = (o, s, o1) -> this.dealDynaObjectData(o1);
                    String pretty = JSON.toJSONString((Object)result, (SerializeFilter)valueFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                    CodeEdit response = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
                    response.setText(pretty);
                }
            }
            catch (Exception e) {
                CodeEdit response = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
                response.setText(e.toString());
                logger.error("TestToolsPlugin#error", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject data = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)SERVICEBTN, (String)afterDoOperationEventArgs.getOperateKey())) {
            if (!this.valideServiceParams()) return;
            String cloudId = data.getString(CLOUDID);
            String appId = data.getString(APPID);
            String serviceName = data.getString(SERVICENAME);
            String methodName = data.getString(METHODNAME);
            try {
                Map<String, Object> result = this.getParams();
                if (!((Boolean)result.get(PARAMRESULT)).booleanValue()) return;
                Object returnInfo = this.invokeMethod(cloudId, appId, serviceName, methodName, (List)result.get(PARAMS));
                ValueFilter valueFilter = new ValueFilter(){

                    public Object process(Object o, String s, Object o1) {
                        return TestToolsPlugin.this.dealDynaObjectData(o1);
                    }
                };
                String pretty = JSON.toJSONString((Object)returnInfo, (SerializeFilter)valueFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                CodeEdit edit = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
                edit.setText(pretty);
                this.saveToCache();
                return;
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClassNotFoundException || e.getMessage() != null && e.getMessage().indexOf(ResManager.loadKDString((String)"\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"TestToolsPlugin_3", (String)"odc-hjm-mservice", (Object[])new Object[0])) > -1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6807\u8bc6\u3001\u670d\u52a1\u914d\u7f6e\u4ee5\u53ca\u53c2\u6570", (String)"TestToolsPlugin_4", (String)"odc-hjm-mservice", (Object[])new Object[0]));
                    return;
                }
                this.getView().showErrorNotification(e.getMessage());
                throw e;
            }
        } else {
            List personalData;
            if (!HRStringUtils.equals((String)COPYSERVICEBTN, (String)afterDoOperationEventArgs.getOperateKey())) return;
            EntryGrid entryGrid = (EntryGrid)this.getControl(LISTENTRYENTITY);
            int[] selectIndex = entryGrid.getSelectRows();
            if (selectIndex == null || selectIndex.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"TestToolsPlugin_5", (String)"odc-hjm-mservice", (Object[])new Object[0]));
                return;
            }
            if (selectIndex.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"TestToolsPlugin_6", (String)"odc-hjm-mservice", (Object[])new Object[0]));
                return;
            }
            String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
            if (HRStringUtils.isNotEmpty((String)cacheStringData) && !ObjectUtils.isEmpty((Object)(personalData = (List)SerializationUtils.deSerializeFromBase64((String)cacheStringData))) && personalData.size() > selectIndex[0]) {
                Map info = (Map)personalData.get(selectIndex[0]);
                this.getModel().setValue(CLOUDID, info.get(CLOUDID));
                this.getModel().setValue(APPID, info.get(APPID));
                this.getModel().setValue(SERVICENAME, info.get(SERVICENAME));
                this.getModel().setValue(METHODNAME, info.get(METHODNAME));
                this.getModel().deleteEntryData(ENTRYENTITY);
                DynamicObjectCollection entries = (DynamicObjectCollection)info.get(ENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entryInfo = (DynamicObject)entries.get(i);
                    this.getModel().setValue(PARAMTYPE, (Object)entryInfo.getString(PARAMTYPE), i);
                    this.getModel().setValue(PARAMARRTYPE, (Object)entryInfo.getString(PARAMARRTYPE), i);
                    this.getModel().setValue(PARAMKEY, (Object)entryInfo.getString(PARAMKEY), i);
                    this.getModel().setValue(PARAMDATA, (Object)entryInfo.getString("paramdata_tag"), i);
                    this.getModel().setValue("paramdata_tag", (Object)entryInfo.getString("paramdata_tag"), i);
                }
            }
            this.getView().updateView();
        }
    }

    private void setMsgInfo(DynamicObject msg) {
        IDataEntityType dataEntityType = msg.getDataEntityType();
        DataEntityPropertyCollection props = dataEntityType.getProperties();
        this.getModel().batchCreateNewEntryRow(MSGENTRY, MSG_SHOW_COLs.size());
        for (int i = 0; i < MSG_SHOW_COLs.size(); ++i) {
            String col = MSG_SHOW_COLs.get(i);
            IDataEntityProperty prop = (IDataEntityProperty)props.get((Object)col);
            if (ObjectUtils.isEmpty((Object)prop)) continue;
            this.getModel().setValue("msgcolname", (Object)prop.getDisplayName(), i);
            this.getModel().setValue("msgcolcode", (Object)col, i);
            if (HRStringUtils.equals((String)"params", (String)col)) {
                String info = msg.getString(col);
                if (!HRStringUtils.isNotEmpty((String)info)) continue;
                Object content = SerializationUtils.deSerializeFromBase64((String)info);
                this.getModel().setValue("msgcoldata", content, i);
                continue;
            }
            this.getModel().setValue("msgcoldata", msg.get(col), i);
        }
    }

    private boolean valideServiceParams() {
        DynamicObject data = this.getModel().getDataEntity();
        String cloudid = data.getString(CLOUDID);
        String appId = data.getString(APPID);
        String serviceName = data.getString(SERVICENAME);
        String methodName = data.getString(METHODNAME);
        if (HRStringUtils.isEmpty((String)cloudid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e91\u5e94\u7528\u6807\u8bc6", (String)"TestToolsPlugin_7", (String)"odc-hjm-mservice", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)appId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7528\u6807\u8bc6", (String)"TestToolsPlugin_8", (String)"odc-hjm-mservice", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)serviceName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u670d\u52a1\u540d\u79f0", (String)"TestToolsPlugin_9", (String)"odc-hjm-mservice", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)methodName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u670d\u52a1\u65b9\u6cd5", (String)"TestToolsPlugin_10", (String)"odc-hjm-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder errorInfo = new StringBuilder();
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection params = data.getDynamicObjectCollection(ENTRYENTITY);
        if (ObjectUtils.isEmpty((Object)params)) {
            result.put(PARAMRESULT, Boolean.FALSE);
            return result;
        }
        ArrayList<Object> resultData = new ArrayList<Object>();
        for (int i = 0; i < params.size(); ++i) {
            DynamicObject param = (DynamicObject)params.get(i);
            String paramtype = param.getString(PARAMTYPE);
            String paramarrtype = param.getString(PARAMARRTYPE);
            String paramkey = param.getString(PARAMKEY);
            String paramdata = param.getString("paramdata_tag");
            boolean success = true;
            if (HRStringUtils.isEmpty((String)paramtype) && HRStringUtils.isEmpty((String)paramkey) && HRStringUtils.isEmpty((String)paramdata)) continue;
            if (HRStringUtils.isEmpty((String)paramtype)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b", (String)"TestToolsPlugin_11", (String)"odc-hjm-mservice", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.isEmpty((String)paramarrtype)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u53c2\u6570\u96c6\u5408\u7c7b\u578b", (String)"TestToolsPlugin_12", (String)"odc-hjm-mservice", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype) && HRStringUtils.isEmpty((String)paramkey)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u5b9e\u4f53\u7f16\u7801", (String)"TestToolsPlugin_13", (String)"odc-hjm-mservice", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.isEmpty((String)paramdata)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u586b\u5199\u53c2\u6570\u503c", (String)"TestToolsPlugin_14", (String)"odc-hjm-mservice", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (!success) continue;
            try {
                if (HRStringUtils.equals((String)"single", (String)paramarrtype)) {
                    this.dealSingleTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (HRStringUtils.equals((String)"array", (String)paramarrtype)) {
                    this.dealArrayTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (HRStringUtils.equals((String)"list", (String)paramarrtype)) {
                    this.dealListTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (!HRStringUtils.equals((String)"set", (String)paramarrtype)) continue;
                this.dealSetTypeData(paramtype, paramkey, paramdata, resultData);
                continue;
            }
            catch (Exception e) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53c2\u6570\u503c\u89e3\u6790\u9519\u8bef", (String)"TestToolsPlugin_15", (String)"odc-hjm-mservice", (Object[])new Object[0]), i + 1));
                result.put(PARAMRESULT, Boolean.FALSE);
            }
        }
        if (HRStringUtils.isNotEmpty((String)errorInfo.toString())) {
            this.getView().showErrorNotification(errorInfo.toString());
            result.put(PARAMRESULT, Boolean.FALSE);
        } else {
            result.put(PARAMS, resultData);
            result.put(PARAMRESULT, Boolean.TRUE);
        }
        return result;
    }

    private void dealSingleTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        Object[] datas;
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(Integer.parseInt(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(Long.parseLong(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(Boolean.parseBoolean(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(paramdata);
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(HRDateTimeUtils.parseDate((String)String.valueOf(paramdata)));
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            resultData.add(JSON.parseObject((String)paramdata, Map.class));
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype) && !ObjectUtils.isEmpty((Object[])(datas = this.getDataFromDb(paramkey, paramdata)))) {
            resultData.add(datas[0]);
        }
    }

    private void dealArrayTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(this.parseIntegerList(paramdata).toArray(new Integer[0]));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongList(paramdata).toArray(new Long[0]));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(this.parseBooleanList(paramdata).toArray(new Boolean[0]));
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(this.parseDateList(paramdata).toArray(new Date[0]));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(this.parseStringList(paramdata).toArray(new String[0]));
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            resultData.add(this.parseMapList(paramdata).toArray(new HashMap[0]));
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(datas);
        }
    }

    private void dealListTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(this.parseIntegerList(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongList(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(this.parseBooleanList(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(this.parseStringList(paramdata));
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(this.parseDateList(paramdata));
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            resultData.add(this.parseMapList(paramdata));
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(Arrays.stream(datas).collect(Collectors.toList()));
        }
    }

    private void dealSetTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(this.parseIntegerSet(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongSet(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(this.parseBooleanSet(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(this.parseStringSet(paramdata));
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(this.parseDateSet(paramdata));
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            resultData.add(this.parseMapSet(paramdata));
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(Arrays.stream(datas).collect(Collectors.toSet()));
        }
    }

    private Object parseIntegerSet(String paramdata) {
        String[] datas;
        HashSet<Integer> result = new HashSet<Integer>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(Integer.parseInt(data));
        }
        return result;
    }

    private Object parseLongSet(String paramdata) {
        String[] datas;
        HashSet<Long> result = new HashSet<Long>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(Long.parseLong(data));
        }
        return result;
    }

    private Object parseBooleanSet(String paramdata) {
        String[] datas;
        HashSet<Boolean> result = new HashSet<Boolean>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(Boolean.parseBoolean(data));
        }
        return result;
    }

    private Object parseStringSet(String paramdata) {
        String[] datas;
        HashSet<String> result = new HashSet<String>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(data);
        }
        return result;
    }

    private Object parseDateSet(String paramdata) throws ParseException {
        String[] datas;
        HashSet<Date> result = new HashSet<Date>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(HRDateTimeUtils.parseDate((String)String.valueOf(data)));
        }
        return result;
    }

    private Object parseMapSet(String paramdata) throws ParseException {
        String[] datas;
        HashSet<Map> result = new HashSet<Map>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split("},")) {
            if (!(data = data.trim()).endsWith("}")) {
                data = data + "}";
            }
            Map mapdata = (Map)JSON.parseObject((String)data, Map.class);
            for (Map.Entry entry : mapdata.entrySet()) {
                if (!String.valueOf(entry.getValue()).endsWith("DATE")) continue;
                String dealData = String.valueOf(entry.getValue());
                dealData = dealData.substring(0, dealData.length() - 4);
                mapdata.put(entry.getKey(), HRDateTimeUtils.parseDate((String)dealData));
            }
            result.add(mapdata);
        }
        return result;
    }

    private List<Integer> parseIntegerList(String paramdata) {
        String[] datas;
        ArrayList<Integer> result = new ArrayList<Integer>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(Integer.parseInt(data));
        }
        return result;
    }

    private List<Long> parseLongList(String paramdata) {
        String[] datas;
        ArrayList<Long> result = new ArrayList<Long>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(Long.parseLong(data));
        }
        return result;
    }

    private List<Boolean> parseBooleanList(String paramdata) {
        String[] datas;
        ArrayList<Boolean> result = new ArrayList<Boolean>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(Boolean.parseBoolean(data));
        }
        return result;
    }

    private List<Date> parseDateList(String paramdata) throws ParseException {
        String[] datas;
        ArrayList<Date> result = new ArrayList<Date>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(HRDateTimeUtils.parseDate((String)String.valueOf(paramdata)));
        }
        return result;
    }

    private List<String> parseStringList(String paramdata) {
        String[] datas;
        ArrayList<String> result = new ArrayList<String>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split(",")) {
            result.add(data);
        }
        return result;
    }

    private List<Map> parseMapList(String paramdata) throws ParseException {
        String[] datas;
        ArrayList<Map> result = new ArrayList<Map>(INIT_HASH_SIZE);
        for (String data : datas = paramdata.split("},")) {
            if (!(data = data.trim()).endsWith("}")) {
                data = data + "}";
            }
            Map mapdata = (Map)JSON.parseObject((String)data, Map.class);
            for (Map.Entry entry : mapdata.entrySet()) {
                if (!String.valueOf(entry.getValue()).endsWith("DATE")) continue;
                String dealData = String.valueOf(entry.getValue());
                dealData = dealData.substring(0, dealData.length() - 4);
                mapdata.put(entry.getKey(), HRDateTimeUtils.parseDate((String)dealData));
            }
            result.add(mapdata);
        }
        return result;
    }

    private DynamicObject[] getDataFromDb(String paramkey, String paramdata) {
        try {
            List<Long> searchIds = this.parseLongList(paramdata);
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(paramkey);
            DynamicObject[] datas = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", searchIds)});
            return datas;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private Object invokeMethod(String cloudId, String appId, String serviceName, String methodName, List<Object> params) {
        if (params != null && params.size() > MAX_PARAM_SIZE) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6761\u76ee\u4e0d\u80fd\u5927\u4e8e%s", (String)"TestToolsPlugin_16", (String)"odc-hjm-mservice", (Object[])new Object[0]), MAX_PARAM_SIZE));
            return null;
        }
        Object result = null;
        if (params == null) {
            params = new ArrayList<Object>();
        }
        int size = params.size();
        switch (size) {
            case 0: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, null);
            }
            case 1: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0)});
            }
            case 2: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1)});
            }
            case 3: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2)});
            }
            case 4: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3)});
            }
            case 5: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4)});
            }
            case 6: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5)});
            }
            case 7: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6)});
            }
            case 8: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7)});
            }
            case 9: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7), params.get(8)});
            }
            case 10: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7), params.get(8), params.get(9)});
            }
        }
        return result;
    }

    void saveToCache() {
        DynamicObject data = this.getModel().getDataEntity();
        String cloudid = data.getString(CLOUDID);
        String appId = data.getString(APPID);
        String serviceName = data.getString(SERVICENAME);
        String methodName = data.getString(METHODNAME);
        DynamicObjectCollection params = data.getDynamicObjectCollection(ENTRYENTITY);
        HashMap<String, Object> datas = new HashMap<String, Object>(INIT_HASH_SIZE);
        datas.put(CLOUDID, cloudid);
        datas.put(APPID, appId);
        datas.put(SERVICENAME, serviceName);
        datas.put(METHODNAME, methodName);
        datas.put(ENTRYENTITY, params);
        datas.put(SERVICEDATE, new Date());
        String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
        ArrayList<HashMap<String, Object>> personalData = null;
        if (HRStringUtils.isNotEmpty((String)cacheStringData)) {
            personalData = (ArrayList<HashMap<String, Object>>)SerializationUtils.deSerializeFromBase64((String)cacheStringData);
        }
        if (personalData == null) {
            personalData = new ArrayList<HashMap<String, Object>>();
        }
        personalData.add(datas);
        if (personalData.size() >= MAX_LIST_SIZE) {
            personalData.remove(0);
        }
        HRAppCache.get((String)APPID_HJM).remove(this.getCacheKey());
        HRAppCache.get((String)APPID_HJM).put(this.getCacheKey(), (Object)SerializationUtils.serializeToBase64(personalData));
        this.getDataFromCache();
    }

    private void getDataFromCache() {
        this.getModel().deleteEntryData(LISTENTRYENTITY);
        String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
        List personalData = null;
        if (HRStringUtils.isNotEmpty((String)cacheStringData)) {
            personalData = (List)SerializationUtils.deSerializeFromBase64((String)cacheStringData);
            this.getModel().batchCreateNewEntryRow(LISTENTRYENTITY, personalData.size());
            for (int i = 0; i < personalData.size(); ++i) {
                Map datainfo = (Map)personalData.get(i);
                this.getModel().setValue(LISTCLOUDID, datainfo.get(CLOUDID), i);
                this.getModel().setValue(LISTAPPID, datainfo.get(APPID), i);
                this.getModel().setValue(LISTSERVICENAME, datainfo.get(SERVICENAME), i);
                this.getModel().setValue(LISTMETHODNAME, datainfo.get(METHODNAME), i);
                DynamicObjectCollection params = (DynamicObjectCollection)datainfo.get(ENTRYENTITY);
                StringBuilder sb = new StringBuilder();
                for (DynamicObject entry : params) {
                    sb.append(HBJMDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)entry));
                    sb.append("\t\n");
                }
                this.getModel().setValue(LISTPARAMS, (Object)sb, i);
                this.getModel().setValue(SERVICEDATE, datainfo.get(SERVICEDATE), i);
            }
        }
    }

    private String getCacheKey() {
        return CACHE_KEY_PRE + RequestContext.get().getCurrUserId();
    }

    private Object dealDynaObjectData(Object datas) {
        if (datas == null) {
            return null;
        }
        if (datas instanceof DynamicObjectCollection) {
            DynamicObjectCollection coll = (DynamicObjectCollection)datas;
            ArrayList<HashMap> returnInfo = new ArrayList<HashMap>(coll.size());
            for (DynamicObject oo : coll) {
                HashMap map = (HashMap)HBJMDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)oo);
                returnInfo.add(map);
            }
            return returnInfo;
        }
        if (datas instanceof List) {
            List coll = (List)datas;
            ArrayList<Object> returnInfo = new ArrayList<Object>(coll.size());
            for (Object oo : coll) {
                returnInfo.add(this.dealDynaObjectData(oo));
            }
            return returnInfo;
        }
        if (datas.getClass().isArray()) {
            Object[] arrs = (Object[])datas;
            ArrayList<Object> returnInfo = new ArrayList<Object>(arrs.length);
            for (Object oo : arrs) {
                returnInfo.add(this.dealDynaObjectData(oo));
            }
            return returnInfo;
        }
        if (datas instanceof DynamicObject) {
            HashMap map = (HashMap)HBJMDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)((DynamicObject)datas));
            return map;
        }
        if (datas instanceof Map) {
            Map mapdata = (Map)datas;
            for (Map.Entry entry : mapdata.entrySet()) {
                Object oo = this.dealDynaObjectData(entry.getValue());
                mapdata.put(entry.getKey(), oo);
            }
            return mapdata;
        }
        return datas;
    }
}

