/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hjm.business.jobscm.JobClassScmServiceHelper;
import kd.hr.hjm.common.constants.HJMConstants;
import kd.hrmp.hbjm.business.domain.repository.JobQueryRepository;

public class JobGradeRangePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final int DEFAULT_CAPACITY = 10;
    private static final String JOBGRADESEQ = "jobgradeseq";
    private static final String LOW_JOB_GRADE = "lowjobgrade";
    private static final String HIGH_JOB_GRADE = "highjobgrade";
    private Set<Long> globalIds = null;
    private static final String GLOBALFILTER = "globalFilter";
    private long jobScmId = 0L;
    private long jobFamilyId = 0L;
    private long jobClassId = 0L;
    private long jobGradeScmId = 0L;
    private int lowJobGrade = 0;
    private int highJobGrade = 0;

    public void initialize() {
        Object job;
        Object high;
        Object low;
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam("jobscmid") != null) {
            this.jobScmId = Long.parseLong(formShowParameter.getCustomParam("jobscmid").toString());
        }
        if (formShowParameter.getCustomParam("jobfamilyid") != null) {
            this.jobFamilyId = Long.parseLong(formShowParameter.getCustomParam("jobfamilyid").toString());
        }
        if (formShowParameter.getCustomParam("jobclassid") != null) {
            this.jobClassId = Long.parseLong(formShowParameter.getCustomParam("jobclassid").toString());
        }
        if (formShowParameter.getCustomParam("jobgradescm") != null) {
            this.jobGradeScmId = Long.parseLong(formShowParameter.getCustomParam("jobgradescm").toString());
        }
        if (Objects.nonNull(low = formShowParameter.getCustomParam("lowjobgradeseq")) && low instanceof Integer) {
            this.lowJobGrade = (Integer)low;
        }
        if (Objects.nonNull(high = formShowParameter.getCustomParam("highjobgradeseq")) && high instanceof Integer) {
            this.highJobGrade = (Integer)high;
        }
        if (Objects.nonNull(job = formShowParameter.getCustomParam("job")) && job instanceof Long) {
            this.queryJobInfo((Long)job);
        }
    }

    public void afterBindData(EventObject e) {
        Object highGrade;
        this.globalIds = new HashSet<Long>(8);
        QFilter filter = this.buildJobGradeFilter();
        this.getPageCache().put(GLOBALFILTER, SerializationUtils.serializeToBase64((Object)filter));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object lowGrade = formShowParameter.getCustomParam(LOW_JOB_GRADE);
        if (!Objects.isNull(lowGrade) && !ObjectUtils.isEmpty(this.globalIds) && this.globalIds.contains(lowGrade)) {
            this.getModel().setValue(LOW_JOB_GRADE, lowGrade);
            this.getView().updateView(LOW_JOB_GRADE);
        }
        if (!Objects.isNull(highGrade = formShowParameter.getCustomParam(HIGH_JOB_GRADE)) && !ObjectUtils.isEmpty(this.globalIds) && this.globalIds.contains(highGrade)) {
            this.getModel().setValue(HIGH_JOB_GRADE, highGrade);
            this.getView().updateView(HIGH_JOB_GRADE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("donothing".equals(formOperate.getOperateKey())) {
            DynamicObject highdataObj = (DynamicObject)this.getModel().getValue(HIGH_JOB_GRADE);
            DynamicObject lowdataObj = (DynamicObject)this.getModel().getValue(LOW_JOB_GRADE);
            HashMap<String, DynamicObject> returnData = new HashMap<String, DynamicObject>();
            if (Objects.isNull(lowdataObj) && !Objects.isNull(highdataObj)) {
                returnData.put(LOW_JOB_GRADE, highdataObj);
                returnData.put(HIGH_JOB_GRADE, highdataObj);
            } else if (!Objects.isNull(lowdataObj) && Objects.isNull(highdataObj)) {
                returnData.put(LOW_JOB_GRADE, lowdataObj);
                returnData.put(HIGH_JOB_GRADE, lowdataObj);
            } else {
                returnData.put(LOW_JOB_GRADE, lowdataObj);
                returnData.put(HIGH_JOB_GRADE, highdataObj);
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit lowJobGradeEdit = (BasedataEdit)this.getView().getControl(LOW_JOB_GRADE);
        lowJobGradeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit highJobGradeEdit = (BasedataEdit)this.getView().getControl(HIGH_JOB_GRADE);
        highJobGradeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter seqfilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String fieldKey = evt.getProperty().getName();
        IDataModel model = this.getModel();
        String filterStr = this.getPageCache().get(GLOBALFILTER);
        if (HRStringUtils.isNotEmpty((String)filterStr)) {
            QFilter scmFilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)filterStr);
            filters.add(scmFilter);
        }
        DynamicObject lowDy = (DynamicObject)model.getValue(LOW_JOB_GRADE);
        DynamicObject highDy = (DynamicObject)model.getValue(HIGH_JOB_GRADE);
        if (null != highDy && LOW_JOB_GRADE.equals(fieldKey)) {
            seqfilter = new QFilter(JOBGRADESEQ, "<=", highDy.get(JOBGRADESEQ));
            filters.add(seqfilter);
        } else if (null != lowDy && HIGH_JOB_GRADE.equals(fieldKey)) {
            seqfilter = new QFilter(JOBGRADESEQ, ">=", lowDy.get(JOBGRADESEQ));
            filters.add(seqfilter);
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(filters);
        String orderBy = "jobgradeseq asc";
        showParameter.getListFilterParameter().setOrderBy(orderBy);
    }

    private QFilter buildJobGradeFilter() {
        List<Long> ids;
        String sql = "";
        Object[] pObjects = null;
        if (this.jobGradeScmId != 0L) {
            sql = "select fjobgradeid from t_hbjm_jobgrade jobgrade where jobgrade.fid= ?  ";
            if (this.highJobGrade > 0 && this.lowJobGrade > 0) {
                pObjects = new Object[3];
                sql = sql + "and jobgrade.fjobgradeseq <= ?  and jobgrade.fjobgradeseq >= ? ";
                pObjects[1] = this.highJobGrade;
                pObjects[2] = this.lowJobGrade;
            } else if (this.highJobGrade > 0) {
                pObjects = new Object[2];
                sql = sql + "and jobgrade.fjobgradeseq <= ? ";
                pObjects[1] = this.highJobGrade;
            } else if (this.lowJobGrade > 0) {
                pObjects = new Object[2];
                sql = sql + "and jobgrade.fjobgradeseq >= ? ";
                pObjects[1] = this.lowJobGrade;
            } else {
                pObjects = new Object[]{this.jobGradeScmId};
            }
            ids = this.getGradeIds(sql, pObjects);
            if (!Objects.isNull(ids) && ids.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", ids);
                return qFilter;
            }
        }
        if (this.jobClassId != 0L) {
            pObjects = new Object[4];
            sql = "select fjobgradeid from t_hbjm_jobgrade jobgrade left join t_hbjm_jobfamilyscm jobfamilyscm on jobfamilyscm.fjobgradescmid = jobgrade.fid where jobfamilyscm.fjobfamilyid = ? and jobfamilyscm.fjobscmid = ? and jobgrade.fjobgradeseq <= ?  and jobgrade.fjobgradeseq >= ? ";
            DynamicObject dynamicObject = JobClassScmServiceHelper.getJobClassByJobClass((Long)this.jobClassId, (Long)this.jobScmId);
            pObjects[0] = this.jobFamilyId;
            pObjects[1] = this.jobScmId;
            if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
                pObjects[2] = dynamicObject.getInt("highjobgrade.jobgradeseq");
                pObjects[3] = dynamicObject.getInt("lowjobgrade.jobgradeseq");
                ids = this.getGradeIds(sql, pObjects);
                if (!Objects.isNull(ids) && ids.size() > 0) {
                    QFilter qFilter = new QFilter("id", "in", ids);
                    return qFilter;
                }
            }
        }
        if (this.jobFamilyId != 0L) {
            pObjects = new Object[2];
            sql = "select fjobgradeid from t_hbjm_jobgrade jobgrade left join t_hbjm_jobfamilyscm jobfamilyscm on jobfamilyscm.fjobgradescmid = jobgrade.fid where jobfamilyscm.fjobfamilyid = ? and jobfamilyscm.fjobscmid = ? ";
            pObjects[0] = this.jobFamilyId;
            pObjects[1] = this.jobScmId;
            ids = this.getGradeIds(sql, pObjects);
            if (!Objects.isNull(ids) && ids.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", ids);
                return qFilter;
            }
        }
        pObjects = new Object[1];
        sql = "select fjobgradeid from t_hbjm_jobgrade jobgrade left join t_hbjm_jobscm jobscm on jobgrade.fid = jobscm.fjobgradescmid where jobscm.fid = ?";
        pObjects[0] = this.jobScmId;
        ids = this.getGradeIds(sql, pObjects);
        QFilter qFilter = new QFilter("id", "in", ids);
        return qFilter;
    }

    private void queryJobInfo(long jobId) {
        DynamicObject job;
        if (jobId != 0L && !HRObjectUtils.isEmpty((Object)(job = JobQueryRepository.getInstance().queryJobInfoByID(Long.valueOf(jobId))))) {
            long jClass;
            long family;
            long scm = job.getLong("jobscm.id");
            if (scm != 0L) {
                this.jobScmId = scm;
            }
            if ((family = job.getLong("jobfamily.id")) != 0L) {
                this.jobFamilyId = family;
            }
            if ((jClass = job.getLong("jobclass.id")) != 0L) {
                this.jobClassId = jClass;
            }
            long low = job.getLong("lowjobGrade.jobGradescm.id");
            int lowSeq = job.getInt("lowjobGrade.jobGradeseq");
            long high = job.getLong("highjobGrade.jobGradescm.id");
            int highSeq = job.getInt("highjobGrade.jobGradeseq");
            if (low != 0L && high != 0L) {
                this.jobGradeScmId = low;
                this.lowJobGrade = lowSeq;
                this.highJobGrade = highSeq;
            } else if (low != 0L) {
                this.jobGradeScmId = low;
                this.lowJobGrade = lowSeq;
            } else if (high != 0L) {
                this.jobGradeScmId = high;
                this.highJobGrade = highSeq;
            }
        }
    }

    private List<Long> getGradeIds(String sql, Object[] pObjects) {
        sql = sql + " order by jobgrade.fjobgradeseq asc";
        List ids = (List)HRDBUtil.query((DBRoute)HJMConstants.DB_ROUTE_HJM, (String)sql, (Object[])pObjects, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> list = new ArrayList<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong(1));
                }
                return list;
            }
        });
        if (ObjectUtils.isEmpty(this.globalIds)) {
            this.globalIds.addAll(ids);
        } else {
            List finalIds = ids;
            this.globalIds = this.globalIds.stream().filter(id -> !ObjectUtils.isEmpty((Object)finalIds) && finalIds.contains(id)).collect(Collectors.toSet());
        }
        return ids;
    }
}

