/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hjm.business.jobscm.JobClassScmServiceHelper;
import kd.hr.hjm.common.constants.HJMConstants;
import kd.hrmp.hbjm.business.domain.repository.JobQueryRepository;

public class JobLevelRangePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final int DEFAULT_CAPACITY = 10;
    private static final String JOBLEVELSEQ = "joblevelseq";
    private static final String LOW_JOB_LEVEL = "lowjoblevel";
    private static final String HIGH_JOB_LEVEL = "highjoblevel";
    private Set<Long> globalIds = null;
    private static final String GLOBALFILTER = "globalFilter";
    private long jobScmId = 0L;
    private long jobFamilyId = 0L;
    private long jobClassId = 0L;
    private long jobLevelScmId = 0L;
    private int lowJobLevel = 0;
    private int highJobLevel = 0;

    public void initialize() {
        Object job;
        Object high;
        Object low;
        Object jobLevelScm;
        Object jobClassObj;
        Object jobFamilyObj;
        super.initialize();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object jobScmObj = customParams.get("jobscmid");
        if (jobScmObj != null) {
            this.jobScmId = Long.parseLong(jobScmObj.toString());
        }
        if ((jobFamilyObj = customParams.get("jobfamilyid")) != null) {
            this.jobFamilyId = Long.parseLong(jobFamilyObj.toString());
        }
        if ((jobClassObj = customParams.get("jobclassid")) != null) {
            this.jobClassId = Long.parseLong(jobClassObj.toString());
        }
        if ((jobLevelScm = customParams.get("joblevelscm")) != null) {
            this.jobLevelScmId = Long.parseLong(jobLevelScm.toString());
        }
        if (Objects.nonNull(low = customParams.get("lowjoblevelseq")) && low instanceof Integer) {
            this.lowJobLevel = (Integer)low;
        }
        if (Objects.nonNull(high = customParams.get("highjoblevelseq")) && high instanceof Integer) {
            this.highJobLevel = (Integer)high;
        }
        if (Objects.nonNull(job = customParams.get("job")) && job instanceof Long) {
            this.queryJobInfo((Long)job);
        }
    }

    public void afterBindData(EventObject e) {
        Object highLevel;
        this.globalIds = new HashSet<Long>(8);
        QFilter filter = this.buildJobLevelFilter();
        this.getPageCache().put(GLOBALFILTER, SerializationUtils.serializeToBase64((Object)filter));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object lowLevel = formShowParameter.getCustomParam(LOW_JOB_LEVEL);
        if (!Objects.isNull(lowLevel) && !ObjectUtils.isEmpty(this.globalIds) && this.globalIds.contains(lowLevel)) {
            this.getModel().setValue(LOW_JOB_LEVEL, lowLevel);
            this.getView().updateView(LOW_JOB_LEVEL);
        }
        if (!Objects.isNull(highLevel = formShowParameter.getCustomParam(HIGH_JOB_LEVEL)) && !ObjectUtils.isEmpty(this.globalIds) && this.globalIds.contains(highLevel)) {
            this.getModel().setValue(HIGH_JOB_LEVEL, highLevel);
            this.getView().updateView(HIGH_JOB_LEVEL);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("donothing".equals(formOperate.getOperateKey())) {
            DynamicObject highdataObj = (DynamicObject)this.getModel().getValue(HIGH_JOB_LEVEL);
            DynamicObject lowdataObj = (DynamicObject)this.getModel().getValue(LOW_JOB_LEVEL);
            HashMap<String, DynamicObject> returnData = new HashMap<String, DynamicObject>();
            if (Objects.isNull(lowdataObj) && !Objects.isNull(highdataObj)) {
                returnData.put(LOW_JOB_LEVEL, highdataObj);
                returnData.put(HIGH_JOB_LEVEL, highdataObj);
            } else if (!Objects.isNull(lowdataObj) && Objects.isNull(highdataObj)) {
                returnData.put(LOW_JOB_LEVEL, lowdataObj);
                returnData.put(HIGH_JOB_LEVEL, lowdataObj);
            } else {
                returnData.put(LOW_JOB_LEVEL, lowdataObj);
                returnData.put(HIGH_JOB_LEVEL, highdataObj);
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit lowjoblevelEdit = (BasedataEdit)this.getView().getControl(LOW_JOB_LEVEL);
        lowjoblevelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit highjoblevelEdit = (BasedataEdit)this.getView().getControl(HIGH_JOB_LEVEL);
        highjoblevelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter seqfilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String fieldKey = evt.getProperty().getName();
        IDataModel model = this.getModel();
        String filterStr = this.getPageCache().get(GLOBALFILTER);
        if (HRStringUtils.isNotEmpty((String)filterStr)) {
            QFilter scmFilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)filterStr);
            filters.add(scmFilter);
        }
        DynamicObject lowDy = (DynamicObject)model.getValue(LOW_JOB_LEVEL);
        DynamicObject highDy = (DynamicObject)model.getValue(HIGH_JOB_LEVEL);
        if (null != highDy && LOW_JOB_LEVEL.equals(fieldKey)) {
            seqfilter = new QFilter(JOBLEVELSEQ, "<=", highDy.get(JOBLEVELSEQ));
            filters.add(seqfilter);
        } else if (null != lowDy && HIGH_JOB_LEVEL.equals(fieldKey)) {
            seqfilter = new QFilter(JOBLEVELSEQ, ">=", lowDy.get(JOBLEVELSEQ));
            filters.add(seqfilter);
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setQFilters(filters);
        String orderBy = "joblevelseq asc";
        showParameter.getListFilterParameter().setOrderBy(orderBy);
    }

    private QFilter buildJobLevelFilter() {
        List<Long> ids;
        String sql = "";
        Object[] pObjects = null;
        if (this.jobLevelScmId != 0L) {
            sql = "select fjoblevelid from t_hbjm_joblevel joblevel where joblevel.fid= ?  ";
            if (this.highJobLevel > 0 && this.lowJobLevel > 0) {
                pObjects = new Object[3];
                sql = sql + "and joblevel.fjoblevelseq <= ?  and joblevel.fjoblevelseq >= ? ";
                pObjects[1] = this.highJobLevel;
                pObjects[2] = this.lowJobLevel;
            } else if (this.highJobLevel > 0) {
                pObjects = new Object[2];
                sql = sql + "and joblevel.fjoblevelseq <= ? ";
                pObjects[1] = this.highJobLevel;
            } else if (this.lowJobLevel > 0) {
                pObjects = new Object[2];
                sql = sql + "and joblevel.fjoblevelseq >= ? ";
                pObjects[1] = this.lowJobLevel;
            } else {
                pObjects = new Object[]{this.jobLevelScmId};
            }
            ids = this.getLeverIds(sql, pObjects);
            if (!Objects.isNull(ids) && ids.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", ids);
                return qFilter;
            }
        }
        if (this.jobClassId != 0L) {
            pObjects = new Object[4];
            sql = "select fjoblevelid from t_hbjm_joblevel joblevel left join t_hbjm_jobfamilyscm jobfamilyscm on jobfamilyscm.fjoblevelscmid = joblevel.fid where jobfamilyscm.fjobfamilyid = ? and jobfamilyscm.fjobscmid = ? and joblevel.fjoblevelseq <= ?  and joblevel.fjoblevelseq >= ?";
            DynamicObject dynamicObject = JobClassScmServiceHelper.getJobClassByJobClass((Long)this.jobClassId, (Long)this.jobScmId);
            pObjects[0] = this.jobFamilyId;
            pObjects[1] = this.jobScmId;
            Boolean isEmpty = HRObjectUtils.isEmpty((Object)dynamicObject);
            pObjects[2] = isEmpty != false ? 0 : dynamicObject.getInt("highjoblevel.joblevelseq");
            pObjects[3] = isEmpty != false ? 0 : dynamicObject.getInt("lowjoblevel.joblevelseq");
            ids = this.getLeverIds(sql, pObjects);
            if (!Objects.isNull(ids) && ids.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", ids);
                return qFilter;
            }
        }
        if (this.jobFamilyId != 0L) {
            pObjects = new Object[2];
            sql = "select fjoblevelid from t_hbjm_joblevel joblevel left join t_hbjm_jobfamilyscm jobfamilyscm on jobfamilyscm.fjoblevelscmid = joblevel.fid where jobfamilyscm.fjobfamilyid = ? and jobfamilyscm.fjobscmid = ? ";
            pObjects[0] = this.jobFamilyId;
            pObjects[1] = this.jobScmId;
            ids = this.getLeverIds(sql, pObjects);
            if (!Objects.isNull(ids) && ids.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", ids);
                return qFilter;
            }
        }
        pObjects = new Object[1];
        sql = "select fjoblevelid from t_hbjm_joblevel joblevel left join t_hbjm_jobscm jobscm on joblevel.fid = jobscm.fjoblevelscmid where jobscm.fid = ?";
        pObjects[0] = this.jobScmId;
        ids = this.getLeverIds(sql, pObjects);
        QFilter qFilter = new QFilter("id", "in", ids);
        return qFilter;
    }

    private void queryJobInfo(long jobId) {
        DynamicObject job;
        if (jobId != 0L && !HRObjectUtils.isEmpty((Object)(job = JobQueryRepository.getInstance().queryJobInfoByID(Long.valueOf(jobId))))) {
            long jClass;
            long family;
            long scm = job.getLong("jobscm.id");
            if (scm != 0L) {
                this.jobScmId = scm;
            }
            if ((family = job.getLong("jobfamily.id")) != 0L) {
                this.jobFamilyId = family;
            }
            if ((jClass = job.getLong("jobclass.id")) != 0L) {
                this.jobClassId = jClass;
            }
            long low = job.getLong("lowjoblevel.joblevelscm.id");
            int lowSeq = job.getInt("lowjoblevel.joblevelseq");
            long high = job.getLong("highjoblevel.joblevelscm.id");
            int highSeq = job.getInt("highjoblevel.joblevelseq");
            if (low != 0L && high != 0L) {
                this.jobLevelScmId = low;
                this.lowJobLevel = lowSeq;
                this.highJobLevel = highSeq;
            } else if (low != 0L) {
                this.jobLevelScmId = low;
                this.lowJobLevel = lowSeq;
            } else if (high != 0L) {
                this.jobLevelScmId = high;
                this.highJobLevel = highSeq;
            }
        }
    }

    private List<Long> getLeverIds(String sql, Object[] pObjects) {
        sql = sql + " order by joblevel.fjoblevelseq asc";
        List ids = (List)HRDBUtil.query((DBRoute)HJMConstants.DB_ROUTE_HJM, (String)sql, (Object[])pObjects, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> list = new ArrayList<Long>(10);
                while (rs.next()) {
                    list.add(rs.getLong(1));
                }
                return list;
            }
        });
        if (ObjectUtils.isEmpty(this.globalIds)) {
            this.globalIds.addAll(ids);
        } else {
            List finalIds = ids;
            this.globalIds = this.globalIds.stream().filter(id -> !ObjectUtils.isEmpty((Object)finalIds) && finalIds.contains(id)).collect(Collectors.toSet());
        }
        return ids;
    }
}

