/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.job;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hjm.formplugin.web.jobscm.JobScmBaseInfoPlugin;
import kd.hrmp.hbjm.business.domain.application.impl.job.JobApplicationImpl;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqScmRepository;
import kd.hrmp.hbjm.business.utils.JobUtils;

public class JobBasedataEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(JobScmBaseInfoPlugin.class);
    private static final String HJM_JOBGRADERANGE_BAK = "hjm_jobgraderange_bak";
    private static final String HJM_JOBLEVELRANGE_BAK = "hjm_joblevelrange_bak";
    private static final String HIGHJOBGRADE = "highjobgrade";
    private static final String LOWJOBGRADE = "lowjobgrade";
    private static final String HIGHJOBLEVEL = "highjoblevel";
    private static final String LOWJOBLEVEL = "lowjoblevel";
    private static final String JOBGRADERANG = "jobgraderang";
    private static final String JOBLEVELRANG = "joblevelrang";
    private String triggerKey = "";
    private boolean pageInit = false;

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        Object currentDataId = showParameter.getCustomParam("currentDataId");
        Object currentObjectPKId = showParameter.getCustomParam("currentObjectPKId");
        Object isHisView = showParameter.getCustomParam("isHisView");
        if (currentDataId != null) {
            DynamicObject job = JobRepository.getInstance().findById((Long)currentDataId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u804c\u4f4d - ", (String)"JobListPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]).concat(job.getString("name")));
        } else if (currentObjectPKId == null && isHisView == null) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u804c\u4f4d", (String)"JobListPlugin_2", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        }
        showParameter.setCustomParam("hbss_entitytype_id", (Object)"1030");
        showParameter.setCustomParam("isshowbsed", (Object)true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{JOBLEVELRANG});
        this.addClickListeners(new String[]{JOBGRADERANG});
        BasedataEdit jobSeqEdit = (BasedataEdit)this.getView().getControl("jobseq");
        jobSeqEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobFamilyEdit = (BasedataEdit)this.getView().getControl("jobfamily");
        jobFamilyEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobClassEdit = (BasedataEdit)this.getView().getControl("jobclass");
        jobClassEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jobScmEdit = (BasedataEdit)this.getView().getControl("jobscm");
        jobScmEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changedesc = (BasedataEdit)this.getView().getControl("changedesc");
        changedesc.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        ITreeListView treeView;
        Boolean isSysPreSet;
        this.pageInit = true;
        DynamicObject baseDataEntity = this.getView().getModel().getDataEntity();
        if (JobUtils.isEnablingOrNoAuditData((DynamicObject)baseDataEntity)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
        }
        if ((isSysPreSet = Boolean.valueOf(baseDataEntity.getBoolean("issyspreset"))).booleanValue()) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
        Object his_action = this.getView().getFormShowParameter().getCustomParam("his_action");
        IFormView parentview = this.getView().getParentView();
        if (Objects.nonNull(his_action)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
        if (parentview instanceof IListView && ObjectUtils.isEmpty((Object)his_action) && (treeView = ((IListView)parentview).getTreeListView()) != null) {
            String nodeId = (String)treeView.getTreeModel().getCurrentNodeId();
            if (!ObjectUtils.isEmpty((Object)nodeId)) {
                String[] ids = nodeId.split("#");
                if (ids.length >= 2) {
                    this.getModel().setValue("jobscm", (Object)ids[1].substring(1));
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"jobseq", "jobfamily", "jobclass"});
                }
                if (ids.length >= 3) {
                    this.getModel().setValue("jobseq", (Object)ids[2].substring(1));
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"jobfamily", "jobclass"});
                }
                if (ids.length >= 4) {
                    this.getModel().setValue("jobfamily", (Object)ids[3].substring(1));
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"jobclass", JOBGRADERANG, JOBLEVELRANG});
                }
                if (ids.length >= 5) {
                    this.getModel().setValue("jobclass", (Object)ids[ids.length - 1].substring(1));
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"jobseq", "jobfamily", "jobclass"});
            }
        }
        this.bindJobGradeAndlevelData();
        Boolean isHisView = (Boolean)this.getView().getFormShowParameter().getCustomParam("isHisView");
        if (this.getView().getParentView() != null) {
            String billFormId = this.getView().getParentView().getFormShowParameter().getIdentifyFormId();
            if (isHisView != null && isHisView.booleanValue() || billFormId != null && billFormId.contains("hjm_jobchangerecord")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
            }
        }
        this.dealDisableData();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if ("confirmchangenoaudit".equals(evt.getOperationKey())) {
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().getPageCache().put("lastButton", evt.getOperationKey());
            }
            Date blsed = JobRepository.getInstance().getBlsedByBsed((Date)this.getModel().getValue("bsed"), ((Long)this.getModel().getValue("boid")).longValue());
            this.getModel().setValue("bsled", (Object)blsed);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit bsededit = (DateEdit)this.getView().getControl("bsed");
        bsededit.setMaxDate(new Date());
        String pageStatus = this.getPageCache().get("pageStatus");
        if ("edit".equals(pageStatus)) {
            this.getModel().setValue("changedesc", null);
            this.getModel().setValue("changedesc2", null);
            this.getModel().setDataChanged(false);
        }
        if ("view".equals(this.getView().getFormShowParameter().getCustomParam("pageStatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"insertdatabtn"});
        }
        if ("edit".equals(pageStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobscm"});
        }
    }

    public void dealDisableData() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus == OperationStatus.VIEW) {
            return;
        }
        DynamicObject scm = this.getModel().getDataEntity().getDynamicObject("jobscm");
        if (!ObjectUtils.isEmpty((Object)scm) && !HRStringUtils.equals((String)scm.getString("enable"), (String)"1")) {
            this.setValueNull("jobscm", "jobseq", "jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobseq", "jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG});
            return;
        }
        DynamicObject seq = this.getModel().getDataEntity().getDynamicObject("jobseq");
        if (!ObjectUtils.isEmpty((Object)seq) && !HRStringUtils.equals((String)seq.getString("enable"), (String)"1")) {
            this.setValueNull("jobseq", "jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG});
            return;
        }
        DynamicObject family = this.getModel().getDataEntity().getDynamicObject("jobfamily");
        if (!ObjectUtils.isEmpty((Object)family) && !HRStringUtils.equals((String)family.getString("enable"), (String)"1")) {
            this.setValueNull("jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobclass", JOBGRADERANG, JOBLEVELRANG});
            return;
        }
        DynamicObject jobClass = this.getModel().getDataEntity().getDynamicObject("jobclass");
        if (!ObjectUtils.isEmpty((Object)jobClass) && !HRStringUtils.equals((String)jobClass.getString("enable"), (String)"1")) {
            this.setValueNull("jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
            this.getView().setEnable(Boolean.FALSE, new String[]{JOBGRADERANG, JOBLEVELRANG});
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        DynamicObject job = this.getModel().getDataEntity();
        Control source = (Control)evt.getSource();
        FormShowParameter form = new FormShowParameter();
        form.setCustomParam("jobscmid", (Object)job.getString("jobscm.id"));
        form.setCustomParam("jobfamilyid", (Object)job.getString("jobfamily.id"));
        form.setCustomParam("jobclassid", (Object)job.getString("jobclass.id"));
        form.getOpenStyle().setShowType(ShowType.Modal);
        if (JOBGRADERANG.equals(source.getKey())) {
            form.setFormId("hjm_jobgraderange");
            form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HJM_JOBGRADERANGE_BAK));
            long highjobgradeId = job.getLong("highjobgrade.id");
            long lowjobgradeId = job.getLong("lowjobgrade.id");
            form.setCustomParam(LOWJOBGRADE, (Object)(lowjobgradeId == 0L ? null : Long.valueOf(lowjobgradeId)));
            form.setCustomParam(HIGHJOBGRADE, (Object)(highjobgradeId == 0L ? null : Long.valueOf(highjobgradeId)));
            this.getView().showForm(form);
        } else if (JOBLEVELRANG.equals(source.getKey())) {
            form.setFormId("hjm_joblevelrange");
            form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HJM_JOBLEVELRANGE_BAK));
            long highjoblevelId = job.getLong("highjoblevel.id");
            long lowjoblevelId = job.getLong("lowjoblevel.id");
            if (highjoblevelId != 0L) {
                form.setCustomParam(HIGHJOBLEVEL, (Object)highjoblevelId);
            }
            if (lowjoblevelId != 0L) {
                form.setCustomParam(LOWJOBLEVEL, (Object)lowjoblevelId);
            }
            this.getView().showForm(form);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing || source instanceof Save) {
            String opKey;
            DefaultEntityOperate btn = (DefaultEntityOperate)source;
            switch (opKey = btn.getOperateKey()) {
                case "confirmchange": 
                case "confirmchangenoaudit": 
                case "save": {
                    String joblevelrang;
                    String jobgraderang = (String)this.getModel().getValue(JOBGRADERANG);
                    if (StringUtils.isBlank((String)jobgraderang)) {
                        this.getModel().setValue(HIGHJOBGRADE, null);
                        this.getModel().setValue(LOWJOBGRADE, null);
                    }
                    if (!StringUtils.isBlank((String)(joblevelrang = (String)this.getModel().getValue(JOBLEVELRANG)))) break;
                    this.getModel().setValue(HIGHJOBLEVEL, null);
                    this.getModel().setValue(LOWJOBLEVEL, null);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (("confirmchange".equals(args.getOperateKey()) || "confirmchangenoaudit".equals(args.getOperateKey())) && args.getOperationResult().isSuccess()) {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            BillList billList = (BillList)parentView.getControl("billlistap");
            if (billList == null) {
                return;
            }
            billList.refresh();
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        HashMap returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (HJM_JOBGRADERANGE_BAK.equals(actionId)) {
            HashMap returnData2 = (HashMap)evt.getReturnData();
            if (returnData2 != null) {
                DynamicObject highjobgrade = (DynamicObject)returnData2.get(HIGHJOBGRADE);
                DynamicObject lowjobgrade = (DynamicObject)returnData2.get(LOWJOBGRADE);
                this.setFieldRange(JOBGRADERANG, lowjobgrade, LOWJOBGRADE, highjobgrade, HIGHJOBGRADE);
            }
        } else if (HJM_JOBLEVELRANGE_BAK.equals(actionId) && (returnData = (HashMap)evt.getReturnData()) != null) {
            DynamicObject highjoblevel = (DynamicObject)returnData.get(HIGHJOBLEVEL);
            DynamicObject lowjoblevel = (DynamicObject)returnData.get(LOWJOBLEVEL);
            this.setFieldRange(JOBLEVELRANG, lowjoblevel, LOWJOBLEVEL, highjoblevel, HIGHJOBLEVEL);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.isEmpty((String)this.triggerKey) && !this.pageInit) {
            this.triggerKey = fieldKey;
            this.enableOrdisableCategoryControl(fieldKey);
        }
        this.dealJobGradeEnable(fieldKey);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        DynamicObject jobscm = (DynamicObject)this.getModel().getValue("jobscm");
        QFilter qFilter = null;
        if (HRStringUtils.equals((String)fieldKey, (String)"jobseq")) {
            qFilter = this.buildJobSeqFilter(jobscm);
        } else if (HRStringUtils.equals((String)fieldKey, (String)"jobfamily")) {
            qFilter = this.buildJobFamilyFilter();
        } else if (HRStringUtils.equals((String)fieldKey, (String)"jobclass")) {
            qFilter = this.buildJobClassFilter();
        } else if (HRStringUtils.equals((String)fieldKey, (String)"changedesc")) {
            qFilter = this.buildChangeDescFilter();
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        Long jobFamilyId = this.getModel().getDataEntity().getLong("jobfamily.id");
        Long jobSeqId = this.getModel().getDataEntity().getLong("jobseq.id");
        Long scmId = this.getModel().getDataEntity().getLong("jobscm.id");
        if (HRStringUtils.equals((String)fieldKey, (String)"jobclass") && !ObjectUtils.isEmpty((Object)jobFamilyId)) {
            showParameter.getShowParameter().setCustomParam("selectedJobFamilyId", (Object)jobFamilyId);
            showParameter.getShowParameter().setCustomParam("selectedScmId", (Object)scmId);
            showParameter.getShowParameter().setCustomParam("selectedJobSeqId", (Object)jobSeqId);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter buildChangeDescFilter() {
        QFilter qFilter = null;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object currentObjectPKId = showParameter.getCustomParam("currentObjectPKId");
        if (ObjectUtils.isEmpty((Object)currentObjectPKId)) {
            qFilter = new QFilter("changetype.fbasedataid.id", "=", (Object)1010L);
            qFilter.or(new QFilter("changetype.fbasedataid", "=", null));
        } else {
            qFilter = new QFilter("changetype.fbasedataid.id", "=", (Object)1020L);
            qFilter.or(new QFilter("changetype.fbasedataid", "=", null));
        }
        return qFilter;
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject jobFamily;
        DynamicObject ob = this.getModel().getDataEntity();
        DynamicObject jobSeq = ob.getDynamicObject("jobseq");
        if (ObjectUtils.isEmpty((Object)jobSeq) && !ObjectUtils.isEmpty((Object)(jobFamily = ob.getDynamicObject("jobfamily")))) {
            ob.set("jobseq", jobFamily.get("jobseq"));
        }
        JobApplicationImpl application = new JobApplicationImpl();
        application.dealGradeOrLevelImportToNull(e.getSourceData(), ob);
        application.dealChangeReasonImportToNull(e.getSourceData(), ob);
        super.afterImportData(e);
    }

    private void setFieldRange(String fieldJobObject, DynamicObject lowObject, String lowString, DynamicObject highObject, String highString) {
        String lowJobString = "";
        String highJobString = "";
        String massage = "";
        if (highObject != null) {
            highJobString = highObject.getString("name");
        }
        if (lowObject != null) {
            lowJobString = lowObject.getString("name");
        }
        if (StringUtils.isEmpty((String)lowJobString) && StringUtils.isEmpty((String)highJobString)) {
            this.getModel().setValue(fieldJobObject, (Object)"");
        }
        if (StringUtils.isNotEmpty((String)lowJobString)) {
            massage = MessageFormat.format(ResManager.loadKDString((String)"{0}\u53ca\u4ee5\u4e0a", (String)"JobBasedataEdit_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]), lowJobString);
            this.getModel().setValue(fieldJobObject, (Object)massage);
        }
        if (StringUtils.isNotEmpty((String)highJobString)) {
            massage = MessageFormat.format(ResManager.loadKDString((String)"{0}\u53ca\u4ee5\u4e0b", (String)"JobBasedataEdit_2", (String)"odc-hjm-formplugin", (Object[])new Object[0]), highJobString);
            this.getModel().setValue(fieldJobObject, (Object)massage);
        }
        if (StringUtils.isNotEmpty((String)highJobString) && StringUtils.isNotEmpty((String)lowJobString)) {
            this.getModel().setValue(fieldJobObject, (Object)(lowJobString + "-" + highJobString));
        }
        this.getModel().setValue(lowString, (Object)lowObject);
        this.getModel().setValue(highString, (Object)highObject);
    }

    private void enableOrdisableCategoryControl(String changeKey) {
        if (changeKey.equals("jobscm")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"jobseq"});
            if (this.getModel().getValue("jobscm") == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"jobseq"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobfamily", "jobclass"});
            this.setValueNull("jobseq", "jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
        } else if (changeKey.equals("jobseq")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"jobfamily"});
            if (this.getModel().getValue("jobseq") == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"jobfamily"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobclass"});
            this.setValueNull("jobfamily", "jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
        } else if (changeKey.equals("jobfamily")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"jobclass"});
            if (this.getModel().getValue("jobfamily") == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"jobclass"});
            }
            this.setValueNull("jobclass", JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
        } else if (changeKey.equals("jobclass")) {
            this.setValueNull(JOBGRADERANG, JOBLEVELRANG, HIGHJOBGRADE, LOWJOBGRADE, HIGHJOBLEVEL, LOWJOBLEVEL);
        }
    }

    private void setValueNull(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    private QFilter buildJobSeqFilter(DynamicObject jobscm) {
        if (jobscm == null) {
            return new QFilter("1", "!=", (Object)1);
        }
        DynamicObject[] dynamicObject = JobSeqScmRepository.getJobSeqByScmId((Long)jobscm.getLong("id"));
        Long[] jobSeqIds = this.getIds(dynamicObject, "jobseq.id");
        QFilter qFilter = null;
        qFilter = jobSeqIds != null && jobSeqIds.length > 0 ? new QFilter("id", "in", (Object)jobSeqIds) : new QFilter("id", "=", (Object)0);
        return qFilter;
    }

    private QFilter buildJobFamilyFilter() {
        DynamicObject jobScmObject = (DynamicObject)this.getView().getModel().getValue("jobscm");
        if (jobScmObject == null) {
            return new QFilter("1", "!=", (Object)1);
        }
        DynamicObject[] dynamicObject = JobSeqScmRepository.getJobFamilyByScmId((Long)jobScmObject.getLong("id"));
        Long[] jobFamilyIds = this.getIds(dynamicObject, "jobfamily.id");
        QFilter qFilter = new QFilter("id", "in", (Object)jobFamilyIds);
        DynamicObject jobSeqObject = (DynamicObject)this.getView().getModel().getValue("jobseq");
        if (jobSeqObject != null) {
            qFilter.and("jobseq", "in", jobSeqObject.get("id"));
        } else {
            qFilter.and("jobseq", "in", (Object)"");
        }
        return qFilter;
    }

    private QFilter buildJobClassFilter() {
        DynamicObject jobScmObject = (DynamicObject)this.getView().getModel().getValue("jobscm");
        if (jobScmObject == null) {
            return new QFilter("1", "!=", (Object)1);
        }
        DynamicObject[] dynamicObject = JobSeqScmRepository.getJobClassByScmId((Long)jobScmObject.getLong("id"));
        Long[] jobClassIds = this.getIds(dynamicObject, "jobclass.id");
        QFilter qFilter = new QFilter("id", "in", (Object)jobClassIds);
        DynamicObject jobFamilyObject = (DynamicObject)this.getView().getModel().getValue("jobfamily");
        if (jobFamilyObject != null) {
            qFilter.and("jobfamily", "in", jobFamilyObject.get("id"));
        } else {
            qFilter.and("jobfamily", "in", (Object)"");
        }
        DynamicObject jobSeqObject = (DynamicObject)this.getView().getModel().getValue("jobseq");
        if (jobSeqObject != null) {
            qFilter.and("jobseq", "in", jobSeqObject.get("id"));
        } else {
            qFilter.and("jobseq", "in", (Object)"");
        }
        return qFilter;
    }

    private Long[] getIds(DynamicObject[] dynamicObjects, String param) {
        Long[] ids = new Long[dynamicObjects.length];
        int i = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            ids[i] = dynamicObject.getLong(param);
            ++i;
        }
        return ids;
    }

    private void bindJobGradeAndlevelData() {
        DynamicObject job = this.getModel().getDataEntity();
        DynamicObject highjobgrade = (DynamicObject)job.get(HIGHJOBGRADE);
        DynamicObject lowjobgrade = (DynamicObject)job.get(LOWJOBGRADE);
        DynamicObject highjoblevel = (DynamicObject)job.get(HIGHJOBLEVEL);
        DynamicObject lowjoblevel = (DynamicObject)job.get(LOWJOBLEVEL);
        this.setFieldRange(JOBGRADERANG, lowjobgrade, LOWJOBGRADE, highjobgrade, HIGHJOBGRADE);
        this.setFieldRange(JOBLEVELRANG, lowjoblevel, LOWJOBLEVEL, highjoblevel, HIGHJOBLEVEL);
    }

    private void dealJobGradeEnable(String fieldKey) {
        if (fieldKey.equals("jobfamily")) {
            DynamicObject jobfamily = (DynamicObject)this.getModel().getValue("jobfamily");
            if (jobfamily == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{JOBLEVELRANG, JOBGRADERANG});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{JOBLEVELRANG, JOBGRADERANG});
            }
        }
    }
}

