/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.job;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hbjm.business.domain.application.impl.job.JobApplicationImpl;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.model.JobChangeInfoModel;
import kd.hrmp.hbjm.common.model.JobBillTimeline;
import kd.hrmp.hbjm.common.model.JobBillTimelineCustomJson;
import kd.hrmp.hbjm.common.model.JobBillTimelineResult;

public class JobBillTimelinePlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(JobBillTimelinePlugin.class);
    private String eventName = "init";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String pageStatue = this.getPageCache().get("pageStatus");
        if (!HRStringUtils.equals((String)"edit", (String)pageStatue) && !HRStringUtils.equals((String)"addnew", (String)pageStatue)) {
            String lastButton;
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            Long boid = this.getModel().getDataEntity().getLong("boid");
            JobApplicationImpl IJobApplication2 = new JobApplicationImpl();
            Map result = IJobApplication2.getAllChangeInfoByBoids((Set)Sets.newHashSet((Object[])new Long[]{boid}));
            List<Object> timelineList = new ArrayList();
            if (!ObjectUtils.isEmpty((Object)result)) {
                List infos = (List)result.get(boid);
                timelineList = this.getJobBillTimelines(infos);
            }
            if ("confirmchangenoaudit".equals(lastButton = this.getPageCache().get("lastButton")) || "confirmchange".equals(lastButton)) {
                this.eventName = "update";
            }
            JobBillTimelineResult jobBillTimelineResult = new JobBillTimelineResult(this.eventName, 1, timelineList);
            if (customcontrol != null) {
                customcontrol.setData((Object)jobBillTimelineResult);
            }
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        super.beforeDoOperation(eventArgs);
        FormOperate formOperate = (FormOperate)eventArgs.getSource();
        if (StringUtils.equals((CharSequence)"dochange", (CharSequence)formOperate.getOperateKey())) {
            this.eventName = "update";
        }
    }

    public void customEvent(CustomEventArgs eventArgs) {
        String key = eventArgs.getEventName();
        String args = eventArgs.getEventArgs();
        switch (key) {
            case "showdetail": {
                try {
                    this.openJobHisDiff(args);
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
                break;
            }
        }
    }

    private void openJobHisDiff(String args) throws IOException {
        JobBillTimelineCustomJson jobBillTimelineCustomJson = (JobBillTimelineCustomJson)HRJSONUtils.cast((String)args, JobBillTimelineCustomJson.class);
        BillShowParameter formShowParameter = new BillShowParameter();
        IFormView formView = this.getView();
        formShowParameter.setPageId(jobBillTimelineCustomJson.getCurrentBillId() + '_' + (formView.getMainView() == null ? formView.getPageId() : formView.getMainView().getPageId()));
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setBillStatus(BillOperationStatus.VIEW);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId("hjm_jobhr");
        formShowParameter.setPkId((Object)jobBillTimelineCustomJson.getCurrentBillId());
        DynamicObject job = JobRepository.getInstance().findById(Long.valueOf(jobBillTimelineCustomJson.getCurrentBillId()));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u804c\u4f4d - ", (String)"JobListPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]).concat(job.getString("name")));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OperationStatus.EDIT.name()));
        formShowParameter.setCustomParam("isHisView", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private List<JobBillTimeline> getJobBillTimelines(List<JobChangeInfoModel> models) {
        ArrayList<JobBillTimeline> timelineList = new ArrayList<JobBillTimeline>(models.size());
        for (int i = 0; i < models.size(); ++i) {
            JobChangeInfoModel model = models.get(i);
            DynamicObject job = model.getJobHis();
            JobBillTimeline jobBillTimeline = new JobBillTimeline();
            Date bsed = job.getDate("bsed");
            if (bsed != null) {
                jobBillTimeline.setTime(HRInteDateTimeUtil.formatDate((String)job.getDataEntityType().getName(), (String)"bsed", (Date)bsed));
            }
            jobBillTimeline.setName(job.getString("name"));
            String operator = job.getString("modifier.name");
            jobBillTimeline.setOperator(operator == null ? "-" : operator);
            JobBillTimelineCustomJson jobBillTimelineCustomJson = new JobBillTimelineCustomJson();
            jobBillTimelineCustomJson.setCurrentBillId(job.getString("id"));
            DynamicObject event = model.getEventDetail();
            if (!ObjectUtils.isEmpty((Object)event)) {
                DynamicObject changetype;
                DynamicObject changereason = event.getDynamicObject("changereason");
                if (!ObjectUtils.isEmpty((Object)changereason)) {
                    jobBillTimelineCustomJson.setChangereasonId(Long.valueOf(changereason.getLong("id")));
                    jobBillTimeline.setChangeReason(changereason.getString("name"));
                }
                if (!ObjectUtils.isEmpty((Object)(changetype = event.getDynamicObject("changetype")))) {
                    jobBillTimelineCustomJson.setChangetypeId(Long.valueOf(changetype.getLong("id")));
                    jobBillTimeline.setChangeType(changetype.getString("name"));
                }
            }
            if (i + 1 < models.size()) {
                jobBillTimelineCustomJson.setPreBillId(String.valueOf(models.get(i + 1).getDataId()));
            }
            jobBillTimeline.setCustomJson(jobBillTimelineCustomJson);
            timelineList.add(jobBillTimeline);
        }
        return timelineList;
    }
}

