/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.job;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.common.util.QFilterHelper;

public class JobHisListPlugin
extends HRDataBaseList {
    public void addItemClickListeners(String ... keys) {
        super.addItemClickListeners(keys);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("query".equals(key)) {
            ListView view = (ListView)this.getView();
            view.refresh();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"query"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        DynamicObject job = JobRepository.getInstance().findById((Long)primaryKeyValue);
        if (job != null) {
            IListView listview = (IListView)this.getView();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("hjm_jobhr");
            showParameter.setPkId(listview.getFocusRowPkId());
            showParameter.setCaption(ResManager.loadKDString((String)"\u804c\u4f4d - ", (String)"JobListPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]).concat(job.getString("name")));
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("currentObjectPKId", (Object)String.valueOf(listview.getFocusRowPkId()));
            showParameter.setCustomParam("pageStatus", (Object)"view");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobListPlugin_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        Date bsed = (Date)this.getModel().getValue("bsed");
        DynamicObjectCollection useorgs = (DynamicObjectCollection)this.getModel().getValue("useorg");
        if (bsed == null || useorgs.size() == 0) {
            setFilterEvent.addCustomQFilter(new QFilter("1", "!=", (Object)1));
            return;
        }
        QFilter filter = new QFilter("bsed", "<=", (Object)bsed);
        filter.and(new QFilter("bsled", ">=", (Object)bsed));
        QFilter orgFilter = null;
        for (DynamicObject org : useorgs) {
            long orgId = org.getDynamicObject("fbasedataid").getLong("id");
            if (orgFilter == null) {
                orgFilter = new QFilter("useorg", "=", (Object)orgId);
                continue;
            }
            orgFilter.or(new QFilter("useorg", "=", (Object)orgId));
        }
        filter.and(orgFilter);
        filter.and(new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(QFilterHelper.getIsHisVersionQFilter());
        setFilterEvent.addCustomQFilter(filter);
        String commonOrderBy = "jobscm,jobseq,jobfamily,jobclass,number";
        setFilterEvent.setOrderBy(commonOrderBy);
    }
}

