/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.job;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.utils.model.JobDisableModel;

public class JobListPlugin
extends HRDataBaseList {
    private static final String DISABLE_PAGE = "hjm_jobdisable";

    public void addItemClickListeners(String ... keys) {
        super.addItemClickListeners(keys);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String opKey;
            Donothing operation = (Donothing)source;
            switch (opKey = operation.getOperateKey()) {
                case "donothing_changerecord": {
                    ListShowParameter lsp = new ListShowParameter();
                    if (this.getView().getMainView() != null) {
                        lsp.setPageId("hjm_jobchangerecord_" + this.getView().getMainView().getPageId());
                    }
                    lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    lsp.setBillFormId("hjm_jobchangerecord");
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                case "job_disable_confirm": {
                    String createOrg = this.getPageCache().get("createOrg");
                    operation.getOption().setVariableValue("createOrg", createOrg);
                    this.confirmDisable(args);
                    break;
                }
            }
        }
    }

    private void openDisablePage(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(DISABLE_PAGE);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        formShowParameter.setOpenStyle(style);
        formShowParameter.setHasRight(true);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setDisableInfo"));
        this.getView().showForm(formShowParameter);
    }

    private void confirmDisable(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        IFormView view = this.getView();
        op.getOption().setVariableValue("jobDisableModel", view.getPageCache().get("jobDisableModel"));
        view.getPageCache().remove("jobDisableModel");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"setDisableInfo")) {
            Object returnData = event.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof JobDisableModel) {
                JobDisableModel jobDisableModel = (JobDisableModel)returnData;
                this.getPageCache().put("jobDisableModel", SerializationUtils.serializeToBase64((Object)jobDisableModel));
                this.getView().invokeOperation("job_disable_confirm");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "job_disable": {
                this.openDisablePage(args);
                break;
            }
            case "job_disable_confirm": {
                OperationResult result = args.getOperationResult();
                if (!result.isSuccess() && ObjectUtils.isEmpty((Object)result.getSuccessPkIds())) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"JobListPlugin_4", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changerecord"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Object primaryKeyValue = list.getFocusRowPkId();
        DynamicObject job = JobRepository.getInstance().findById((Long)primaryKeyValue);
        if (job != null) {
            boolean isAudit;
            IListView listview = (IListView)this.getView();
            BillShowParameter showParameter = new BillShowParameter();
            if (this.getView().getMainView() != null) {
                showParameter.setPageId(String.valueOf(primaryKeyValue) + '_' + this.getView().getMainView().getPageId());
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("hjm_jobhr");
            showParameter.setPkId(listview.getFocusRowPkId());
            String name = job.getString("name");
            showParameter.setCaption(ResManager.loadKDString((String)"\u804c\u4f4d - ", (String)"JobListPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]).concat(name));
            boolean bl = isAudit = HRBaseDataConfigUtil.getAudit((String)"hjm_jobhr") && HRStringUtils.equals((String)job.getString("enable"), (String)"1");
            if (HRStringUtils.equals((String)job.getString("enable"), (String)"10") || isAudit) {
                showParameter.setBillStatus(BillOperationStatus.EDIT);
                showParameter.setStatus(OperationStatus.EDIT);
            } else {
                showParameter.setBillStatus(BillOperationStatus.VIEW);
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setCustomParam("currentObjectPKId", (Object)String.valueOf(listview.getFocusRowPkId()));
            HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
            map.put("historyDate", job.getDate("bsed"));
            map.put("boid", Long.valueOf(job.getLong("boid")));
            showParameter.setCustomParam("customvariables", map);
            showParameter.setCustomParam("caption", (Object)ResManager.loadKDString((String)"\u804c\u4f4d\u5173\u8054\u4fe1\u606f", (String)"JobListPlugin_3", (String)"odc-hjm-formplugin", (Object[])new Object[0]).concat("-").concat(name));
            showParameter.setCustomParam("useorgId", (Object)this.getPageCache().get("createOrg"));
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"JobListPlugin_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        String commonOrderBy = "jobscm,jobseq,jobfamily,jobclass desc,number";
        setFilterEvent.setOrderBy(commonOrderBy);
    }
}

