/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.jobscm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.hr.hjm.common.utils.HJMTreeUtil;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqRepository;

public class AllSeqFamilyClassTreeUtil
implements TreeNodeQueryListener,
TreeNodeCheckListener,
TreeNodeClickListener,
SearchEnterListener {
    private TreeView treeView = null;

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent.getNodeId() == null) {
            return;
        }
        String nodeId = treeNodeEvent.getNodeId().toString();
        String parentId = nodeId.substring(0, nodeId.indexOf(35));
        if (nodeId.indexOf("seq") <= -1 && nodeId.indexOf("family") <= -1 && nodeId.indexOf("class") <= -1) {
            return;
        }
    }

    public AllSeqFamilyClassTreeUtil(TreeView pTreeView) {
        this.treeView = pTreeView;
    }

    public void initListener() {
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.treeView.getView().getControl("alltreesearch");
        search.addEnterListener((SearchEnterListener)this);
    }

    public TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode("", "root#FIRST", AllSeqFamilyClassTreeUtil.getRootNodeName(), true);
        return rootNode;
    }

    public void initTree(Long orgId) {
        TreeNode rootNode = this.createRootNode();
        rootNode.setIsOpened(true);
        Map<String, TreeNode> treeNodeDBMap = this.queryAllTreeNode(rootNode, orgId);
        rootNode = HJMTreeUtil.buildTree(treeNodeDBMap, (String)"root#FIRST");
        this.treeView.getView().getPageCache().put("allTreeRootNode", SerializationUtils.toJsonString((Object)rootNode));
        this.treeView.addNode(rootNode);
    }

    public static String getRootNodeName() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"AllSeqFamilyClassTreeUtil_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]);
    }

    public Map<String, TreeNode> queryAllTreeNode(TreeNode rootNode, Long orgId) {
        String id;
        DynamicObject[] jobSeqList = JobSeqRepository.getInstance().queryJobSeqByOrgId(orgId);
        DynamicObject[] jobFamilyList = JobFamilyRepository.getInstance().queryJobFamilyByOrgId(orgId);
        DynamicObject[] jobClassList = JobClassRepository.getInstance().queryJobClassByOrgId(orgId);
        LinkedHashMap<String, TreeNode> treeNodeDBMap = new LinkedHashMap<String, TreeNode>(jobSeqList.length + jobFamilyList.length + jobClassList.length);
        treeNodeDBMap.put(rootNode.getId(), rootNode);
        for (DynamicObject jobSeq : jobSeqList) {
            String id2 = jobSeq.getString("id") + '#' + "seq";
            TreeNode seqNode = new TreeNode(rootNode.getId(), id2, jobSeq.getString("name"));
            treeNodeDBMap.put(seqNode.getId(), seqNode);
        }
        for (DynamicObject jobFamily : jobFamilyList) {
            String parentId = jobFamily.getString("jobseq_id") + '#' + "seq";
            id = jobFamily.getString("id") + '#' + "family";
            TreeNode familyNode = new TreeNode(parentId, id, jobFamily.getString("name"));
            treeNodeDBMap.put(familyNode.getId(), familyNode);
        }
        for (DynamicObject jobClass : jobClassList) {
            String jobfamilyId = jobClass.getString("jobfamily_id");
            id = jobClass.getString("id") + '#' + "class";
            TreeNode classNode = null;
            if (jobClass.getInt("jobclasslevel") == 1) {
                jobfamilyId = jobfamilyId + '#' + "family";
                classNode = new TreeNode(jobfamilyId, id, jobClass.getString("name"));
            } else {
                String parentid = jobClass.getString("parent_id") + '#' + "class";
                classNode = new TreeNode(parentid, id, jobClass.getString("name"));
            }
            treeNodeDBMap.put(classNode.getId(), classNode);
        }
        this.treeView.getView().getPageCache().put("allTreeNodeMap", SerializationUtils.toJsonString(treeNodeDBMap));
        return treeNodeDBMap;
    }

    protected void loadChildNodes(TreeNode node) {
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeNode rootNode = (TreeNode)JSONObject.parseObject((String)this.treeView.getView().getPageCache().get("allTreeRootNode"), TreeNode.class);
        IPageCache pageCache = (IPageCache)this.treeView.getView().getService(IPageCache.class);
        String oldSearchText = pageCache.get("allTree_SearchText");
        pageCache.put("allTree_SearchText", searchText);
        List matchNodesCache = (List)JSONObject.parseObject((String)pageCache.get("allTree_MatchNodes"), (TypeReference)new TypeReference<List<TreeNode>>(){}, (Feature[])new Feature[0]);
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((Object)matchNodesCache)) {
            treeNodes = matchNodesCache;
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put("allTree_MatchNodes", SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put("allTree_SearchIndex", String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"JobScmTreePlugin_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isNotEmpty((CharSequence)pageCache.get("allTree_SearchIndex"))) {
            int indexCache = Integer.parseInt(pageCache.get("allTree_SearchIndex"));
            if (indexCache == treeNodes.size()) {
                indexCache = 0;
            }
            this.focusNode(this.treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
            pageCache.put("allTree_SearchIndex", String.valueOf(++indexCache));
        } else {
            this.focusNode(this.treeView, rootNode, (TreeNode)treeNodes.get(0));
            pageCache.put("allTree_SearchIndex", String.valueOf(0));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        String clickNodeId = (String)treeNodeCheckEvent.getNodeId();
        TreeNode rootNode = (TreeNode)JSONObject.parseObject((String)this.treeView.getView().getPageCache().get("allTreeRootNode"), TreeNode.class);
        if (((Boolean)this.treeView.getModel().getValue("alltreeincludechilds")).booleanValue()) {
            if (treeNodeCheckEvent.getChecked().booleanValue()) {
                TreeNode clickTreeNode = rootNode.getTreeNode(clickNodeId, 20);
                List parents = rootNode.getChildPathNodes(clickNodeId);
                List<TreeNode> childs = this.getAllChildNode(clickTreeNode, true, true);
                this.treeView.checkNodes(parents);
                this.treeView.updateNodes(childs);
                this.treeView.checkNodes(childs);
            } else {
                TreeNode clickTreeNode = rootNode.getTreeNode(clickNodeId, 20);
                List<TreeNode> childs = this.getAllChildNode(clickTreeNode, true, false);
                if (childs != null) {
                    this.treeView.updateNodes(childs);
                    List childIds = childs.stream().map(TreeNode::getId).collect(Collectors.toList());
                    this.treeView.uncheckNodes(childIds);
                }
            }
        } else if (treeNodeCheckEvent.getChecked().booleanValue()) {
            List parents = rootNode.getChildPathNodes(clickNodeId);
            this.treeView.checkNodes(parents);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        if (OperationStatus.VIEW.equals((Object)this.treeView.getView().getFormShowParameter().getStatus())) {
            return;
        }
        String clickNodeId = (String)evt.getNodeId();
        TreeNode rootNode = (TreeNode)JSONObject.parseObject((String)this.treeView.getView().getPageCache().get("allTreeRootNode"), TreeNode.class);
        TreeNode clickTreeNode = rootNode.getTreeNode(clickNodeId, 20);
        this.treeView.checkNode(clickTreeNode);
        if (clickTreeNode.getChildren() != null) {
            List clickTreeNodeChildIds = clickTreeNode.getChildren().stream().map(TreeNode::getId).collect(Collectors.toList());
            this.treeView.uncheckNodes(clickTreeNodeChildIds);
        }
    }

    public List<TreeNode> getAllChildNode(TreeNode curNode, boolean isOpened, boolean isChecked) {
        if (curNode.getChildren() != null) {
            curNode.setIsOpened(isOpened);
            ArrayList<TreeNode> result = new ArrayList<TreeNode>(curNode.getChildren().size());
            result.add(curNode);
            for (TreeNode node : curNode.getChildren()) {
                if (node.getChildren() != null) {
                    result.addAll(this.getAllChildNode(node, isOpened, isChecked));
                }
                node.setCheckable(isChecked);
                result.add(node);
            }
            return result;
        }
        return null;
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        TreeNode p;
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid) && (p = rootNode.getTreeNode(parentid)) != null) {
            this.expandParents(treeView, rootNode, p);
            treeView.expand(parentid);
        }
    }
}

