/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.jobscm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.hr.hjm.common.utils.HJMTreeUtil;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqScmRepository;

public class HasSeqFamilyClassTreeUtil
implements TreeNodeQueryListener,
SearchEnterListener {
    private TreeView treeView = null;
    private TreeView allSeqFamilyClassTreeView = null;

    public HasSeqFamilyClassTreeUtil(TreeView allSeqFamilyClassTreeView, TreeView pTreeView) {
        this.allSeqFamilyClassTreeView = allSeqFamilyClassTreeView;
        this.treeView = pTreeView;
    }

    public void initListener() {
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.treeView.getView().getControl("hastreesearch");
        search.addEnterListener((SearchEnterListener)this);
    }

    public TreeNode createRootNode() {
        TreeNode rootNode = new TreeNode("", "root#FIRST", HasSeqFamilyClassTreeUtil.getRootNodeName(), true);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    public void initRightTree(Long jobScmId) {
        TreeNode rootNode = this.createRootNode();
        rootNode.setIsOpened(true);
        Map<String, TreeNode> treeNodeMap = this.queryDBNode(rootNode, jobScmId);
        rootNode = HJMTreeUtil.buildTree(treeNodeMap, (String)"root#FIRST");
        this.treeView.getView().getPageCache().put("hasTreeRootNode", SerializationUtils.toJsonString((Object)rootNode));
        this.treeView.addNode(rootNode);
    }

    public void refreshRightTree() {
        TreeNode rootNode = this.createRootNode();
        TreeMap<String, TreeNode> treeNodeDBMap = new TreeMap<String, TreeNode>();
        treeNodeDBMap.put(rootNode.getId(), rootNode);
        this.treeView.getView().getPageCache().put("hasTreeNodeMap", SerializationUtils.toJsonString(treeNodeDBMap));
        this.treeView.deleteAllNodes();
        this.treeView.getView().getPageCache().put("hasTreeRootNode", SerializationUtils.toJsonString((Object)rootNode));
        this.treeView.addNode(rootNode);
    }

    public static String getRootNodeName() {
        return ResManager.loadKDString((String)"\u5df2\u6dfb\u52a0", (String)"HasSeqFamilyClassTreeUtil_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void addSelectNode() {
        TreeNode rootNode = this.createRootNode();
        String treeNodeMapStr = this.treeView.getView().getPageCache().get("hasTreeNodeMap");
        TreeMap<String, TreeNode> treeNodeMap = new TreeMap<String, TreeNode>();
        if (StringUtils.isNotEmpty((CharSequence)treeNodeMapStr)) {
            treeNodeMap.putAll((Map)JSONObject.parseObject((String)treeNodeMapStr, (TypeReference)new TypeReference<TreeMap<String, TreeNode>>(){}, (Feature[])new Feature[0]));
        }
        treeNodeMap.put(rootNode.getId(), rootNode);
        List selectedNodes = this.allSeqFamilyClassTreeView.getTreeState().getSelectedNodes();
        for (Map node : selectedNodes) {
            TreeNode treeNode = new TreeNode((String)node.get("parentid"), (String)node.get("id"), (String)node.get("text"));
            treeNode.setIsOpened(true);
            if (treeNode.getId().equals("root#FIRST")) continue;
            treeNodeMap.put(treeNode.getId(), treeNode);
        }
        this.treeView.getView().getPageCache().put("hasTreeNodeMap", SerializationUtils.toJsonString(treeNodeMap));
        rootNode = HJMTreeUtil.buildTree(treeNodeMap, (String)"root#FIRST");
        this.treeView.deleteAllNodes();
        this.treeView.addNode(rootNode);
        this.allSeqFamilyClassTreeView.uncheckNode("root#FIRST");
        this.treeView.getView().getPageCache().put("hasTreeRootNode", SerializationUtils.toJsonString((Object)rootNode));
        this.treeView.getView().getPageCache().put("hasTree_MatchNodes", SerializationUtils.toJsonString(new ArrayList()));
    }

    public void deleteSelectNode() {
        List selectedNodes = this.treeView.getTreeState().getSelectedNodes();
        Map treeNodeMap = (Map)JSONObject.parseObject((String)this.treeView.getView().getPageCache().get("hasTreeNodeMap"), (TypeReference)new TypeReference<TreeMap<String, TreeNode>>(){}, (Feature[])new Feature[0]);
        TreeNode rootNode = (TreeNode)JSONObject.parseObject((String)this.treeView.getView().getPageCache().get("hasTreeRootNode"), TreeNode.class);
        for (Map node : selectedNodes) {
            if ("root#FIRST".equals(node.get("id"))) continue;
            treeNodeMap.remove(node.get("id"));
            this.treeView.deleteNode((String)node.get("id"));
            rootNode.deleteChildNode((String)node.get("id"));
        }
        this.treeView.getView().getPageCache().put("hasTreeNodeMap", SerializationUtils.toJsonString((Object)treeNodeMap));
        this.treeView.getView().getPageCache().put("hasTreeRootNode", SerializationUtils.toJsonString((Object)rootNode));
        this.treeView.getView().getPageCache().put("hasTree_MatchNodes", SerializationUtils.toJsonString(new ArrayList()));
    }

    public Map<String, TreeNode> queryDBNode(TreeNode rootNode, Long jobScmId) {
        DynamicObject[] jobSeqScmList = JobSeqScmRepository.getInstance().queryJobSeqScmByScmId(jobScmId);
        DynamicObject[] jobFamilyScmList = JobFamilyScmRepository.getInstance().queryJobFamilyScmByScmId(jobScmId);
        DynamicObject[] jobClassScmList = JobClassScmRepository.getInstance().queryJobClassScmByScmId(jobScmId);
        LinkedHashMap<String, TreeNode> treeNodeDBMap = new LinkedHashMap<String, TreeNode>(jobSeqScmList.length + jobFamilyScmList.length + jobClassScmList.length);
        treeNodeDBMap.put(rootNode.getId(), rootNode);
        for (DynamicObject jobSeqScm : jobSeqScmList) {
            DynamicObject jobSeq = jobSeqScm.getDynamicObject("jobseq");
            String id = jobSeq.getString("id") + '#' + "seq";
            TreeNode seqNode = new TreeNode(rootNode.getId(), id, jobSeq.getString("name"));
            treeNodeDBMap.put(seqNode.getId(), seqNode);
        }
        for (DynamicObject jobFamilyScm : jobFamilyScmList) {
            DynamicObject jobFamily = jobFamilyScm.getDynamicObject("jobfamily");
            String parentId = jobFamilyScm.getString("jobseq_id") + '#' + "seq";
            String id = jobFamily.getString("id") + '#' + "family";
            TreeNode familyNode = new TreeNode(parentId, id, jobFamily.getString("name"));
            treeNodeDBMap.put(familyNode.getId(), familyNode);
        }
        for (DynamicObject jobClassScm : jobClassScmList) {
            DynamicObject jobClass = jobClassScm.getDynamicObject("jobclass");
            DynamicObject jobFamily = jobClassScm.getDynamicObject("jobfamily");
            String jobfamilyId = jobFamily.getString("id");
            String id = jobClass.getString("id") + '#' + "class";
            TreeNode classNode = null;
            if (jobClass.getInt("jobclasslevel") == 1) {
                jobfamilyId = jobfamilyId + '#' + "family";
                classNode = new TreeNode(jobfamilyId, id, jobClass.getString("name"));
            } else {
                String parentid = jobClass.getString("parent_id") + '#' + "class";
                classNode = new TreeNode(parentid, id, jobClass.getString("name"));
            }
            treeNodeDBMap.put(classNode.getId(), classNode);
        }
        this.treeView.getView().getPageCache().put("hasTreeNodeMap", SerializationUtils.toJsonString(treeNodeDBMap));
        return treeNodeDBMap;
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        IPageCache pageCache = this.treeView.getView().getPageCache();
        TreeNode rootNode = (TreeNode)JSONObject.parseObject((String)pageCache.get("hasTreeRootNode"), TreeNode.class);
        String oldSearchText = pageCache.get("hasTree_SearchText");
        pageCache.put("hasTree_SearchText", searchText);
        List matchNodesCache = (List)JSONObject.parseObject((String)pageCache.get("hasTree_MatchNodes"), (TypeReference)new TypeReference<List<TreeNode>>(){}, (Feature[])new Feature[0]);
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && matchNodesCache != null && !matchNodesCache.isEmpty()) {
            treeNodes = matchNodesCache;
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> this.loadChildNodes((TreeNode)node), 100);
            pageCache.put("hasTree_MatchNodes", SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put("hasTree_SearchIndex", String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            this.treeView.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"JobScmTreePlugin_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        } else if (StringUtils.isNotEmpty((CharSequence)pageCache.get("hasTree_SearchIndex"))) {
            int indexCache = Integer.parseInt(pageCache.get("hasTree_SearchIndex"));
            if (indexCache == treeNodes.size()) {
                indexCache = 0;
            }
            this.focusNode(this.treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
            pageCache.put("hasTree_SearchIndex", String.valueOf(++indexCache));
        } else {
            this.focusNode(this.treeView, rootNode, (TreeNode)treeNodes.get(0));
            pageCache.put("hasTree_SearchIndex", String.valueOf(0));
        }
    }

    protected void loadChildNodes(TreeNode node) {
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        TreeNode p;
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid) && (p = rootNode.getTreeNode(parentid)) != null) {
            this.expandParents(treeView, rootNode, p);
            treeView.expand(parentid);
        }
    }
}

