/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.jobscm;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hrmp.hbjm.business.domain.repository.JobScmRepository;
import kd.hrmp.hbjm.business.domain.service.impl.JobScmServiceImpl;
import kd.hrmp.hbjm.common.model.jobscm.JobScmBaseInfo;

public class JobScmBaseInfoPlugin
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(JobScmBaseInfoPlugin.class);
    private Long jobScmId = 0L;

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long jobScmId = (Long)formShowParameter.getCustomParam("pkId");
        if (jobScmId != null) {
            this.jobScmId = jobScmId;
        }
    }

    public void afterBindData(EventObject e) {
        Object pkId = this.getView().getFormShowParameter().getCustomParams().get("pkId");
        if (Objects.isNull(pkId)) {
            return;
        }
        DynamicObject jobScmDyn = JobScmRepository.getInstance().queryBaseInfoById((Long)pkId);
        if (HRBaseDataConfigUtil.getAudit((String)"hbjm_jobscmhr") && !HRStringUtils.equals((String)"A", (String)jobScmDyn.getString("status"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnupdate"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.jobScmId != 0L) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
            DynamicObject jobScmDB = serviceHelper.generateEmptyDynamicObject();
            jobScmDB = BusinessDataServiceHelper.loadSingleFromCache((Object)this.jobScmId, (DynamicObjectType)jobScmDB.getDynamicObjectType());
            this.transToView(jobScmDB);
            JobScmBaseInfo jobScm = new JobScmBaseInfo(jobScmDB);
            this.getPageCache().put("jobScmBaseInfo", SerializationUtils.toJsonString((Object)jobScm));
            this.getPageCache().put("jobScmNumberCache", SerializationUtils.toJsonString((Object)jobScm.getNumber()));
            this.getPageCache().put("jobScmNameCache", SerializationUtils.toJsonString((Object)jobScm.getName()));
        } else {
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            if (parentView != null && "save".equals(this.getPageCache().get("jobScmOper"))) {
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                Long createOrg = (Long)SerializationUtils.fromJsonString((String)pageCache.get("createOrg"), Long.class);
                String ctrlstrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)"hbjm_jobscmhr", (String)String.valueOf(createOrg));
                this.getModel().setValue("createorg", (Object)createOrg);
                this.getModel().setValue("ctrlstrategy", (Object)ctrlstrategy);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if ("update".equals(this.getPageCache().get("jobScmOper"))) {
            if (HRStringUtils.equals((String)"jobgradescm", (String)fieldKey)) {
                this.getPageCache().put("jobgradescmChangeStatus", "changed");
            } else if (HRStringUtils.equals((String)"joblevelscm", (String)fieldKey)) {
                this.getPageCache().put("joblevelscmChangeStatus", "changed");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "save_donothing": {
                if (!"update".equals(this.getPageCache().get("jobScmOper")) || !"true".equals(this.getPageCache().get("jobGradeOrLevelIsChanged"))) break;
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_save", (IFormPlugin)this);
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u804c\u4f4d\u7c7b\u7684\u804c\u7ea7\u8303\u56f4\u6216\u804c\u7b49\u8303\u56f4\u5df2\u7ecf\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u53ca\u65f6\u66f4\u65b0\u804c\u4f4d\u7684\u804c\u7ea7\u8303\u56f4\u548c\u804c\u7b49\u8303\u56f4\u3002", (String)"JobScmBaseInfoPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]), System.lineSeparator());
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "save_donothing": {
                this.save();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("continue_save".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.save();
            this.getView().close();
        }
    }

    public void save() {
        JobScmServiceImpl jobScmService = new JobScmServiceImpl();
        boolean result = false;
        JobScmBaseInfo jobScmBaseInfo = (JobScmBaseInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("jobScmBaseInfo"), JobScmBaseInfo.class);
        DynamicObject jobScm = null;
        if ("save".equals(this.getPageCache().get("jobScmOper"))) {
            jobScm = this.buildJobScmDynOnSave(jobScmBaseInfo);
        } else if ("update".equals(this.getPageCache().get("jobScmOper"))) {
            jobScm = this.buildJobScmDynonUpdate(jobScmBaseInfo);
        }
        if (jobScm == null) {
            this.getView().returnDataToParent((Object)result);
            return;
        }
        DynamicObjectCollection jobSeqScmCollection = this.buildSeqScmCollection(jobScm.getLong("id"));
        DynamicObjectCollection jobFamilyScmCollection = this.buildFamilyScmCollection(jobScm.getLong("id"));
        DynamicObjectCollection jobClassScmCollection = this.buildClassScmCollection(jobScm.getLong("id"));
        if ("save".equals(this.getPageCache().get("jobScmOper"))) {
            result = jobScmService.saveAll(jobScm, jobSeqScmCollection, jobFamilyScmCollection, jobClassScmCollection);
        } else if ("update".equals(this.getPageCache().get("jobScmOper"))) {
            result = jobScmService.updateAll(jobScm, jobSeqScmCollection, jobFamilyScmCollection, jobClassScmCollection);
        }
        this.getView().returnDataToParent((Object)result);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
        }
    }

    private void transToView(DynamicObject jobScmDB) {
        this.getModel().setValue("number", (Object)jobScmDB.getString("number"));
        this.getModel().setValue("name", jobScmDB.get("name"));
        this.getModel().setValue("createorg", jobScmDB.get("createorg"));
        this.getModel().setValue("jobgradescm", jobScmDB.get("jobgradescm"));
        this.getModel().setValue("joblevelscm", jobScmDB.get("joblevelscm"));
        this.getModel().setValue("ctrlstrategy", jobScmDB.get("ctrlstrategy"));
        this.getModel().setValue("description", jobScmDB.get("description"));
    }

    private DynamicObject buildJobScmDynOnSave(JobScmBaseInfo jobScmBaseInfo) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobscmhr");
        DynamicObject jobScmDy = serviceHelper.generateEmptyDynamicObject();
        Long id = ORM.create().genLongId("hbjm_jobscmhr");
        jobScmDy.set("id", (Object)id);
        jobScmDy.set("createorg", (Object)jobScmBaseInfo.getCreateorg());
        jobScmDy.set("useorg", (Object)jobScmBaseInfo.getCreateorg());
        jobScmDy.set("org", (Object)jobScmBaseInfo.getCreateorg());
        jobScmDy.set("number", (Object)jobScmBaseInfo.getNumber());
        jobScmDy.set("name", (Object)jobScmBaseInfo.getName());
        jobScmDy.set("jobgradescm", (Object)jobScmBaseInfo.getJobgradescm());
        jobScmDy.set("joblevelscm", (Object)jobScmBaseInfo.getJoblevelscm());
        jobScmDy.set("ctrlstrategy", (Object)jobScmBaseInfo.getCtrlstrategy());
        jobScmDy.set("description", (Object)jobScmBaseInfo.getDescription());
        jobScmDy.set("masterid", (Object)id);
        jobScmDy.set("enable", (Object)"1");
        boolean isAudit = HRBaseDataConfigUtil.getAudit((String)"hbjm_jobscmhr");
        if (!isAudit) {
            jobScmDy.set("status", (Object)"C");
        } else {
            jobScmDy.set("status", (Object)"A");
        }
        Long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        jobScmDy.set("creator", (Object)userId);
        jobScmDy.set("createtime", (Object)date);
        return jobScmDy;
    }

    private DynamicObject buildJobScmDynonUpdate(JobScmBaseInfo jobScmBaseInfo) {
        DynamicObject jobScmDy = JobScmRepository.getInstance().queryBaseInfoById(jobScmBaseInfo.getId());
        jobScmDy.set("createorg", (Object)jobScmBaseInfo.getCreateorg());
        jobScmDy.set("number", (Object)jobScmBaseInfo.getNumber());
        jobScmDy.set("name", (Object)jobScmBaseInfo.getName());
        jobScmDy.set("jobgradescm", (Object)jobScmBaseInfo.getJobgradescm());
        jobScmDy.set("joblevelscm", (Object)jobScmBaseInfo.getJoblevelscm());
        jobScmDy.set("ctrlstrategy", (Object)jobScmBaseInfo.getCtrlstrategy());
        jobScmDy.set("description", (Object)jobScmBaseInfo.getDescription());
        Long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        jobScmDy.set("modifier", (Object)userId);
        jobScmDy.set("modifytime", (Object)date);
        return jobScmDy;
    }

    private DynamicObjectCollection buildSeqScmCollection(Long jobScmId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbjm_jobseqscm");
        return this.getModel().getDataEntity(true).getDynamicObjectCollection("seqentryentity").stream().map(entrySeq -> {
            DynamicObject jobSeqScmDy = new DynamicObject((DynamicObjectType)dataEntityType);
            Long id = ORM.create().genLongId("hbjm_jobseqscm");
            jobSeqScmDy.set("id", (Object)id);
            jobSeqScmDy.set("number", entrySeq.get("seqnumber"));
            jobSeqScmDy.set("name", entrySeq.get("seqname"));
            jobSeqScmDy.set("jobscm", (Object)jobScmId);
            jobSeqScmDy.set("jobseq", entrySeq.get("jobseq"));
            jobSeqScmDy.set("enable", (Object)"1");
            return jobSeqScmDy;
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    private DynamicObjectCollection buildFamilyScmCollection(Long jobScmId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbjm_jobfamilyscm");
        return this.getModel().getDataEntity(true).getDynamicObjectCollection("familyentryentity").stream().map(entryFamily -> {
            DynamicObject jobFamilyScmDy = new DynamicObject((DynamicObjectType)dataEntityType);
            Long id = ORM.create().genLongId("hbjm_jobfamilyscm");
            jobFamilyScmDy.set("id", (Object)id);
            jobFamilyScmDy.set("number", entryFamily.get("familynumber"));
            jobFamilyScmDy.set("name", entryFamily.get("familyname"));
            jobFamilyScmDy.set("jobscm", (Object)jobScmId);
            jobFamilyScmDy.set("jobseq", entryFamily.get("familyseq"));
            jobFamilyScmDy.set("jobfamily", entryFamily.get("jobfamily"));
            jobFamilyScmDy.set("jobgradescm", entryFamily.get("familygradescm"));
            jobFamilyScmDy.set("joblevelscm", entryFamily.get("familylevelscm"));
            jobFamilyScmDy.set("enable", (Object)"1");
            return jobFamilyScmDy;
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    private DynamicObjectCollection buildClassScmCollection(Long jobScmId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbjm_jobclassscm");
        return this.getModel().getDataEntity(true).getDynamicObjectCollection("classentryentity").stream().map(entryClass -> {
            DynamicObject jobClassScmDy = new DynamicObject((DynamicObjectType)dataEntityType);
            Long id = ORM.create().genLongId("hbjm_jobclassscm");
            jobClassScmDy.set("id", (Object)id);
            jobClassScmDy.set("number", entryClass.get("classnumber"));
            jobClassScmDy.set("name", entryClass.get("classname"));
            jobClassScmDy.set("jobscm", (Object)jobScmId);
            jobClassScmDy.set("jobclass", entryClass.get("jobclass"));
            jobClassScmDy.set("jobfamily", entryClass.get("classfamily"));
            jobClassScmDy.set("lowjobgrade", entryClass.get("classgradelow"));
            jobClassScmDy.set("highjobgrade", entryClass.get("classgradehigh"));
            jobClassScmDy.set("lowjoblevel", entryClass.get("classlevellow"));
            jobClassScmDy.set("highjoblevel", entryClass.get("classlevelhigh"));
            jobClassScmDy.set("enable", (Object)"1");
            return jobClassScmDy;
        }).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }
}

