/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.jobscm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;

public class JobScmEntryPlugin
extends HRCoreBaseBillEdit {
    private static final Log LOGGER = LogFactory.getLog(JobScmEntryPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "setgradescm": {
                this.openGradeScm();
                break;
            }
            case "setlevelscm": {
                this.openLevelScm();
                break;
            }
            case "setgraderange": {
                this.openGradeRange();
                break;
            }
            case "setlevelrange": {
                this.openLevelRange();
                break;
            }
        }
    }

    private void openGradeScm() {
        int[] seleteRowIndexs = this.getEntrySelectedRows("familyentryentity");
        if (seleteRowIndexs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u804c\u7b49\u65b9\u6848\u7684\u804c\u4f4d\u65cf\u3002", (String)"JobScmEntryPlugin_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        } else {
            this.showbasedataf7("hbjm_jobgradescmhr", "hbp_hislistf7", "setGradeScmCallBack");
        }
    }

    private void openLevelScm() {
        int[] seleteRowIndexs = this.getEntrySelectedRows("familyentryentity");
        if (seleteRowIndexs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u804c\u7ea7\u65b9\u6848\u7684\u804c\u4f4d\u65cf\u3002", (String)"JobScmEntryPlugin_4", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        } else {
            this.showbasedataf7("hbjm_joblevelscmhr", "hbp_hislistf7", "setLevelScmCallBack");
        }
    }

    private void openGradeRange() {
        int[] seleteRowIndexs = this.getEntrySelectedRows("classentryentity");
        if (seleteRowIndexs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u804c\u7b49\u8303\u56f4\u7684\u804c\u4f4d\u7c7b\u3002", (String)"JobScmEntryPlugin_5", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        } else {
            this.showRangeView("jobgradescm");
        }
    }

    private void openLevelRange() {
        int[] seleteRowIndexs = this.getEntrySelectedRows("classentryentity");
        if (seleteRowIndexs.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bbe\u7f6e\u804c\u7ea7\u8303\u56f4\u7684\u804c\u4f4d\u7c7b\u3002", (String)"JobScmEntryPlugin_6", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        } else {
            this.showRangeView("joblevelscm");
        }
    }

    private void showbasedataf7(String billFormId, String formId, String callBack) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("900px");
        styleCss.setHeight("600px");
        style.setInlineStyleCss(styleCss);
        showParameter.setOpenStyle(style);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBack));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("enable", "=", (Object)"1"));
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showRangeView(String type) {
        int[] selectrowindex = this.getEntrySelectedRows("classentryentity");
        HashSet<String> familyIds = new HashSet<String>(selectrowindex.length);
        for (int index : selectrowindex) {
            DynamicObject jobclass = (DynamicObject)this.getModel().getEntryEntity("classentryentity").get(index);
            String jobfamilyId = jobclass.getDynamicObject("classfamily").getString("id");
            familyIds.add(jobfamilyId);
        }
        List jobfamilys = this.getModel().getDataEntity(true).getDynamicObjectCollection("familyentryentity").stream().filter(jobfamily -> familyIds.contains(jobfamily.getString("jobfamily_id"))).collect(Collectors.toList());
        if (jobfamilys.isEmpty()) {
            LOGGER.error("jobclassentry data not found jobfamily,please confrim that the data is complete.data index is {}", (Object)selectrowindex);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6240\u9009\u804c\u4f4d\u7c7b\u5bf9\u5e94\u7684\u804c\u4f4d\u65cf\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"JobScmEntryPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter form = new FormShowParameter();
        if ("jobgradescm".equals(type)) {
            Set gradescmIds = jobfamilys.stream().map(jobfamily -> jobfamily.getLong("familygradescm_id")).collect(Collectors.toSet());
            if (gradescmIds.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u804c\u4f4d\u7c7b\u5bf9\u5e94\u804c\u4f4d\u65cf\u7684\u804c\u7b49\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"JobScmEntryPlugin_7", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!gradescmIds.add(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6240\u9009\u804c\u4f4d\u7c7b\u5bf9\u5e94\u804c\u4f4d\u65cf\u7684\u804c\u7b49\u65b9\u6848\u3002", (String)"JobScmEntryPlugin_9", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long jobgradescmId = ((DynamicObject)jobfamilys.get(0)).getLong("familygradescm_id");
            form.setCustomParam(type, (Object)jobgradescmId);
            form.setFormId("hjm_jobgraderange");
            form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setGradeRangeCallBack"));
        } else if ("joblevelscm".equals(type)) {
            Set levelscmIds = jobfamilys.stream().map(jobfamily -> jobfamily.getLong("familylevelscm_id")).collect(Collectors.toSet());
            if (levelscmIds.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u804c\u4f4d\u7c7b\u5bf9\u5e94\u804c\u4f4d\u65cf\u7684\u804c\u7ea7\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"JobScmEntryPlugin_8", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!levelscmIds.add(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6240\u9009\u804c\u4f4d\u7c7b\u5bf9\u5e94\u804c\u4f4d\u65cf\u7684\u804c\u7ea7\u65b9\u6848\u3002", (String)"JobScmEntryPlugin_10", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long joblevelscmId = ((DynamicObject)jobfamilys.get(0)).getLong("familylevelscm_id");
            form.setCustomParam(type, (Object)joblevelscmId);
            form.setFormId("hjm_joblevelrange");
            form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setLevelRangeCallBack"));
        }
        form.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(form);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "setGradeScmCallBack": {
                this.setGradeOrLevelScm(event, "familygradescm_id");
                break;
            }
            case "setLevelScmCallBack": {
                this.setGradeOrLevelScm(event, "familylevelscm_id");
                break;
            }
            case "setGradeRangeCallBack": {
                this.setGradeOrLevelRange(event, "jobgrade");
                break;
            }
            case "setLevelRangeCallBack": {
                this.setGradeOrLevelRange(event, "joblevel");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        super.propertyChanged(evt);
        switch (propertyName = evt.getProperty().getName()) {
            case "familygradescm": {
                this.gradeOrLevelScmEmpty(evt.getChangeSet()[0], "familygradescm_id");
                break;
            }
            case "familylevelscm": {
                this.gradeOrLevelScmEmpty(evt.getChangeSet()[0], "familylevelscm_id");
                break;
            }
        }
    }

    private void gradeOrLevelScmEmpty(ChangeData changeData, String type) {
        DynamicObject familyEntryRow = changeData.getDataEntity();
        HashSet<Long> familyIds = new HashSet<Long>();
        familyIds.add(familyEntryRow.getLong("jobfamily_id"));
        this.clearClassEntryRange(type, familyIds);
    }

    private void setGradeOrLevelScm(ClosedCallBackEvent event, String fieldName) {
        ListSelectedRowCollection returnRows = (ListSelectedRowCollection)event.getReturnData();
        if (returnRows != null && returnRows.size() > 0) {
            Long pkId = (Long)returnRows.get(0).getPrimaryKeyValue();
            int[] selectrowindex = this.getEntrySelectedRows("familyentryentity");
            HashSet<Long> familyIds = new HashSet<Long>(selectrowindex.length);
            for (int index : selectrowindex) {
                DynamicObject selectFamily = (DynamicObject)this.getModel().getEntryEntity("familyentryentity").get(index);
                selectFamily.set(fieldName, (Object)pkId);
                familyIds.add(selectFamily.getLong("jobfamily_id"));
            }
            this.clearClassEntryRange(fieldName, familyIds);
        }
    }

    private void clearClassEntryRange(String fieldName, Set<Long> familyIds) {
        DynamicObjectCollection jobClassEntry = this.getModel().getEntryEntity("classentryentity");
        for (DynamicObject jobClass : jobClassEntry) {
            if (!familyIds.contains(jobClass.get("classfamily_id"))) continue;
            if ("familygradescm_id".equals(fieldName)) {
                jobClass.set("classgradelow", null);
                jobClass.set("classgradehigh", null);
                jobClass.set("classgraderange", null);
                continue;
            }
            if (!"familylevelscm_id".equals(fieldName)) continue;
            jobClass.set("classlevellow", null);
            jobClass.set("classlevelhigh", null);
            jobClass.set("classlevelrange", null);
        }
        this.getView().getPageCache().put("jobGradeOrLevelIsChanged", String.valueOf(true));
        this.getView().updateView("familyentryentity");
        this.getView().updateView("classentryentity");
    }

    private void setGradeOrLevelRange(ClosedCallBackEvent event, String type) {
        HashMap returnData = (HashMap)event.getReturnData();
        if (returnData != null) {
            if ("jobgrade".equals(type)) {
                DynamicObject highjobgrade = (DynamicObject)returnData.get("highjobgrade");
                DynamicObject lowjobgrade = (DynamicObject)returnData.get("lowjobgrade");
                this.setFieldRange("classgraderange", lowjobgrade, "classgradelow_id", highjobgrade, "classgradehigh_id");
            } else if ("joblevel".equals(type)) {
                DynamicObject highjoblevel = (DynamicObject)returnData.get("highjoblevel");
                DynamicObject lowjoblevel = (DynamicObject)returnData.get("lowjoblevel");
                this.setFieldRange("classlevelrange", lowjoblevel, "classlevellow_id", highjoblevel, "classlevelhigh_id");
            }
        }
        this.getView().getPageCache().put("jobGradeOrLevelIsChanged", String.valueOf(true));
        this.getView().updateView("classentryentity");
    }

    public void setFieldRange(String rangeStrField, DynamicObject lowObject, String lowField, DynamicObject highObject, String highField) {
        int[] selectrowindex;
        String lowJobString = "";
        String highJobString = "";
        Long lowPkId = null;
        Long highPkId = null;
        String message = "";
        if (highObject != null) {
            highJobString = highObject.getString("name");
            highPkId = highObject.getLong("id");
        }
        if (lowObject != null) {
            lowJobString = lowObject.getString("name");
            lowPkId = lowObject.getLong("id");
        }
        if (StringUtils.isNotEmpty((String)highJobString) && StringUtils.isNotEmpty((String)lowJobString)) {
            message = lowJobString + "-" + highJobString;
        }
        for (int index : selectrowindex = this.getEntrySelectedRows("classentryentity")) {
            DynamicObject selectedjobclass = (DynamicObject)this.getModel().getEntryEntity("classentryentity").get(index);
            selectedjobclass.set(rangeStrField, (Object)message);
            selectedjobclass.set(lowField, (Object)lowPkId);
            selectedjobclass.set(highField, (Object)highPkId);
        }
    }

    private int[] getEntrySelectedRows(String entryEntityName) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntityName);
        return grid.getEntryState().getSelectedRows();
    }
}

