/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.jobscm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hjm.business.validators.JobScmBaseInfoValidator;
import kd.hr.hjm.formplugin.web.jobscm.TreeToEntryUtil;
import kd.hrmp.hbjm.common.model.jobscm.JobScmBaseInfo;

public class JobScmWizardPlugin
extends HRDynamicFormBasePlugin {
    private static final String isMutex = "is_Mutex";

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long jobScmId = (Long)formShowParameter.getCustomParam("pkId");
        if (jobScmId != null) {
            this.getPageCache().put("jobScmOper", "update");
        } else {
            this.getPageCache().put("jobScmOper", "save");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean hasUpdatePerm = (Boolean)formShowParameter.getCustomParam("hasUpdatePerm");
        if (OperationStatus.VIEW.equals((Object)formShowParameter.getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_addnode", "btn_delnode"});
            this.setTreeMulti(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_gradescm", "btn_levelscm", "btn_graderange", "btn_levelrange"});
        }
        if (!hasUpdatePerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnupdate"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnprev", "btnsave"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"wizardap"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        this.getView().getPageCache().put("wizardTabIndex", "0");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnnext", "btnprev", "btnupdate", "btnclose"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("update_donothing".equals(operateKey) && this.doMutex()) {
            String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam("useorgId");
            String createorgId = this.getModel().getDataEntity().getString("createOrg.id");
            if (useOrgID != null && createorgId != null && !useOrgID.equals(createorgId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u4fee\u6539\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"JobScmWizardPlugin_5", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.update();
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnprev": {
                this.previous();
                break;
            }
            case "btnnext": {
                this.next();
                break;
            }
            case "btnclose": {
                this.close();
                break;
            }
        }
        this.handleCtrlVisible(this.getView());
    }

    private void update() {
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnupdate"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_addnode", "btn_delnode"});
        this.setTreeMulti(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{"btn_gradescm", "btn_levelscm", "btn_graderange", "btn_levelrange"});
        this.getView().cacheFormShowParameter();
    }

    private void setTreeMulti(boolean isMulti) {
        TreeView allSeqFamilyClassTreeView = (TreeView)this.getView().getControl("tree_allseqfamilyclass");
        TreeView hasSeqFamilyClassTreeView = (TreeView)this.getView().getControl("tree_hasseqfamilyclass");
        allSeqFamilyClassTreeView.setMulti(isMulti);
        hasSeqFamilyClassTreeView.setMulti(isMulti);
    }

    private void close() {
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged && OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("close", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"JobScmWizardPlugin_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
        } else {
            OperateOption operateOption = OperateOption.create();
            this.getView().invokeOperation("close", operateOption);
        }
    }

    private boolean doMutex() {
        StringBuilder errMsg = new StringBuilder();
        if (this.getPageCache().get("jobScmBaseInfo") != null) {
            JobScmBaseInfo jobScmCache = (JobScmBaseInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("jobScmBaseInfo"), JobScmBaseInfo.class);
            if (!MutexHelper.require((IFormView)this.getView(), (String)"hbjm_jobscmhr", (Object)jobScmCache.getId(), (String)"modify", (boolean)true, (StringBuilder)errMsg)) {
                this.getView().showTipNotification(errMsg.toString());
                return false;
            }
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u9875\u9762\u7f13\u5b58\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JobScmWizardPlugin_2", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        OperateOption operateOption = OperateOption.create();
        if (StringUtils.equals((CharSequence)"close", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("close", operateOption);
        }
    }

    private void next() {
        Tab tab = (Tab)this.getView().getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if ("tabpageap".equals(currentTab)) {
            if (operationStatus.getValue() == OperationStatus.VIEW.getValue() || this.checkName()) {
                String msg = this.checkNumber();
                if (operationStatus.getValue() == OperationStatus.VIEW.getValue() || StringUtils.isEmpty((CharSequence)msg)) {
                    JobScmWizardPlugin.doStepAction(this.getView(), true);
                } else {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6821\u9a8c\u9519\u8bef", (String)"JobScmWizardPlugin_4", (String)"odc-hjm-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
                }
            }
        } else if ("tabpageap1".equals(currentTab)) {
            String hasTreeNodeMapJson = this.getPageCache().get("hasTreeNodeMap");
            Map treeNodeMap = (Map)JSONObject.parseObject((String)hasTreeNodeMapJson, (TypeReference)new TypeReference<TreeMap<String, TreeNode>>(){}, (Feature[])new Feature[0]);
            if (this.checkJobScmTreeData(treeNodeMap)) {
                TreeToEntryUtil.render(this.getView());
                JobScmWizardPlugin.doStepAction(this.getView(), true);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u672a\u6dfb\u52a0\u4efb\u4f55\u804c\u4f4d\u65cf\u548c\u804c\u4f4d\u7c7b\u7b49\u6570\u636e\u884c\u3002", (String)"JobScmWizardPlugin_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
            }
        }
        if (this.getModel().getDataChanged()) {
            JobScmBaseInfo jobScmCache = null;
            if (this.getPageCache().get("jobScmBaseInfo") != null) {
                jobScmCache = (JobScmBaseInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("jobScmBaseInfo"), JobScmBaseInfo.class);
            }
            this.transBaseInfoToCache(jobScmCache);
        }
    }

    private boolean checkJobScmTreeData(Map<String, TreeNode> treeNodeMap) {
        if (treeNodeMap.get("root#FIRST") == null) {
            return false;
        }
        Iterator<Map.Entry<String, TreeNode>> iterator = treeNodeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            TreeNode node = iterator.next().getValue();
            if (!node.getId().contains("family") && !node.getId().contains("class")) continue;
            return true;
        }
        return false;
    }

    private void transBaseInfoToCache(JobScmBaseInfo jobScmCache) {
        if (jobScmCache == null) {
            jobScmCache = new JobScmBaseInfo();
        }
        jobScmCache.setNumber((String)this.getModel().getValue("number"));
        jobScmCache.setName((Map)((OrmLocaleValue)this.getModel().getValue("name")));
        jobScmCache.setCreateorg((Long)this.getModel().getValue("createorg_id"));
        jobScmCache.setJobgradescm((Long)this.getModel().getValue("jobgradescm_id"));
        jobScmCache.setJoblevelscm((Long)this.getModel().getValue("joblevelscm_id"));
        jobScmCache.setCtrlstrategy((String)this.getModel().getValue("ctrlstrategy"));
        jobScmCache.setDescription((Map)((OrmLocaleValue)this.getModel().getValue("description")));
        this.getPageCache().put("jobScmBaseInfo", SerializationUtils.toJsonString((Object)jobScmCache));
    }

    private String checkNumber() {
        String numberMsg = "";
        if ("save".equals(this.getPageCache().get("jobScmOper"))) {
            numberMsg = this.checkScmNumber();
        } else if ("update".equals(this.getPageCache().get("jobScmOper"))) {
            String jobScmCacheNumber = null;
            if (this.getPageCache().get("jobScmNumberCache") != null) {
                jobScmCacheNumber = (String)SerializationUtils.fromJsonString((String)this.getPageCache().get("jobScmNumberCache"), String.class);
                String jobScmNumber = (String)this.getModel().getValue("number");
                OrmLocaleValue jobScmName = (OrmLocaleValue)this.getModel().getValue("name");
                if (!jobScmNumber.equals(jobScmCacheNumber)) {
                    numberMsg = this.checkScmNumber();
                }
            } else {
                return ResManager.loadKDString((String)"\u7f16\u7801\u540d\u79f0\u8bfb\u53d6\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"JobScmWizardPlugin_3", (String)"odc-hjm-formplugin", (Object[])new Object[0]);
            }
        }
        FieldTip numberTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.others, "number", ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"JobBasedataEdit_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((CharSequence)numberMsg)) {
            numberTip.setSuccess(false);
            DeleteRule numberRule = new DeleteRule();
            numberRule.setAction("updateValue");
            ArrayList<String> fileds = new ArrayList<String>();
            fileds.add("number");
            numberRule.setFields(fileds);
            numberTip.setDeleteRule(numberRule);
            this.getView().showFieldTip(numberTip);
        }
        return numberMsg;
    }

    private boolean checkName() {
        ArrayList<String> langBillParams = new ArrayList<String>(4);
        langBillParams.add(Lang.get().name());
        String promptLang = ValidateContext.switchLang(langBillParams);
        OrmLocaleValue jobScmName = (OrmLocaleValue)this.getModel().getValue("name");
        String tips = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"JobScmWizardPlugin_6", (String)"odc-hjm-formplugin", (Object[])new Object[0]), promptLang);
        FieldTip nameTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.others, "name", tips);
        if (StringUtils.isEmpty((CharSequence)jobScmName.getLocaleValue())) {
            nameTip.setSuccess(false);
            DeleteRule nameRule = new DeleteRule();
            nameRule.setAction("updateValue");
            ArrayList<String> fileds = new ArrayList<String>();
            fileds.add("name");
            nameRule.setFields(fileds);
            nameTip.setDeleteRule(nameRule);
            this.getView().showFieldTip(nameTip);
            return false;
        }
        return true;
    }

    private String checkScmNumber() {
        String jobScmNumber = (String)this.getModel().getValue("number");
        return JobScmBaseInfoValidator.checkNumberExist((String)jobScmNumber);
    }

    private void previous() {
        JobScmWizardPlugin.doStepAction(this.getView(), false);
    }

    private void handleCtrlVisible(IFormView formView) {
        String tabIndex = formView.getPageCache().get("wizardTabIndex");
        if (HRStringUtils.equals((String)"0", (String)tabIndex)) {
            formView.setVisible(Boolean.FALSE, new String[]{"btnprev"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"btnprev"});
        }
        if (HRStringUtils.equals((String)"2", (String)tabIndex)) {
            formView.setVisible(Boolean.FALSE, new String[]{"btnnext"});
            if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                formView.setVisible(Boolean.TRUE, new String[]{"btnsave"});
            }
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"btnnext"});
            formView.setVisible(Boolean.FALSE, new String[]{"btnsave"});
        }
    }

    public static void doStepAction(IFormView formView, boolean forward) {
        Tab tab = (Tab)formView.getControl("guidecontent");
        String currentTab = tab.getCurrentTab();
        int tabIndex = 0;
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            if (forward) {
                tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
                tabIndex = i + 1;
                break;
            }
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            tabIndex = i - 1;
            break;
        }
        formView.getPageCache().put("wizardTabIndex", tabIndex + "");
    }
}

