/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hjm.formplugin.web.jobscm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.hrmp.hbjm.business.domain.repository.JobClassRepository;
import kd.hrmp.hbjm.business.domain.repository.JobClassScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyRepository;
import kd.hrmp.hbjm.business.domain.repository.JobFamilyScmRepository;
import kd.hrmp.hbjm.business.domain.repository.JobSeqRepository;
import kd.hrmp.hbjm.common.model.jobscm.JobScmBaseInfo;

public class TreeToEntryUtil {
    private static final String STANDARDJOBSEQ_ID = "standardjobseq_id";

    public static void render(IFormView formView) {
        boolean datachanged = formView.getModel().getDataChanged();
        JobScmBaseInfo jobScmCache = (JobScmBaseInfo)SerializationUtils.fromJsonString((String)formView.getPageCache().get("jobScmBaseInfo"), JobScmBaseInfo.class);
        Map<String, List<Long>> seqFamilyClassDBMap = TreeToEntryUtil.getTreeSeqFamilyClassIds(formView);
        DynamicObject[] jobseqs = JobSeqRepository.getInstance().queryJobSeqByIdsIgnoreEnable(seqFamilyClassDBMap.get("seqIds"));
        DynamicObject[] jobfamilys = JobFamilyRepository.getInstance().queryJobFamilyByIdsIgnoreEnable(seqFamilyClassDBMap.get("familyIds"));
        DynamicObject[] jobclasses = JobClassRepository.getInstance().queryJobClassByIdsIgnoreEnable(seqFamilyClassDBMap.get("classIds"));
        IDataModel dataModel = formView.getModel();
        dataModel.deleteEntryData("seqentryentity");
        dataModel.deleteEntryData("familyentryentity");
        dataModel.deleteEntryData("classentryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TreeToEntryUtil.randerSeqEntry(jobScmCache, jobseqs, model);
        TreeToEntryUtil.randerFamilyEntry(jobScmCache, jobfamilys, model);
        TreeToEntryUtil.randerClassEntry(jobScmCache, jobclasses, model);
        model.endInit();
        TreeToEntryUtil.refreshEntryByDB(jobScmCache, seqFamilyClassDBMap, model, formView.getPageCache());
        formView.updateView("seqentryentity");
        formView.updateView("familyentryentity");
        formView.updateView("classentryentity");
        model.updateEntryCache(model.getDataEntity(true).getDynamicObjectCollection("seqentryentity"));
        model.updateEntryCache(model.getDataEntity(true).getDynamicObjectCollection("familyentryentity"));
        model.updateEntryCache(model.getDataEntity(true).getDynamicObjectCollection("classentryentity"));
        if (!datachanged) {
            formView.getModel().setDataChanged(false);
        }
    }

    private static void refreshEntryByDB(JobScmBaseInfo jobScmCache, Map<String, List<Long>> seqFamilyClassDBMap, AbstractFormDataModel model, IPageCache pageCache) {
        DynamicObject[] jobFamilyScms = JobFamilyScmRepository.getInstance().queryJobFamilyScm(jobScmCache.getId(), seqFamilyClassDBMap.get("familyIds"));
        DynamicObject[] jobClassScms = JobClassScmRepository.getInstance().queryJobClassScm(jobScmCache.getId(), seqFamilyClassDBMap.get("classIds"));
        HashMap<String, DynamicObject> jobFamilyScmMap = new HashMap<String, DynamicObject>(jobFamilyScms.length);
        HashMap<String, DynamicObject> jobClassScmMap = new HashMap<String, DynamicObject>(jobClassScms.length);
        for (DynamicObject jobFamilyScm : jobFamilyScms) {
            jobFamilyScmMap.put(jobFamilyScm.getString("jobfamily_id"), jobFamilyScm);
        }
        for (DynamicObject jobClassScm : jobClassScms) {
            jobClassScmMap.put(jobClassScm.getString("jobclass_id"), jobClassScm);
        }
        model.getDataEntity(true).getDynamicObjectCollection("familyentryentity").stream().forEach(jobfamily -> {
            String jobFamilyId = jobfamily.getString("jobfamily_id");
            DynamicObject jobFamilyScm = (DynamicObject)jobFamilyScmMap.get(jobFamilyId);
            if (jobFamilyScm != null) {
                if (pageCache.get("jobgradescmChangeStatus") == null) {
                    jobfamily.set("familygradescm", jobFamilyScm.get("jobgradescm"));
                }
                if (pageCache.get("joblevelscmChangeStatus") == null) {
                    jobfamily.set("familylevelscm", jobFamilyScm.get("joblevelscm"));
                }
            }
        });
        model.getDataEntity(true).getDynamicObjectCollection("classentryentity").stream().forEach(jobclass -> {
            String jobClassId = jobclass.getString("jobclass_id");
            DynamicObject jobClassScm = (DynamicObject)jobClassScmMap.get(jobClassId);
            if (jobClassScm != null) {
                String gradeRange = TreeToEntryUtil.getFieldRangeStr(jobClassScm.getDynamicObject("lowjobgrade"), jobClassScm.getDynamicObject("highjobgrade"));
                String levelRange = TreeToEntryUtil.getFieldRangeStr(jobClassScm.getDynamicObject("lowjoblevel"), jobClassScm.getDynamicObject("highjoblevel"));
                if (pageCache.get("jobgradescmChangeStatus") == null) {
                    jobclass.set("classgraderange", (Object)gradeRange);
                    jobclass.set("classgradelow", jobClassScm.get("lowjobgrade"));
                    jobclass.set("classgradehigh", jobClassScm.get("highjobgrade"));
                }
                if (pageCache.get("joblevelscmChangeStatus") == null) {
                    jobclass.set("classlevelrange", (Object)levelRange);
                    jobclass.set("classlevellow", jobClassScm.get("lowjoblevel"));
                    jobclass.set("classlevelhigh", jobClassScm.get("highjoblevel"));
                }
            }
        });
    }

    private static Map<String, List<Long>> getTreeSeqFamilyClassIds(IFormView formView) {
        Map treeNodeMap = (Map)JSONObject.parseObject((String)formView.getPageCache().get("hasTreeNodeMap"), (TypeReference)new TypeReference<HashMap<String, TreeNode>>(){}, (Feature[])new Feature[0]);
        Set ids = treeNodeMap.keySet();
        ArrayList<Long> seqIds = new ArrayList<Long>();
        ArrayList<Long> familyIds = new ArrayList<Long>();
        ArrayList<Long> classIds = new ArrayList<Long>();
        for (String idStr : ids) {
            String id = idStr.substring(0, idStr.indexOf(35));
            if (idStr.indexOf("seq") > -1) {
                seqIds.add(Long.parseLong(id));
                continue;
            }
            if (idStr.indexOf("family") > -1) {
                familyIds.add(Long.parseLong(id));
                continue;
            }
            if (idStr.indexOf("class") <= -1) continue;
            classIds.add(Long.parseLong(id));
        }
        HashMap<String, List<Long>> data = new HashMap<String, List<Long>>();
        data.put("seqIds", seqIds);
        data.put("familyIds", familyIds);
        data.put("classIds", classIds);
        return data;
    }

    private static void randerClassEntry(JobScmBaseInfo jobScmCache, DynamicObject[] jobclasses, AbstractFormDataModel model) {
        TableValueSetter classVS = new TableValueSetter(new String[0]);
        classVS.addField("jobclass", new Object[0]);
        classVS.addField("classnumber", new Object[0]);
        classVS.addField("classname", new Object[0]);
        classVS.addField("classparent", new Object[0]);
        classVS.addField("classlevel", new Object[0]);
        classVS.addField("classfamily", new Object[0]);
        classVS.addField("classseq", new Object[0]);
        classVS.addField("classorg", new Object[0]);
        classVS.addField("classenable", new Object[0]);
        classVS.addField("classgraderange", new Object[0]);
        classVS.addField("classlevelrange", new Object[0]);
        classVS.addField("classgradelow", new Object[0]);
        classVS.addField("classgradehigh", new Object[0]);
        classVS.addField("classlevellow", new Object[0]);
        classVS.addField("classlevelhigh", new Object[0]);
        for (DynamicObject jobClass : jobclasses) {
            classVS.addRow(new Object[]{jobClass.get("id"), jobClass.get("number"), jobClass.get("name"), jobClass.get("parent_id"), jobClass.get("jobclasslevel"), jobClass.get("jobfamily_id"), jobClass.get("jobseq_id"), jobScmCache.getCreateorg(), jobClass.get("enable"), null, null, null, null, null, null});
        }
        model.batchCreateNewEntryRow("classentryentity", classVS);
    }

    private static void randerFamilyEntry(JobScmBaseInfo jobScmCache, DynamicObject[] jobfamilys, AbstractFormDataModel model) {
        TableValueSetter familyVS = new TableValueSetter(new String[0]);
        familyVS.addField("jobfamily", new Object[0]);
        familyVS.addField("familynumber", new Object[0]);
        familyVS.addField("familyname", new Object[0]);
        familyVS.addField("familyseq", new Object[0]);
        familyVS.addField("familyorg", new Object[0]);
        familyVS.addField("familyenable", new Object[0]);
        familyVS.addField("familygradescm", new Object[0]);
        familyVS.addField("familylevelscm", new Object[0]);
        for (DynamicObject family : jobfamilys) {
            familyVS.addRow(new Object[]{family.get("id"), family.get("number"), family.get("name"), family.get("jobseq_id"), jobScmCache.getCreateorg(), family.get("enable"), jobScmCache.getJobgradescm(), jobScmCache.getJoblevelscm()});
        }
        model.batchCreateNewEntryRow("familyentryentity", familyVS);
    }

    private static void randerSeqEntry(JobScmBaseInfo jobScmCache, DynamicObject[] jobseqs, AbstractFormDataModel model) {
        TableValueSetter seqVS = new TableValueSetter(new String[0]);
        seqVS.addField("jobseq", new Object[0]);
        seqVS.addField("seqnumber", new Object[0]);
        seqVS.addField("seqname", new Object[0]);
        seqVS.addField("seqstandardseq", new Object[0]);
        seqVS.addField("seqorg", new Object[0]);
        seqVS.addField("seqenable", new Object[0]);
        for (DynamicObject seq : jobseqs) {
            seqVS.addRow(new Object[]{seq.get("id"), seq.get("number"), seq.get("name"), seq.get(STANDARDJOBSEQ_ID), jobScmCache.getCreateorg(), seq.get("enable")});
        }
        model.batchCreateNewEntryRow("seqentryentity", seqVS);
    }

    private static String getFieldRangeStr(DynamicObject lowObject, DynamicObject highObject) {
        String lowJobString = "";
        String highJobString = "";
        String message = "";
        if (highObject != null) {
            highJobString = highObject.getString("name");
        }
        if (lowObject != null) {
            lowJobString = lowObject.getString("name");
        }
        if (StringUtils.isNotEmpty((String)highJobString) && StringUtils.isNotEmpty((String)lowJobString)) {
            message = lowJobString + "-" + highJobString;
        } else if (StringUtils.isNotEmpty((String)lowJobString)) {
            message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u53ca\u4ee5\u4e0a", (String)"TreeToEntryUtil_0", (String)"odc-hjm-formplugin", (Object[])new Object[0]), lowJobString);
        } else if (StringUtils.isNotEmpty((String)highJobString)) {
            message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u53ca\u4ee5\u4e0b", (String)"TreeToEntryUtil_1", (String)"odc-hjm-formplugin", (Object[])new Object[0]), highJobString);
        }
        return message;
    }
}

