/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.help;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.homs.business.service.batcheffect.BatchEffectController;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.validcommon.BaseDataWithBusinessUnitCheck;
import kd.hr.homs.common.model.CalibratorBean;

public class AdminFastChgSaveHelper {
    private final HRBaseServiceHelper BILL_ENTRY = OrgBatchValidateHelper.BATCHORGENTITY_HELPER;
    private BatchEffectController effectController;
    private Map<Long, List<Long>> sceneSubMap;
    private DynamicObject billDyn;
    private DynamicObject[] dataEntities;
    private AdminChgDetailService adminChgDetailService;
    private static Map<String, String> type2EntityType = new HashMap<String, String>(){
        {
            this.put("changereason", "haos_orgchangereason");
            this.put("changescene", "haos_changescene");
        }
    };
    private static Map<String, String> resourceMap = new HashMap<String, String>(){
        {
            this.put("changereason", "OrgBaseDataCheck_8");
            this.put("changescene", "OrgBaseDataCheck_9");
        }
    };
    private static Map<String, String> descriptionMap = new HashMap<String, String>(){
        {
            this.put("changereason", ResManager.loadKDString((String)"\u53d8\u52a8\u539f\u56e0", (String)"OrgBaseDataCheck_8", (String)"odc-homs-business", (Object[])new Object[0]));
            this.put("changescene", ResManager.loadKDString((String)"\u53d8\u52a8\u573a\u666f", (String)"OrgBaseDataCheck_9", (String)"odc-homs-business", (Object[])new Object[0]));
        }
    };

    public static List<CalibratorBean> baseDataWithBuCheck(ExtendedDataEntity bill, DynamicObjectCollection entryentityCollection) {
        for (DynamicObject dyn : entryentityCollection) {
            dyn.set("changescene", bill.getDataEntity().get("billchangescene"));
            dyn.set("changereason", bill.getDataEntity().get("billchangereason"));
        }
        return new BaseDataWithBusinessUnitCheck.BaseDataWithBusinessUnitCheckBuilder().orgName(bill.getDataEntity().getString("org.name")).orgId(bill.getDataEntity().getLong("org.id")).systemType("odc-homs-business").addAllCheckDynamicObject((Collection)entryentityCollection).metaPropToDescription(descriptionMap).metaPropToEntityType(type2EntityType).metaPropToResourceId(resourceMap).build().check().getResult();
    }

    public void enableAndDisableBeforeSave(BeginOperationTransactionArgs args, String from) {
        DynamicObject billDyn = args.getDataEntities()[0];
        DynamicObjectCollection entryEntity = billDyn.getDynamicObjectCollection("entryentity");
        if (ObjectUtils.isEmpty((Object)entryEntity)) {
            return;
        }
        billDyn.set("billstatus", (Object)"C");
        HashMap<Long, Long> org2EntryId = new HashMap<Long, Long>();
        List orgBoids = entryEntity.stream().map(dy -> dy.getLong("adminorg.boid")).collect(Collectors.toList());
        Map orgId2OldInfoDynMap = OrgBatchBillCheckHelper.batchQueryOrgDetailInfoById((Set)Sets.newHashSet(orgBoids));
        long[] billEntryIds = ORM.create().genLongIds("homs_batchorgentity", orgBoids.size());
        int index = 0;
        DynamicObject[] dataEnties = new DynamicObject[entryEntity.size()];
        HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)1);
        ignoreKeys.add("tobedisableflag");
        for (DynamicObject dyn : entryEntity) {
            long orgBoId = dyn.getLong("adminorg.boid");
            DynamicObject orgInfo = (DynamicObject)orgId2OldInfoDynMap.get(orgBoId);
            HRDynamicObjectUtils.copy((DynamicObject)orgInfo, (DynamicObject)dyn, (Set)ignoreKeys);
            DynamicObject adminOrg = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail"));
            adminOrg.set("id", (Object)orgInfo.getLong("sourcevid"));
            adminOrg.set("boid", (Object)orgInfo.getLong("boid"));
            adminOrg.set("org", orgInfo.get("org"));
            dyn.set("adminorg", (Object)adminOrg);
            dyn.set("adminorgboid", (Object)orgInfo.getLong("boid"));
            DynamicObject parentOrg = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail"));
            parentOrg.set("id", (Object)orgInfo.getLong("parentorg.sourcevid"));
            parentOrg.set("boid", (Object)orgInfo.getLong("parentorg.boid"));
            dyn.set("parentorg", (Object)parentOrg);
            this.fillTobeDisableFlag(from, billDyn, dyn);
            dyn.set("changescene", billDyn.get("billchangescene"));
            dyn.set("changedescription", billDyn.get("billchangedescription"));
            dyn.set("changereason", billDyn.get("billchangereason"));
            long entryId = billEntryIds[index];
            dyn.set("id", (Object)entryId);
            org2EntryId.put(orgBoId, entryId);
            DynamicObject dynamicObject = this.BILL_ENTRY.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)orgInfo, (DynamicObject)dynamicObject);
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)dynamicObject);
            dynamicObject.set("id", dyn.get("id"));
            dynamicObject.set("org", dyn.get("entry_org"));
            dynamicObject.set("creator", billDyn.get("creator"));
            dynamicObject.set("modifier", billDyn.get("modifier"));
            dynamicObject.set("bsed", billDyn.get("effdt"));
            dataEnties[index] = dynamicObject;
            ++index;
        }
        this.adminChgDetailService = new AdminChgDetailService(AdminOrgFastChgHelper.getCompanyMap(orgBoids, (String)"1"), AdminOrgFastChgHelper.getGroupMap(orgBoids, (String)"1"), AdminOrgFastChgHelper.getDepartmentMap(orgBoids, (String)"1"), AdminOrgBatchChgHelper.getOrgId2CoopDynsMap(orgBoids), orgBoids);
        AdminOrgChgBillSaveService billSaveService = AdminOrgChgBillSaveService.getInstance();
        Map oldOrgRelateVersionMap = billSaveService.getOrgRelateVersion(orgBoids);
        Map oldOrgBasicInfo = billSaveService.getOrgBeforeChangeVersionBasicInfo(orgBoids);
        HRBaseServiceHelper coopService = new HRBaseServiceHelper("homs_batchentrycoop");
        ArrayList<DynamicObject> needSaveCoopEntry = new ArrayList<DynamicObject>();
        this.fillEntryCoop(org2EntryId, orgId2OldInfoDynMap, coopService, needSaveCoopEntry);
        coopService.save(needSaveCoopEntry.toArray(new DynamicObject[0]));
        this.sceneSubMap = new ChangeSceneSubService().getSceneSubId(Arrays.stream(dataEnties).collect(Collectors.toList()));
        this.effectController = BatchEffectController.createBatchEffectController((DynamicObject)billDyn, (DynamicObject[])dataEnties);
        this.effectController.saveAdminOrg();
        Map newOrgRelateVersionMap = billSaveService.getOrgRelateVersion(orgBoids);
        billSaveService.setBeforeAndAfterChgVersionId(dataEnties, newOrgRelateVersionMap, oldOrgRelateVersionMap, oldOrgBasicInfo);
        billSaveService.setBeforeAndAfterChgVersionId((DynamicObject[])entryEntity.toArray((Object[])new DynamicObject[0]), newOrgRelateVersionMap, oldOrgRelateVersionMap, oldOrgBasicInfo);
        this.dataEntities = dataEnties;
        this.billDyn = billDyn;
        TransactionModelService transactionService = new TransactionModelService();
        transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(billDyn.getLong("id")), false, dataEnties, this.sceneSubMap);
    }

    private void fillTobeDisableFlag(String from, DynamicObject billDyn, DynamicObject dyn) {
        if ("disabled".equals(from) && dyn.getBoolean("tobedisableflag")) {
            dyn.set("tobedisableflag", (Object)false);
            dyn.set("tobedisabledate", null);
        } else if ("enabled".equals(from) && dyn.getBoolean("tobedisableflag")) {
            dyn.set("tobedisabledate", billDyn.get("effdt"));
        } else if ("enabled".equals(from) && !dyn.getBoolean("tobedisableflag")) {
            dyn.set("tobedisabledate", null);
        }
    }

    private void fillEntryCoop(Map<Long, Long> org2EntryId, Map<Long, DynamicObject> orgId2OldInfoDynMap, HRBaseServiceHelper coopService, List<DynamicObject> needSaveCoopEntry) {
        for (Map.Entry<Long, Long> entry : org2EntryId.entrySet()) {
            DynamicObject orgOldInfoDyn = orgId2OldInfoDynMap.get(entry.getKey());
            DynamicObjectCollection cooprelentryentity = orgOldInfoDyn.getDynamicObjectCollection("cooprelentryentity");
            Optional.ofNullable(cooprelentryentity).ifPresent(coopEntryEntity -> coopEntryEntity.forEach(coopEntity -> {
                DynamicObject dynO = coopService.generateEmptyDynamicObject();
                dynO.set("coopreltyp", (Object)coopEntity.getDynamicObject("coopreltyp"));
                dynO.set("cooporgteam", coopEntity.get("cooporgteam.sourcevid"));
                dynO.set("cooprelid", coopEntity.get("cooprelid"));
                dynO.set("entryid", entry.getValue());
                needSaveCoopEntry.add(dynO);
            }));
        }
    }

    public void saveAdminOrgChgDetail() {
        this.adminChgDetailService.saveAdminOrgChgDetail(this.billDyn, this.dataEntities);
    }

    public BatchEffectController getEffectController() {
        return this.effectController;
    }

    public Map<Long, List<Long>> getSceneSubMap() {
        return this.sceneSubMap;
    }

    public DynamicObject[] getDataEntities() {
        return this.dataEntities;
    }
}

