/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.impo;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.hr.homs.business.service.orgfast.FastchgImportValidateHelper;

public class AdmingorgImportValidator
extends HRCoreBaseBillValidator {
    private static final Log LOG = LogFactory.getLog(AdmingorgImportValidator.class);

    public void validate() {
        LOG.info(String.format(Locale.ROOT, "user is %s", RequestContext.get().getCurrUserId()));
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator validate start time is: %s", System.currentTimeMillis()));
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        FastchgImportValidateHelper validatehelper = new FastchgImportValidateHelper(dataEntities);
        String operateKey = this.getOperateKey();
        List numbers = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getString("number")).collect(Collectors.toList());
        List parentnumbers = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getString("parentorg.number")).collect(Collectors.toList());
        numbers.removeAll(parentnumbers);
        numbers.addAll(parentnumbers);
        HRBaseServiceHelper adminHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter dataStatusfilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"2");
        DynamicObject[] dysInDB = adminHelper.loadDynamicObjectArray(new QFilter[]{numberFilter, dataStatusfilter, initstatusFilter, iscurrentversionFilter});
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator checkOrgNumberEffectiveness start time is: %s", System.currentTimeMillis()));
        if ("confirmchangenoaudit".equals(operateKey)) {
            validatehelper.checkOrgNumberEffectiveness(dataEntities, dysInDB, operateKey);
        }
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator checkOrgNameEffectiveness start time is: %s", System.currentTimeMillis()));
        validatehelper.checkOrgNameEffectiveness(operateKey);
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator checkParentOrgEffectiveness start time is: %s", System.currentTimeMillis()));
        validatehelper.checkParentOrgEffectiveness(dysInDB, operateKey);
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator checkAffiliation start time is: %s", System.currentTimeMillis()));
        if (!"save".equals(operateKey)) {
            validatehelper.checkAffiliation();
        }
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator check4Model start time is: %s", System.currentTimeMillis()));
        validatehelper.check4Model(operateKey);
        Map orgbaseinfoBsedMap = Arrays.stream(dysInDB).filter(dy -> "1".equals(dy.getString("enable"))).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        if ("confirmchangenoaudit".equals(this.getOperateKey())) {
            validatehelper.checkEffdt(dataEntities, orgbaseinfoBsedMap);
        }
        Map errorMap = validatehelper.getErrorMap();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            int rowIndex = extendedDataEntity.getDataEntityIndex();
            if (!errorMap.containsKey(rowIndex) || ((List)errorMap.get(rowIndex)).isEmpty()) continue;
            ((List)errorMap.get(rowIndex)).stream().forEach(errorMsg -> this.addFatalErrorMessage(extendedDataEntity, (String)errorMsg));
            LOG.info(String.format(Locale.ROOT, "\u6821\u9a8c\u7ed3\u679c %s", errorMap.get(rowIndex)));
        }
        LOG.info(String.format(Locale.ROOT, "AdmingorgImportValidator validate end time is: %s", System.currentTimeMillis()));
    }
}

