/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.impo;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.hr.homs.business.service.orgfast.FastchgImportValidateHelper;

public class AdmingorgNewImportValidator
extends HRCoreBaseBillValidator {
    private static final Log LOG = LogFactory.getLog(AdmingorgNewImportValidator.class);

    public void validate() {
        int rowIndex;
        LOG.info(String.format(Locale.ROOT, "AdmingorgNewImportValidator validate start time is: %s", System.currentTimeMillis()));
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DataEntityPropertyCollection properties = dataEntities[0].getDataEntity().getDataEntityType().getProperties();
        String operateKey = this.getOperateKey();
        FastchgImportValidateHelper validatehelper = new FastchgImportValidateHelper(dataEntities);
        DynamicObject[] companyareas = validatehelper.getCompanyareasAndCityAndworkPlace(dataEntities, "bd_country", "companyarea.id", "id");
        DynamicObject[] citys = validatehelper.getCompanyareasAndCityAndworkPlace(dataEntities, "bd_admindivision", "city.id", "id, country.id");
        DynamicObject[] workplaces = validatehelper.getCompanyareasAndCityAndworkPlace(dataEntities, "hbss_workplace", "workplace.id", "id");
        Map companyareaIds = Arrays.stream(companyareas).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (oldV, newV) -> newV));
        Map<Long, Long> cityMap = Arrays.stream(citys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("country.id")));
        List workplaceIds = Arrays.stream(workplaces).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        validatehelper.checkNewImportOrgNumber();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            rowIndex = extendedDataEntity.getDataEntityIndex();
            this.checkNewMustInput(extendedDataEntity, properties);
            validatehelper.checkBasedataInBU(dataEntity, rowIndex, operateKey);
            validatehelper.checkTextOverLength(dataEntity, rowIndex);
            validatehelper.checkAdminorgtype(dataEntity, rowIndex);
            validatehelper.checkOrgAndBsed(dataEntity, rowIndex);
            validatehelper.checkCompanyarea(dataEntity, rowIndex, companyareaIds, cityMap, workplaceIds);
        }
        Map errorMap = validatehelper.getErrorMap();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            rowIndex = extendedDataEntity.getDataEntityIndex();
            if (!errorMap.containsKey(rowIndex) || ((List)errorMap.get(rowIndex)).isEmpty()) continue;
            ((List)errorMap.get(rowIndex)).stream().forEach(errorMsg -> this.addFatalErrorMessage(extendedDataEntity, (String)errorMsg));
        }
        LOG.info(String.format(Locale.ROOT, "AdmingorgNewImportValidator validate end time is: %s", System.currentTimeMillis()));
    }

    private void checkNewMustInput(ExtendedDataEntity extendedDataEntity, DataEntityPropertyCollection properties) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        StringBuilder errroStr = new StringBuilder();
        String number = dataEntity.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"number")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDate("establishmentdate") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"establishmentdate")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("changescene") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"changescene")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (StringUtils.isEmpty((CharSequence)dataEntity.getLocaleString("name").getLocaleValue())) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"name")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("org") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"org")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("adminorgtype") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"adminorgtype")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (dataEntity.getDynamicObject("parentorg") == null) {
            errroStr.append(((IDataEntityProperty)properties.get((Object)"parentorg")).getDisplayName().getLocaleValue()).append("\u3001");
        }
        if (errroStr.length() == 0) {
            return;
        }
        StringBuilder replaceError = errroStr.deleteCharAt(errroStr.length() - 1);
        this.addFatalErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a%s, \u8bf7\u4fee\u6539;", (String)"FastchgImportValidateHelper_43", (String)"odc-homs-business", (Object[])new Object[0]), replaceError));
    }
}

