/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.impo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.service.impl.orgmsg.CommonOrgMsgService;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.batcheffect.BatchEffectController;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.opplugin.web.impo.AdmingorgImportValidator;
import kd.hr.homs.opplugin.web.impo.AdmingorgNewImportValidator;
import kd.hr.homs.opplugin.web.impo.CoopOrgInfoImportValidator;

public class AdminorgFastNewImportSaveOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(AdminorgFastNewImportSaveOp.class);
    private MainEntityType teamEntityType;
    private BatchEffectController effectController;
    private DynamicObject[] thisDataEntities;
    private DynamicObject thisBill;
    private AdminChgDetailService adminChgDetailService;
    private List<Long> allBoids;
    private Map<Long, List<Long>> sceneSubMap;
    private Map<Long, Integer> indexMap;

    public void onAddValidators(AddValidatorsEventArgs e) {
        DynamicObject[] dataEntities;
        super.onAddValidators(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("bsed", (Object)dataEntity.getDate("establishmentdate"));
        }
        e.addValidator((AbstractValidator)new AdmingorgNewImportValidator());
        e.addValidator((AbstractValidator)new AdmingorgImportValidator());
        e.addValidator((AbstractValidator)new CoopOrgInfoImportValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        int i;
        LOG.info(String.format(Locale.ROOT, "AdminorgFastNewImportSaveOp beginOperationTransaction start time is: %s", System.currentTimeMillis()));
        DynamicObject[] dataEntities = e.getDataEntities();
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_orgbatchchgbill");
        DynamicObject billDy = new DynamicObject((DynamicObjectType)billEntityType);
        long billId = ORM.create().genLongId("homs_orgbatchchgbill");
        billDy.set("id", (Object)billId);
        billDy.set("auditstatus", (Object)"H");
        billDy.set("billstatus", (Object)"C");
        billDy.set("effdt", (Object)new Date());
        billDy.set("billtype", (Object)"4");
        this.thisBill = billDy;
        long[] entryIds = ORM.create().genLongIds("homs_batchorgentity", dataEntities.length);
        DynamicObjectCollection entryDys = new DynamicObjectCollection();
        this.allBoids = new ArrayList<Long>(dataEntities.length);
        this.indexMap = new HashMap<Long, Integer>(dataEntities.length);
        for (i = 0; i < dataEntities.length; ++i) {
            DynamicObject orgDy = dataEntities[i];
            this.setOrgIndex(orgDy);
            orgDy.set("bsed", orgDy.get("establishmentdate"));
            orgDy.set("iscurrentversion", (Object)"1");
            this.allBoids.add(orgDy.getLong("id"));
            orgDy.set("boid", (Object)orgDy.getLong("id"));
            MainEntityType addEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_batchorgentity");
            DynamicObject addEntityDy = new DynamicObject((DynamicObjectType)addEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)orgDy, (DynamicObject)addEntityDy);
            addEntityDy.set("id", (Object)entryIds[i]);
            addEntityDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
            addEntityDy.set("billid", (Object)billId);
            addEntityDy.set("orgid", (Object)orgDy.getLong("id"));
            addEntityDy.set("adminorg", (Object)orgDy);
            MainEntityType changeType = MetadataServiceHelper.getDataEntityType((String)"haos_orgchangetype");
            DynamicObject changeTypeDy = new DynamicObject((DynamicObjectType)changeType);
            changeTypeDy.set("id", (Object)1010L);
            addEntityDy.set("changetype", (Object)changeTypeDy);
            this.replaceTeamFid(addEntityDy);
            entryDys.add((Object)addEntityDy);
        }
        this.thisDataEntities = new DynamicObject[entryDys.size()];
        for (i = 0; i < entryDys.size(); ++i) {
            this.thisDataEntities[i] = (DynamicObject)entryDys.get(i);
        }
        AdminOrgOpService.getInstance().saveTemporary(dataEntities, Long.valueOf(0L), false);
        this.adminChgDetailService = new AdminChgDetailService(AdminOrgFastChgHelper.getCompanyMap(this.allBoids, (String)"1"), AdminOrgFastChgHelper.getGroupMap(this.allBoids, (String)"1"), AdminOrgFastChgHelper.getDepartmentMap(this.allBoids, (String)"1"), AdminOrgBatchChgHelper.getOrgId2CoopDynsMap(this.allBoids), this.allBoids);
        AdminOrgChgBillSaveService service = AdminOrgChgBillSaveService.getInstance();
        Map oldVersionMap = service.getOrgRelateVersion(this.allBoids);
        Map oldOrgBasicInfo = service.getOrgBeforeChangeVersionBasicInfo(this.allBoids);
        service.setBeforeBillEntryVersionId(this.thisDataEntities, oldVersionMap, oldOrgBasicInfo);
        this.sceneSubMap = new ChangeSceneSubService().getSceneSubId(Arrays.asList(this.thisDataEntities));
        this.effectController = BatchEffectController.createBatchEffectController((DynamicObject)billDy, (DynamicObject[])this.thisDataEntities);
        this.effectController.saveAdminOrgAndBillEntry();
        HRBaseServiceHelper billServiceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        billDy.set("billtype", (Object)"1");
        billServiceHelper.saveOne(billDy);
        TransactionModelService transactionService = new TransactionModelService();
        transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(billDy.getLong("id")), false, this.thisDataEntities, this.sceneSubMap);
        this.adminChgDetailService.saveAdminOrgChgDetail(this.thisBill, this.thisDataEntities);
        LOG.info(String.format(Locale.ROOT, "AdminorgFastNewImportSaveOp beginOperationTransaction end time is: %s", System.currentTimeMillis()));
    }

    private void replaceTeamFid(DynamicObject addEntityDy) {
        DynamicObjectCollection entryCol = addEntityDy.getDynamicObjectCollection("cooprelentryentity");
        if (CollectionUtils.isEmpty((Collection)entryCol)) {
            return;
        }
        if (this.teamEntityType == null) {
            this.teamEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_adminorgteam");
        }
        for (DynamicObject dy : entryCol) {
            DynamicObject newTeamDy = new DynamicObject((DynamicObjectType)this.teamEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)dy.getDynamicObject("cooporgteam"), (DynamicObject)newTeamDy);
            newTeamDy.set("id", newTeamDy.get("sourcevid"));
            dy.set("cooporgteam", (Object)newTeamDy);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        LOG.info(String.format(Locale.ROOT, "AdminorgFastNewImportSaveOp afterExecuteOperationTransaction start time is: %s", System.currentTimeMillis()));
        super.afterExecuteOperationTransaction(e);
        this.effectController.afterEffectBill();
        CommonOrgMsgService.handleBatchOrgMsg((DynamicObject[])this.thisDataEntities, this.sceneSubMap, (String)"C");
        LOG.info(String.format(Locale.ROOT, "AdminorgFastNewImportSaveOp afterExecuteOperationTransaction end time is: %s", System.currentTimeMillis()));
    }

    public void onReturnOperation(ReturnOperationArgs args) {
        super.onReturnOperation(args);
        IOperationResult operationResult = args.getOperationResult();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
            operationResult.getSuccessPkIds().addAll(this.allBoids);
        }
    }

    private void setOrgIndex(DynamicObject orgDy) {
        if (orgDy.getInt("index") == 0) {
            long parentId = orgDy.getDynamicObject("parentorg").getLong("id");
            Integer index = this.indexMap.getOrDefault(parentId, 0);
            index = index.equals(99999) ? Integer.valueOf(99999) : Integer.valueOf(index + 1);
            orgDy.set("index", (Object)index);
            this.indexMap.put(parentId, index);
        }
    }
}

