/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.impo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.service.impl.orgmsg.CommonOrgMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.CompanychangeMsgService;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.batcheffect.BatchEffectController;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.opplugin.web.impo.AdmingorgImportValidator;

public class AdminorgFastUpdateImportOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(AdminorgFastUpdateImportOp.class);
    private BatchEffectController effectController;
    private Map<Long, List<Long>> sceneSubMap;
    private DynamicObject[] entryentities;
    private DynamicObject bill;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AdmingorgImportValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.getOption().setVariableValue("saveHisFlag", "false");
        LOG.info("set saveHisFlag false");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        LOG.info(String.format(Locale.ROOT, "AdminorgFastUpdateImportOp beforeExecuteOperationTransaction start time is: %s", System.currentTimeMillis()));
        DynamicObject[] dataEntities = e.getDataEntities();
        this.entryentities = new DynamicObject[dataEntities.length];
        ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntities.length);
        int index = 0;
        DynamicObject userDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        userDy.set("id", (Object)RequestContext.get().getCurrUserId());
        ArrayList<Long> orgboids = new ArrayList<Long>();
        List parentboids = Arrays.stream(dataEntities).peek(dy -> orgboids.add(dy.getLong("boid"))).map(dy -> dy.getLong("parentorg.boid")).distinct().collect(Collectors.toList());
        parentboids.addAll(orgboids);
        QFilter filter = new QFilter("boid", "in", parentboids);
        Date today = new Date();
        filter.and(new QFilter("bsed", "<=", (Object)today));
        filter.and(new QFilter("bsled", ">=", (Object)today));
        filter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        filter.and(new QFilter("initstatus", "=", (Object)"2"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        HRBaseServiceHelper adminorgHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] dynamicObjects = adminorgHelper.loadDynamicObjectArray(filter.toArray());
        Map orgMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("boid"), Function.identity()));
        this.bill = OrgBatchValidateHelper.ORGBATCHCHGBILL_HELPER.generateEmptyDynamicObject();
        this.bill.set("id", (Object)ORM.create().genLongId("homs_orgbatchchgbill"));
        this.bill.set("billstatus", (Object)"C");
        this.bill.set("auditstatus", (Object)"C");
        this.bill.set("billtype", (Object)"4");
        this.bill.set("creator", (Object)userDy);
        this.bill.set("createtime", (Object)new Date());
        HRBaseServiceHelper cooprelhelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter orgfilter = new QFilter("org", "in", orgboids);
        orgfilter.and(new QFilter("enable", "=", (Object)"1"));
        orgfilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        orgfilter.and(new QFilter("datastatus", "=", (Object)"1"));
        orgfilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObject[] cooprelEntities = cooprelhelper.loadDynamicObjectArray(orgfilter.toArray());
        Map<Long, List<DynamicObject>> cooprelList = Arrays.stream(cooprelEntities).collect(Collectors.groupingBy(dy -> dy.getLong("org.id")));
        Map<Long, DynamicObject> groups = this.getOtherInfos(orgboids, "haos_adminorggroup", "adminorg,groupvision,groupmission");
        Map<Long, DynamicObject> companys = this.getOtherInfos(orgboids, "haos_adminorgcompany", "adminorg,companytype,industrytype");
        Map<Long, DynamicObject> departments = this.getOtherInfos(orgboids, "haos_adminorgdepartment", "adminorg,departmenttype");
        long[] billEntryIds = ORM.create().genLongIds("homs_batchorgentity", dataEntities.length);
        for (DynamicObject target : dataEntities) {
            this.bill.set("effdt", (Object)target.getDate("bsed"));
            DynamicObject entryentity = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)target, (DynamicObject)entryentity);
            entryentity.set("bsled", (Object)OrgDateTimeUtil.BSLED);
            entryentity.set("bsed", this.bill.get("effdt"));
            entryentity.set("billid", (Object)this.bill.getLong("id"));
            entryentity.set("id", (Object)billEntryIds[index]);
            entryentity.set("parentorg", orgMap.get(target.getLong("parentorg.boid")));
            entryentity.set("adminorg", orgMap.get(target.getLong("boid")));
            this.setCooprel(entryentity, cooprelList, target.getLong("boid"));
            this.setOtherInfos(entryentity, target, groups, companys, departments);
            Date tobeDisableDate = null;
            if (entryentity.getBoolean("tobedisableflag") && (tobeDisableDate = entryentity.getDate("tobedisabledate")) == null) {
                tobeDisableDate = this.bill.getDate("effdt");
            }
            entryentity.set("tobedisabledate", (Object)tobeDisableDate);
            entryentity.set("changetype", (Object)entryentity.getDynamicObject("changescene.orgchangetype"));
            this.entryentities[index++] = entryentity;
            orgIdList.add(target.getLong("adminorg.boid"));
        }
        List entryentityList = Arrays.stream(this.entryentities).collect(Collectors.toList());
        AdminChgDetailService adminChgDetailService = new AdminChgDetailService(AdminOrgFastChgHelper.getCompanyMap(orgIdList, (String)"1"), AdminOrgFastChgHelper.getGroupMap(orgIdList, (String)"1"), AdminOrgFastChgHelper.getDepartmentMap(orgIdList, (String)"1"), AdminOrgBatchChgHelper.getOrgId2CoopDynsMap(orgIdList), orgIdList);
        AdminOrgChgBillSaveService service = AdminOrgChgBillSaveService.getInstance();
        Map oldVersionMap = service.getOrgRelateVersion(orgIdList);
        Map oldOrgBasicInfo = service.getOrgBeforeChangeVersionBasicInfo(orgIdList);
        service.setBeforeBillEntryVersionId(this.entryentities, oldVersionMap, oldOrgBasicInfo);
        this.sceneSubMap = new ChangeSceneSubService().getSceneSubId(entryentityList);
        this.effectController = BatchEffectController.createBatchEffectController((DynamicObject)this.bill, (DynamicObject[])this.entryentities);
        this.effectController.saveAdminOrgAndBillEntry();
        TransactionModelService transactionService = new TransactionModelService();
        transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(this.bill.getLong("id")), false, this.entryentities, this.sceneSubMap);
        adminChgDetailService.saveAdminOrgChgDetail(this.bill, this.entryentities);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        this.bill.set("billtype", (Object)"1");
        helper.updateOne(this.bill);
        LOG.info(String.format(Locale.ROOT, "AdminorgFastUpdateImportOp beforeExecuteOperationTransaction end time is: %s", System.currentTimeMillis()));
    }

    private Map<Long, DynamicObject> getOtherInfos(List<Long> orgboids, String entity, String selectFields) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
        QFilter orgfilter = new QFilter("adminorg", "in", orgboids);
        orgfilter.and(new QFilter("enable", "=", (Object)"1"));
        orgfilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        orgfilter.and(new QFilter("datastatus", "=", (Object)"1"));
        orgfilter.and(new QFilter("initstatus", "=", (Object)"2"));
        DynamicObject[] query = helper.query(selectFields, orgfilter.toArray());
        return Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), Function.identity()));
    }

    private void setOtherInfos(DynamicObject entryentity, DynamicObject target, Map<Long, DynamicObject> groups, Map<Long, DynamicObject> companys, Map<Long, DynamicObject> departments) {
        long boid = target.getLong("boid");
        long adminorgtypestd = target.getLong("adminorgtype.adminorgtypestd.id");
        DynamicObject group = groups.getOrDefault(boid, new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"haos_adminorggroup")));
        DynamicObject company = companys.getOrDefault(boid, new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"haos_adminorgcompany")));
        DynamicObject deparment = departments.getOrDefault(boid, new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"haos_adminorgdepartment")));
        if (adminorgtypestd == AdminOrgType.GROUP.getId()) {
            boolean groupvisionIsEmpty = target.getLocaleString("groupvision").values().stream().filter(name -> !StringUtils.isEmpty((CharSequence)name)).collect(Collectors.toList()).isEmpty();
            boolean groupmissionIsEmpty = target.getLocaleString("groupmission").values().stream().filter(name -> !StringUtils.isEmpty((CharSequence)name)).collect(Collectors.toList()).isEmpty();
            entryentity.set("groupvision", groupvisionIsEmpty ? group.get("groupvision") : target.get("groupvision"));
            entryentity.set("groupmission", groupmissionIsEmpty ? group.get("groupmission") : target.get("groupmission"));
            entryentity.set("companytype", target.get("companytype") == null ? company.get("companytype") : target.get("companytype"));
            entryentity.set("industrytype", target.get("industrytype") == null ? company.get("industrytype") : target.get("industrytype"));
        } else if (AdminOrgType.COMPANY.getId() == adminorgtypestd) {
            entryentity.set("companytype", target.get("companytype") == null ? company.get("companytype") : target.get("companytype"));
            entryentity.set("industrytype", target.get("industrytype") == null ? company.get("industrytype") : target.get("industrytype"));
        } else if (AdminOrgType.DEPARTMENT.getId() == adminorgtypestd) {
            entryentity.set("departmenttype", target.get("departmenttype") == null ? deparment.get("departmenttype") : target.get("departmenttype"));
        }
    }

    private void setCooprel(DynamicObject entryentity, Map<Long, List<DynamicObject>> cooprelList, Long boid) {
        DynamicObjectCollection cooprelentryentity = entryentity.getDynamicObjectCollection("cooprelentryentity");
        List<DynamicObject> cooprels = cooprelList.get(boid);
        if (cooprels == null || cooprels.isEmpty()) {
            return;
        }
        DynamicObjectType dynamicObjectType = cooprelentryentity.getDynamicObjectType();
        for (DynamicObject cooprel : cooprels) {
            DynamicObject coopre = new DynamicObject(dynamicObjectType);
            if (cooprel.getLong("coopreltype.id") == 1010L) continue;
            long sourcevid = cooprel.getLong("cooporgteam.sourcevid");
            DynamicObject cooporgteam = cooprel.getDynamicObject("cooporgteam");
            cooporgteam.set("id", (Object)sourcevid);
            cooporgteam.set("sourcevid", (Object)0L);
            coopre.set("coopreltyp", (Object)cooprel.getDynamicObject("coopreltype"));
            coopre.set("cooporgteam", (Object)cooporgteam);
            coopre.set("cooprelid", (Object)cooprel.getLong("id"));
            cooprelentryentity.add((Object)coopre);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs operationArgs) {
        this.effectController.afterEffectBill();
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        List companyChangeOrgList = this.effectController.getCompanyChangeOrgList();
        CompanychangeMsgService companychangeMsgService = new CompanychangeMsgService();
        companychangeMsgService.handleChangeMsg(companyChangeOrgList, null, "C");
        CommonOrgMsgService.handleBatchOrgMsg((DynamicObject[])this.entryentities, this.sceneSubMap, (String)"C");
    }
}

