/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.impo;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class CoopOrgInfoImportValidator
extends HRCoreBaseBillValidator {
    private static final Log LOG = LogFactory.getLog(CoopOrgInfoImportValidator.class);
    private static final String CHOOSE_ALL_ORG = "chooseallorg";
    private AuthorizedOrgTeamResult authorizedOrgResult;
    private Map<Long, Boolean> chooseAllOrgMap;
    private Map<Long, OrgBatchCheckDto> disableMap;
    private Map<Long, DynamicObject> boIdCoopOrgMap = null;

    public void validate() {
        LOG.info(String.format(Locale.ROOT, "CoopOrgInfoImportValidator validate start time is: %s", System.currentTimeMillis()));
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> teamBoIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Long> buOrgIdSet = new HashSet<Long>(dataEntities.length);
        this.buildData(teamBoIdSet, buOrgIdSet);
        if (this.chooseAllOrgMap == null) {
            this.chooseAllOrgMap = SystemParamHelper.getBatchOrgParameter(buOrgIdSet, (String)CHOOSE_ALL_ORG);
        }
        this.boIdCoopOrgMap = this.getBoIdCoopOrgMap(teamBoIdSet);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObjectCollection entryCol = extendedDataEntity.getDataEntity().getDynamicObjectCollection("cooprelentryentity");
            this.checkCoopRelType(extendedDataEntity, entryCol);
        }
        LOG.info(String.format(Locale.ROOT, "CoopOrgInfoImportValidator validate end time is: %s", System.currentTimeMillis()));
    }

    private Map<Long, DynamicObject> getBoIdCoopOrgMap(Set<Long> teamBoIdSet) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1").and("id", "in", teamBoIdSet);
        DynamicObjectCollection col = new HRBaseServiceHelper("haos_adminorgteam").queryOriginalCollection("id,enable,initstatus", new QFilter[]{filter});
        return col.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }

    private void buildData(Set<Long> coopOrgTeamBoId, Set<Long> buOrgIdSet) {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObjectCollection entryCol;
            DynamicObject dy = extendedDataEntity.getDataEntity();
            DynamicObject buOrgDy = dy.getDynamicObject("org");
            if (buOrgDy != null) {
                buOrgIdSet.add(buOrgDy.getLong("id"));
            }
            if (CollectionUtils.isEmpty((Collection)(entryCol = dy.getDynamicObjectCollection("cooprelentryentity")))) continue;
            entryCol.forEach(entry -> coopOrgTeamBoId.add(entry.getLong("cooporgteam.boid")));
        }
        coopOrgTeamBoId.remove(0L);
    }

    private void checkCoopRelType(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection entryCol) {
        if (CollectionUtils.isEmpty((Collection)entryCol)) {
            return;
        }
        HashSet typeIdSet = Sets.newHashSetWithExpectedSize((int)entryCol.size());
        for (DynamicObject dy : entryCol) {
            DynamicObject coopRelTypeDy = dy.getDynamicObject("coopreltyp");
            if (coopRelTypeDy == null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u534f\u4f5c\u5173\u7cfb\u3002", (String)"CoopOrgInfoImportValidator_0", (String)"odc-homs-opplugin", (Object[])new Object[0]));
            } else {
                this.validateRelType(extendedDataEntity, coopRelTypeDy);
                if (!typeIdSet.add(coopRelTypeDy.getLong("id"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CoopOrgInfoImportValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[]{coopRelTypeDy.getString("name")}));
                }
            }
            DynamicObject coopOrgTeamDy = dy.getDynamicObject("cooporgteam");
            if (coopOrgTeamDy == null) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u534f\u4f5c\u7ec4\u7ec7\u3002", (String)"CoopOrgInfoImportValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.validateOrgTeam(extendedDataEntity, coopOrgTeamDy);
        }
    }

    private void validateRelType(ExtendedDataEntity extendedDataEntity, DynamicObject coopRelTypeDy) {
        DynamicObjectCollection dyCol = coopRelTypeDy.getDynamicObjectCollection("orgteamtype");
        if (dyCol.stream().noneMatch(dy -> dy.getLong("fbasedataid.id") == 1010L)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6240\u5c5e\u7ec4\u7ec7\u56e2\u961f\u5305\u542b\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u7684\u534f\u4f5c\u7c7b\u578b\u3002", (String)"CoopOrgInfoImportValidator_7", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
        if (coopRelTypeDy.getLong("id") == 1010L) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u534f\u4f5c\u7c7b\u578b\u201d\u4e0d\u80fd\u586b\u5199\u201c\u96b6\u5c5e\u5173\u7cfb\u201d\uff0c\u201c\u96b6\u5c5e\u5173\u7cfb\u201d\u662f\u7531\u7cfb\u7edf\u6839\u636e\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u81ea\u52a8\u4ea7\u751f\u7684\u3002", (String)"CoopOrgInfoImportValidator_8", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateOrgTeam(ExtendedDataEntity extendedDataEntity, DynamicObject coopOrgTeamDy) {
        DynamicObject currentOrgTeam;
        if (!this.validatePerm(extendedDataEntity, coopOrgTeamDy.getLong("boid"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u4f5c\u7ec4\u7ec7\u201c{0}\u201d\u548c\u201c{1}\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CoopOrgInfoImportValidator_3", (String)"odc-homs-opplugin", (Object[])new Object[]{coopOrgTeamDy.getString("number"), coopOrgTeamDy.getString("name")}));
        }
        if ((currentOrgTeam = this.boIdCoopOrgMap.get(coopOrgTeamDy.getLong("boid"))) == null || "0".equals(currentOrgTeam.getString("enable")) || !"2".equals(currentOrgTeam.getString("initstatus")) || !coopOrgTeamDy.getBoolean("iscurrentversion")) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u4f5c\u7ec4\u7ec7\u201c%s\u201d\u5df2\u505c\u7528\u6216\u4e0d\u5b58\u5728\u3002", (String)"CoopOrgInfoImportValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[]{coopOrgTeamDy.getString("name")}));
        }
        if (coopOrgTeamDy.getLong("teamtype.id") != 1010L) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u4f5c\u7ec4\u7ec7\u53ea\u80fd\u4e3a\u884c\u653f\u7ec4\u7ec7\u6216\u9879\u76ee\u56e2\u961f\u3002", (String)"CoopOrgInfoImportValidator_6", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
        if (this.getDisableMap().get(coopOrgTeamDy.getLong("boid")) != null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u534f\u4f5c\u7ec4\u7ec7\u201c%s\u201d\u5728\u5728\u9014\u5355\u636e\u4e2d\u5df2\u88ab\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CoopOrgInfoImportValidator_5", (String)"odc-homs-opplugin", (Object[])new Object[]{coopOrgTeamDy.getString("name")}));
        }
    }

    private boolean validatePerm(ExtendedDataEntity extendedDataEntity, Long boId) {
        DynamicObject buOrgDy = extendedDataEntity.getDataEntity().getDynamicObject("org");
        if (buOrgDy == null) {
            return true;
        }
        Boolean flag = this.chooseAllOrgMap.get(buOrgDy.getLong("id"));
        if (flag != null && flag.booleanValue()) {
            return true;
        }
        AuthorizedOrgTeamResult result = this.getAuthorizedOrgTeams();
        if (result == null) {
            return false;
        }
        if (result.isHasAllOrgPerm()) {
            return true;
        }
        Map map = result.getHasPermOrgTeamMap();
        if (CollectionUtils.isEmpty((Map)map)) {
            return false;
        }
        for (List list : map.values()) {
            if (CollectionUtils.isEmpty((Collection)list) || !list.contains(boId)) continue;
            return true;
        }
        return false;
    }

    private AuthorizedOrgTeamResult getAuthorizedOrgTeams() {
        this.authorizedOrgResult = this.authorizedOrgResult == null ? AdminOrgFastChgHelper.getAuthorizedOrgTeams((String)"homs_orgfastchgadd", (String)"detailcooporgteam") : this.authorizedOrgResult;
        return this.authorizedOrgResult;
    }

    private Map<Long, OrgBatchCheckDto> getDisableMap() {
        this.disableMap = this.disableMap == null ? OrgBatchBillCheckHelper.queryBillOrgList((Long)OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE).stream().collect(Collectors.toMap(OrgBatchCheckDto::getAdminOrgBoid, checkDto -> checkDto, (key1, key2) -> key2)) : this.disableMap;
        return this.disableMap;
    }
}

