/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.newcardstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class NewCardStyleDeleteValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operationName = "";
        if ("delete".equals(this.getOperateKey())) {
            operationName = ResManager.loadKDString((String)"\u5220\u9664", (String)"NewCardStyleDeleteValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[0]);
        }
        this.validateCardStyleDelete(dataEntities, operationName);
    }

    private void validateCardStyleDelete(ExtendedDataEntity[] dataEntities, String operationName) {
        List<Long> cardids = Arrays.stream(dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select fid,fcardstyleid from t_homs_chartstyleentry where fcardstyleid in (");
        cardids.forEach(cardstyleid -> selectSql.append('?').append(','));
        selectSql.deleteCharAt(selectSql.length() - 1);
        selectSql.append(')');
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_chartstyle");
        QFilter qFilter = new QFilter("chartstyleentry.cardstyle", "in", cardids);
        DynamicObject[] query = hrBaseServiceHelper.query("id,number,chartstyleentry.cardstyle", qFilter.toArray());
        HashMap map = new HashMap(16);
        Stream.of(query).forEach(temp -> {
            DynamicObjectCollection chartstyleentry = temp.getDynamicObjectCollection("chartstyleentry");
            if (chartstyleentry != null) {
                chartstyleentry.forEach(cardstyle -> {
                    Long cardstyleId = cardstyle.getLong("cardstyle.id");
                    ArrayList<String> list = (ArrayList<String>)map.get(cardstyleId);
                    if (list == null) {
                        list = new ArrayList<String>();
                        map.put(cardstyleId, list);
                    }
                    list.add(temp.getString("number"));
                });
            }
        });
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject cardStyle = dataEntity.getDataEntity();
            Long cardStyleId = cardStyle.getLong("id");
            List list = (List)map.get(cardStyleId);
            if (list == null || list.size() <= 0) continue;
            String join = String.join((CharSequence)",", list);
            String param = "\"" + join + "\"";
            String message = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u7ed3\u6784\u56fe\u6837\u5f0f\u201c%S\u201d\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"NewCardStyleDeleteValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[]{operationName}), param);
            this.addFatalErrorMessage(dataEntity, message);
        }
    }
}

