/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.helper.bean.CycleCheckBean;
import kd.hr.homs.business.service.orgbatch.OrgValidateParametersBean;
import kd.hr.homs.opplugin.web.orgbatch.AdminOrgBatchBillCommonValidator;

public class AdminOrgBatchBillValidator
extends AdminOrgBatchBillCommonValidator {
    public static final String SYSTEMTYPE = "odc-homs-opplugin";
    private static final String SEQUENCE = "sequence";
    private static final Log LOG = LogFactory.getLog(AdminOrgBatchBillValidator.class);

    public void validate() {
        long start = System.currentTimeMillis();
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities.length == 0) {
            return;
        }
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        DynamicObject entity = dataEntity.getDataEntity();
        Date effdt = entity.getDate("effdt");
        Date effectdate = effdt == null ? new Date() : effdt;
        DynamicObjectCollection disable = entity.getDynamicObjectCollection("entryentity_disable");
        ArrayList disableIds = Lists.newArrayListWithCapacity((int)disable.size());
        for (DynamicObject dynamicObject : disable) {
            disableIds.add(dynamicObject.getLong("disable_adminorg.boid"));
        }
        this.checkCollaborationCycleByBatchBill(entity, entity.getLong("id"), effectdate, disableIds);
        LOG.info(String.format("==AdminOrgBatchBillValidator==cost:%s", System.currentTimeMillis() - start));
    }

    @Override
    public void checkData(OrgValidateParametersBean orgValidateParametersBean) {
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        List allEntity = orgValidateParametersBean.getAllEntity();
        List entryentityParent = orgValidateParametersBean.getEntryentityParent();
        List entryentityInfo = orgValidateParametersBean.getEntryentityInfo();
        List entryentityAdd = orgValidateParametersBean.getEntryentityAdd();
        List inProgressDeleteData = orgValidateParametersBean.getInProgressDeleteData();
        entryentityAdd.sort(Comparator.comparingInt(o -> o.getInt(SEQUENCE)));
        entryentityParent.sort(Comparator.comparingInt(o -> o.getInt(SEQUENCE)));
        entryentityInfo.sort(Comparator.comparingInt(o -> o.getInt(SEQUENCE)));
        if (this.updateOrgNameByEntryentity(entryentityParent, entryentityInfo, entryentityAdd, dataEntity)) {
            return;
        }
        List entryentityDisable = orgValidateParametersBean.getEntryentityDisable();
        Map orgBoidToBillNo = orgValidateParametersBean.getOrgBoidToBillNo();
        this.disableCheck(dataEntity, entryentityParent, entryentityInfo, entryentityAdd, inProgressDeleteData, entryentityDisable, orgBoidToBillNo);
        this.cycleCheck(orgValidateParametersBean, dataEntity, allEntity, entryentityParent, entryentityInfo, entryentityAdd);
    }

    private void disableCheck(ExtendedDataEntity dataEntity, List<DynamicObject> entryentityParent, List<DynamicObject> entryentityInfo, List<DynamicObject> entryentityAdd, List<DynamicObject> inProgressDeleteData, List<Long> entryentityDisable, Map<Long, String> orgBoidToBillNo) {
        Map map;
        Map parentDisabled;
        String prefix;
        Map addDisabled = OrgBatchValidateHelper.checkOrgDisabled(entryentityAdd, entryentityDisable, inProgressDeleteData);
        if (addDisabled.size() > 0) {
            for (Map.Entry entry : addDisabled.entrySet()) {
                prefix = ResManager.loadKDString((String)"[\u65b0\u589e\u7ec4\u7ec7]\u9875\u7b7e\u4e0b", (String)"AdminOrgBatchBillValidator_04", (String)SYSTEMTYPE, (Object[])new Object[0]);
                this.showDisableErrMessage((Map)entry.getValue(), dataEntity, prefix + "[" + (String)entry.getKey() + "]: ", orgBoidToBillNo);
            }
        }
        if ((parentDisabled = OrgBatchValidateHelper.checkOrgDisabled(entryentityParent, entryentityDisable, inProgressDeleteData)).size() > 0) {
            for (Map.Entry entry : parentDisabled.entrySet()) {
                prefix = ResManager.loadKDString((String)"[\u8c03\u6574\u4e0a\u7ea7]\u9875\u7b7e\u4e0b", (String)"AdminOrgBatchBillValidator_05", (String)SYSTEMTYPE, (Object[])new Object[0]);
                this.showDisableErrMessage((Map)entry.getValue(), dataEntity, prefix + "[" + (String)entry.getKey() + "]: ", orgBoidToBillNo);
            }
        }
        if ((map = OrgBatchValidateHelper.checkOrgDisabled(entryentityInfo, entryentityDisable, inProgressDeleteData)).size() > 0) {
            for (Map.Entry mapEntry : map.entrySet()) {
                prefix = ResManager.loadKDString((String)"[\u53d8\u66f4\u4fe1\u606f]\u9875\u7b7e\u4e0b", (String)"AdminOrgBatchBillValidator_06", (String)SYSTEMTYPE, (Object[])new Object[0]);
                this.showDisableErrMessage((Map)mapEntry.getValue(), dataEntity, prefix + "[" + (String)mapEntry.getKey() + "]: ", orgBoidToBillNo);
            }
        }
    }

    private boolean updateOrgNameByEntryentity(List<DynamicObject> entryentityParent, List<DynamicObject> entryentityInfo, List<DynamicObject> entryentityAdd, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection add = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity_add");
        DynamicObjectCollection parent = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity_parent");
        DynamicObjectCollection info = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity_info");
        if (add.size() < entryentityAdd.size() || parent.size() < entryentityParent.size() || info.size() < entryentityInfo.size()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38,\u672c\u5355\u5206\u5f55\u6570\u636e\u53ef\u80fd\u5df2\u5728\u5176\u4ed6\u9875\u9762\u8fdb\u884c\u4e86\u4fee\u6539\u3002", (String)"AdminOrgBatchBillValidator_03", (String)SYSTEMTYPE, (Object[])new Object[0]));
            return true;
        }
        int i = 0;
        if (add.size() > 0) {
            for (DynamicObject dynamicObject : entryentityAdd) {
                dynamicObject.set("name", (Object)((DynamicObject)add.get(i++)).getString("add_name"));
            }
        }
        if (parent.size() > 0) {
            i = 0;
            for (DynamicObject dynamicObject : entryentityParent) {
                dynamicObject.set("name", (Object)((DynamicObject)parent.get(i++)).getString("parent_name"));
            }
        }
        if (info.size() > 0) {
            i = 0;
            for (DynamicObject dynamicObject : entryentityInfo) {
                dynamicObject.set("name", (Object)((DynamicObject)info.get(i++)).getString("info_name"));
            }
        }
        return false;
    }

    private void cycleCheck(OrgValidateParametersBean orgValidateParametersBean, ExtendedDataEntity dataEntity, List<DynamicObject> allEntity, List<DynamicObject> entryentityParent, List<DynamicObject> entryentityInfo, List<DynamicObject> entryentityAdd) {
        String prefix;
        DynamicObject[] effctiveData = orgValidateParametersBean.getEffctiveData();
        Date effectdate = orgValidateParametersBean.getEffectdate();
        List entryentityDisable = orgValidateParametersBean.getEntryentityDisable();
        List inProgressData = orgValidateParametersBean.getInProgressData();
        Map orgBoidToBillNo = orgValidateParametersBean.getOrgBoidToBillNo();
        allEntity.clear();
        allEntity.addAll(entryentityParent);
        allEntity.addAll(entryentityInfo);
        Map effdtMap = orgValidateParametersBean.getEffdtMap();
        List addStacks = OrgBatchValidateHelper.checkCollaborationCycle(entryentityAdd, allEntity, (Date)effectdate, (List)entryentityDisable, (boolean)true, (DynamicObject[])effctiveData, (List)inProgressData, (Map)effdtMap);
        if (!addStacks.isEmpty()) {
            prefix = ResManager.loadKDString((String)"[\u65b0\u589e\u7ec4\u7ec7]\u9875\u7b7e\u4e0b", (String)"AdminOrgBatchBillValidator_04", (String)SYSTEMTYPE, (Object[])new Object[0]);
            this.showCycleErrMessage(addStacks, dataEntity, prefix, orgBoidToBillNo);
        }
        allEntity.clear();
        allEntity.addAll(entryentityAdd);
        allEntity.addAll(entryentityInfo);
        List parentsStacks = OrgBatchValidateHelper.checkCollaborationCycle(entryentityParent, allEntity, (Date)effectdate, (List)entryentityDisable, (boolean)false, (DynamicObject[])effctiveData, (List)inProgressData, (Map)effdtMap);
        if (!parentsStacks.isEmpty()) {
            prefix = ResManager.loadKDString((String)"[\u8c03\u6574\u4e0a\u7ea7]\u9875\u7b7e\u4e0b", (String)"AdminOrgBatchBillValidator_05", (String)SYSTEMTYPE, (Object[])new Object[0]);
            this.showCycleErrMessage(parentsStacks, dataEntity, prefix, orgBoidToBillNo);
        }
        allEntity.clear();
        allEntity.addAll(entryentityAdd);
        allEntity.addAll(entryentityParent);
        List infoStacks = OrgBatchValidateHelper.checkCollaborationCycle(entryentityInfo, allEntity, (Date)effectdate, (List)entryentityDisable, (boolean)false, (DynamicObject[])effctiveData, (List)inProgressData, (Map)effdtMap);
        if (!infoStacks.isEmpty()) {
            prefix = ResManager.loadKDString((String)"[\u53d8\u66f4\u4fe1\u606f]\u9875\u7b7e\u4e0b", (String)"AdminOrgBatchBillValidator_06", (String)SYSTEMTYPE, (Object[])new Object[0]);
            this.showCycleErrMessage(infoStacks, dataEntity, prefix, orgBoidToBillNo);
        }
    }

    public void showCycleErrMessage(List<Deque<CycleCheckBean>> addStacks, ExtendedDataEntity dataEntity, String prefix, Map<Long, String> orgBoidToBillNo) {
        for (Deque<CycleCheckBean> addStack : addStacks) {
            CycleCheckBean dynamicObject = addStack.peekLast();
            CycleCheckBean first = addStack.peekFirst();
            String source = first.getDataSource();
            prefix = prefix + "[%s]:";
            switch (source) {
                case "inProgress": {
                    source = ResManager.loadKDString((String)"[%1$s]\u534f\u4f5c\u5173\u7cfb\u548c\u5728\u9014\u5355\u636e[%2$s]\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539", (String)"AdminOrgSingleValidate_06", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, prefix + source, dynamicObject.getCheckTarget().getString("name"), dynamicObject.getCoopType().getString("name"), orgBoidToBillNo.get(dynamicObject.getParent().getLong("boid"))));
                    break;
                }
                case "currentBill": {
                    source = ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u548c\u672c\u5355\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgSingleValidate_07", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, prefix + source, dynamicObject.getCheckTarget().getString("name"), dynamicObject.getCoopType().getString("name")));
                    break;
                }
                default: {
                    source = ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u548c\u5df2\u751f\u6548\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgSingleValidate_08", (String)SYSTEMTYPE, (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, prefix + source, dynamicObject.getCheckTarget().getString("name"), dynamicObject.getCoopType().getString("name")));
                }
            }
            StringBuilder printResult = new StringBuilder();
            while (!addStack.isEmpty()) {
                CycleCheckBean pop = addStack.pop();
                printResult.append(pop.toString()).append(System.lineSeparator());
            }
            LOGGER.info(MessageFormat.format("==Cycle validate showCycleErrMessage:{0}{1}", System.lineSeparator(), printResult));
        }
    }
}

