/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.service.impl.orgmsg.CommonOrgMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.CompanychangeMsgService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.haos.business.servicehelper.OrgChangeMsgServiceHelper;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.batcheffect.BatchEffectController;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.orgbatch.OrgBatchBillSaveHelper;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class AdminOrgBatchChgBillEffectiveOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(AdminOrgBatchChgBillEffectiveOp.class);
    BatchEffectController batchEffectController;
    AdminChgDetailService adminChgDetailService;
    private Map<Long, List<Long>> sceneSubMap;
    DynamicObject bill;
    DynamicObject[] billEntries;
    private long startTime = System.currentTimeMillis();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("effdt");
        fieldKeys.add("creator");
        fieldKeys.add("modifier");
        fieldKeys.add("billtype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject bill = dataEntities[0];
        long billId = bill.getLong("id");
        Date effdt = bill.getDate("effdt");
        Object creator = bill.get("creator");
        AdminOrgHisDynamicUtils.EFFECT_DATE.set(effdt);
        DynamicObject[] datas = OrgBatchValidateHelper.BATCHORGENTITY_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("billid", "=", (Object)billId)});
        ArrayList allBoids = Lists.newArrayListWithCapacity((int)(datas != null ? datas.length : 10));
        HashSet structProjectIdSet = Sets.newHashSetWithExpectedSize((int)(datas != null ? datas.length : 10));
        if (datas != null && datas.length > 0) {
            for (DynamicObject data : datas) {
                allBoids.add(data.getLong("adminorg.boid"));
                data.getDynamicObjectCollection("struct_project_entry").stream().map(structRow -> structRow.getLong("struct_project.id")).forEach(structProjectIdSet::add);
                data.set("bsed", (Object)effdt);
                data.set("bsled", (Object)OrgDateTimeUtil.BSLED);
                data.set("creator", creator);
            }
            Arrays.sort(datas, Comparator.comparing(dyn -> dyn.getInt("sequence")));
            Map oldCompanyMap = AdminOrgFastChgHelper.getCompanyMap((List)allBoids, (String)"1");
            Map oldGroupMap = AdminOrgFastChgHelper.getGroupMap((List)allBoids, (String)"1");
            Map oldDepartmentMap = AdminOrgFastChgHelper.getDepartmentMap((List)allBoids, (String)"1");
            Map orgId2CoopDynsMap = AdminOrgBatchChgHelper.getOrgId2CoopDynsMap((List)allBoids);
            this.adminChgDetailService = new AdminChgDetailService(oldCompanyMap, oldGroupMap, oldDepartmentMap, orgId2CoopDynsMap, (List)allBoids);
            this.adminChgDetailService.setNewOrgId2structDynMap(AdminOrgFastChgHelper.getStructEntryMapFromOrgEntry((DynamicObject[])datas));
            this.adminChgDetailService.setOldOrgId2structDynMap(AdminOrgFastChgHelper.getStructMap((List)allBoids, (Set)structProjectIdSet));
            this.setAddOrgNumber(datas);
            this.sceneSubMap = new ChangeSceneSubService().getSceneSubId(Arrays.asList(datas));
            this.batchEffectController = BatchEffectController.createBatchEffectController((DynamicObject)bill, (DynamicObject[])datas);
            this.batchEffectController.effectBill();
            this.bill = bill;
            this.billEntries = datas;
            TransactionModelService transactionService = new TransactionModelService();
            transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(billId), datas, this.sceneSubMap);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.batchEffectController.afterEffectBill();
        this.adminChgDetailService.saveAdminOrgChgDetail(this.bill, this.billEntries);
        LOG.info("AdminOrgBatchChgBillEffectiveOp transaction cost:" + (System.currentTimeMillis() - this.startTime) + "ms");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        List companyChangeOrgList = this.batchEffectController.getCompanyChangeOrgList();
        CompanychangeMsgService companyChangeMsgService = new CompanychangeMsgService();
        companyChangeMsgService.handleChangeMsg(companyChangeOrgList, null, "C");
        CommonOrgMsgService.handleBatchOrgMsg((DynamicObject[])this.billEntries, this.sceneSubMap, (String)"C");
        List adminOrgIds = Arrays.stream(this.billEntries).filter(dyn -> ChangeTransactionConstants.ADD.equals(dyn.getLong("changetype.id"))).map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = OrgChangeMsgServiceHelper.queryByAdminOrgId(adminOrgIds);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dyn2 : dynamicObjects) {
            dyn2.set("adminorgbo", dyn2.get("adminorg"));
        }
        OrgChangeMsgServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    private void setAddOrgNumber(DynamicObject[] datas) {
        List<DynamicObject> addDys = Arrays.stream(datas).filter(dynamicObject -> dynamicObject.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue() && StringUtils.isEmpty((CharSequence)dynamicObject.getString("number"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(addDys)) {
            return;
        }
        Map idVsBelongCompany = AdminOrgBatchChgHelper.findBelongCompanyMap((DynamicObject[])datas);
        ArrayList<DynamicObject> adminorgHrDys = new ArrayList<DynamicObject>(addDys.size());
        for (DynamicObject addDy2 : addDys) {
            DynamicObject adminorgHrDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorghr"));
            HRDynamicObjectUtils.copy((DynamicObject)addDy2, (DynamicObject)adminorgHrDy);
            this.setBelongCompany(addDy2, idVsBelongCompany);
            adminorgHrDy.set("parent", addDy2.get("parentorg"));
            adminorgHrDy.set("orgtype", addDy2.get("adminorgtype"));
            adminorgHrDy.set("company", addDy2.get("belongcompany"));
            adminorgHrDy.set("id", addDy2.get("id"));
            IDataEntityType dataEntityType = adminorgHrDy.getDataEntityType();
            ((BasedataEntityType)dataEntityType).setMainOrg("org");
            boolean codeRuleExistFlag = AdminOrgBatchChgHelper.codeRuleExistFlag((String)"haos_adminorghr", (long)adminorgHrDy.getLong("org.id"), (DynamicObject)adminorgHrDy);
            if (!codeRuleExistFlag) continue;
            adminorgHrDys.add(adminorgHrDy);
        }
        if (!CollectionUtils.isEmpty(adminorgHrDys)) {
            DynamicObject[] entryDyArr;
            ArrayList numberList = new ArrayList(addDys.size());
            OrgBatchBillSaveHelper.setOrgNumber(addDys, adminorgHrDys, numberList);
            Map<Long, String> map = addDys.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getString("number")));
            ArrayList addEntryIds = new ArrayList();
            addDys.forEach(addDy -> addEntryIds.add(addDy.getLong("id")));
            HRBaseServiceHelper addEntryHelper = new HRBaseServiceHelper("homs_batchorgentity");
            for (DynamicObject dynamicObject2 : entryDyArr = addEntryHelper.query("number", new QFilter("id", "in", addEntryIds).toArray())) {
                dynamicObject2.set("number", (Object)map.get(dynamicObject2.getLong("id")));
            }
            addEntryHelper.update(entryDyArr);
        }
    }

    private void setBelongCompany(DynamicObject addDy, Map<Long, DynamicObject> idVsBelongCompany) {
        addDy.set("belongcompany", (Object)idVsBelongCompany.get(addDy.getLong("adminorg.id")));
    }
}

