/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.helper.bean.CycleCheckBean;
import kd.hr.homs.business.service.orgbatch.OrgValidateParametersBean;
import kd.hr.homs.opplugin.web.orgbatch.AdminOrgBatchBillCommonValidator;

public class AdminOrgSingleValidate
extends AdminOrgBatchBillCommonValidator {
    private static final Log LOG = LogFactory.getLog(AdminOrgSingleValidate.class);

    public void validate() {
        Date effectdate;
        super.validate();
        if (Boolean.parseBoolean(this.getOption().getVariableValue("isImport"))) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities.length == 0) {
            return;
        }
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        DynamicObject entity = dataEntity.getDataEntity();
        String parentId = this.getOption().getVariableValue("billId");
        if ("0".equals(parentId)) {
            // empty if block
        }
        String effdt = this.getOption().getVariableValue("effdt");
        try {
            effectdate = HRDateTimeUtils.parseDate((String)effdt, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
            effectdate = new Date();
        }
        String disableOrgIdsString = this.getOption().getVariableValue("disableOrgIds");
        LOG.info(String.format("==AdminOrgSingleValidate==disableOrgIdsString:%s", disableOrgIdsString));
        List disableOrgIds = JSONObject.parseArray((String)disableOrgIdsString, Long.class);
        this.checkCollaborationCycleByBatchBill(entity, Long.parseLong(parentId), effectdate, disableOrgIds);
    }

    @Override
    public void checkData(OrgValidateParametersBean orgValidateParametersBean) {
        DynamicObject entity = orgValidateParametersBean.getEntity();
        List allEntity = orgValidateParametersBean.getAllEntity();
        DynamicObject[] effctiveData = orgValidateParametersBean.getEffctiveData();
        Date effectdate = orgValidateParametersBean.getEffectdate();
        List entryentityDisable = orgValidateParametersBean.getEntryentityDisable();
        List inProgressData = orgValidateParametersBean.getInProgressData();
        List inProgressDeleteData = orgValidateParametersBean.getInProgressDeleteData();
        Map orgBoidToBillNo = orgValidateParametersBean.getOrgBoidToBillNo();
        Map disabledListMap = OrgBatchValidateHelper.checkOrgDisabled(Collections.singletonList(entity), (List)entryentityDisable, (List)inProgressDeleteData);
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        Set entries = disabledListMap.entrySet();
        for (Map.Entry entry : entries) {
            this.showDisableErrMessage((Map)entry.getValue(), dataEntity, "", orgBoidToBillNo);
        }
        Set dynamicObjects = OrgBatchValidateHelper.checkSameTypeCollaborationUnique((DynamicObject)entity);
        this.showUniqueErrMessage(dynamicObjects, dataEntity);
        if (!"homs_batchorgentityadd".equals(this.getEntityKey())) {
            ArrayList<DynamicObject> check = new ArrayList<DynamicObject>(2);
            check.add(entity);
            List addStacks = OrgBatchValidateHelper.checkCollaborationCycle(check, (List)allEntity, (Date)effectdate, (List)entryentityDisable, (boolean)false, (DynamicObject[])effctiveData, (List)inProgressData, (Map)orgValidateParametersBean.getEffdtMap());
            this.showCycleErrMessage(addStacks, dataEntity, "", orgBoidToBillNo);
        }
    }

    public void showCycleErrMessage(List<Deque<CycleCheckBean>> addStacks, ExtendedDataEntity dataEntity, String prefix, Map<Long, String> orgBoidToBillNo) {
        for (Deque<CycleCheckBean> addStack : addStacks) {
            String disable;
            CycleCheckBean dynamicObject = addStack.peekFirst();
            switch (disable = dynamicObject.getDataSource()) {
                case "inProgress": {
                    disable = ResManager.loadKDString((String)"[%1$s]\u534f\u4f5c\u5173\u7cfb\u548c\u5728\u9014\u5355\u636e[%2$s]\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539", (String)"AdminOrgSingleValidate_06", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, prefix + disable, dynamicObject.getCoopType().getString("name"), orgBoidToBillNo.get(dynamicObject.getParent().getLong("id"))));
                    break;
                }
                case "currentBill": {
                    disable = ResManager.loadKDString((String)"[%s]\u534f\u4f5c\u5173\u7cfb\u548c\u672c\u5355\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539", (String)"AdminOrgSingleValidate_07", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, prefix + disable, dynamicObject.getCoopType().getString("name")));
                    break;
                }
                default: {
                    disable = ResManager.loadKDString((String)"[%s]\u534f\u4f5c\u5173\u7cfb\u548c\u5df2\u751f\u6548\u7684\u534f\u4f5c\u5173\u7cfb\u6784\u6210\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539", (String)"AdminOrgSingleValidate_08", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, prefix + disable, dynamicObject.getCoopType().getString("name")));
                }
            }
            StringBuilder printResult = new StringBuilder();
            while (!addStack.isEmpty()) {
                CycleCheckBean pop = addStack.pop();
                printResult.append(pop.toString()).append(System.lineSeparator());
            }
            LOGGER.info(MessageFormat.format("==Cycle validate showCycleErrMessage:{0}{1}", System.lineSeparator(), printResult));
        }
    }
}

