/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.opplugin.web.orgbatch.AdminorgBatchSaveValidator;

public class AdminorgBatchAddSaveOp
extends HRCoreBaseBillOp {
    private static final Log LOGGER = LogFactory.getLog(AdminorgBatchAddSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("mergesplitstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map variables = this.getOption().getVariables();
        if (!Boolean.parseBoolean((String)variables.get("isImport"))) {
            variables.put("changeType", EntryEntityEnum.addEntry.getChangeType());
            e.addValidator((AbstractValidator)new AdminorgBatchSaveValidator(variables));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long orgId;
        HRBaseServiceHelper helper;
        boolean exists;
        DynamicObject[] dataEntities = e.getDataEntities();
        String status = dataEntities[0].getString("mergesplitstatus");
        if (HRStringUtils.equals((String)"0", (String)status) && (exists = (helper = new HRBaseServiceHelper("haos_adminorgdetail")).isExists((Object)(orgId = dataEntities[0].getLong("adminorg.id"))))) {
            return;
        }
        int dataEntitiesLength = dataEntities.length;
        DynamicObject[] dynArr = new DynamicObject[dataEntitiesLength];
        ArrayList orgIdList = new ArrayList(dataEntitiesLength);
        AdminOrgChgBillSaveService billSaveService = AdminOrgChgBillSaveService.getInstance();
        billSaveService.infoCopyBoid(dataEntities, this.billEntityType.getName(), dynArr, orgIdList);
        this.logAddEstablishmentDate(Arrays.asList(dynArr));
        Map variables = this.getOption().getVariables();
        if (Boolean.parseBoolean((String)variables.get("isImport"))) {
            AdminOrgOpService.getInstance().batchSaveTemp(dynArr);
        } else {
            AdminOrgOpService.getInstance().saveTemporary(dynArr, Long.valueOf(0L));
        }
        if (Boolean.parseBoolean((String)variables.get("isImport"))) {
            AdminOrgBatchChgHelper.saveStructToEntry((DynamicObject[])dataEntities);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dynamicObject = dataEntities[0];
        long orgid = 0L;
        Object obj = dynamicObject.get("adminorg");
        if (obj instanceof DynamicObject) {
            orgid = ((DynamicObject)obj).getLong("id");
        } else if (obj instanceof Long) {
            orgid = (Long)obj;
        }
        if (orgid != 0L) {
            HRBaseServiceHelper adminorHepler = new HRBaseServiceHelper("haos_adminorgdetail");
            DynamicObject adminOrg = adminorHepler.queryOne("id,boid,parentorg", (Object)orgid);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
            DynamicObject orgEntry = serviceHelper.queryOne("adminorgboid", (Object)dynamicObject.getLong("id"));
            orgEntry.set("adminorgboid", (Object)adminOrg.getLong("parentorg.boid"));
            serviceHelper.updateOne(orgEntry);
        }
    }

    private void logAddEstablishmentDate(List<DynamicObject> dynamicObjectList) {
        String message = dynamicObjectList.stream().map(dy -> "[bsed:" + dy.getDate("bsed") + ", establishment date: " + dy.getDate("establishmentdate") + "]").collect(Collectors.joining(", ", "check_save_daylight_saving_time {", "}"));
        LOGGER.info(message);
    }
}

