/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.validcommon.OrgBatchBillCheckContext;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;

public class AdminorgBatchSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(AdminorgBatchSaveValidator.class);
    private OrgBatchCheckCacheModel cacheModel = new OrgBatchCheckCacheModel();

    public AdminorgBatchSaveValidator(Map<String, String> variables) {
        this.cacheModel.setOperateType(1);
        this.cacheModel.setCheckType("billSingle");
        this.cacheModel.setChangeType(variables.get("changeType"));
        this.cacheModel.setCurrentBillId(Long.valueOf(Long.parseLong(variables.get("billId"))));
        String effectDate = variables.get("effdt");
        if (HRStringUtils.isEmpty((String)effectDate)) {
            this.cacheModel.setEffectDate(new Date());
        } else {
            try {
                this.cacheModel.setEffectDate(HRDateTimeUtils.parseDate((String)effectDate, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (ParseException ex) {
                this.cacheModel.setEffectDate(new Date());
                LOGGER.error("parseDate exception\uff1a", (Throwable)ex);
            }
        }
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject checkObject = dataEntity.getDataEntity();
            OrgBatchBillCheckContext context = new OrgBatchBillCheckContext(checkObject, this.cacheModel);
            List beanList = context.handle();
            if (CollectionUtils.isEmpty((Collection)beanList)) continue;
            beanList.forEach(bean -> this.addErrorMessage(dataEntity, bean.getMessage("odc-homs-business")));
        }
    }
}

