/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.opplugin.web.orgbatch.AdminorgChartSaveValidator;

public class AdminorgChartParentListSaveOp
extends HRCoreBaseBillOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map variables = this.getOption().getVariables();
        String entryKey = (String)variables.get("entryKey");
        OrgBatchCheckCacheModel cacheModel = (OrgBatchCheckCacheModel)SerializationUtils.fromJsonString((String)((String)variables.get("cacheModel")), OrgBatchCheckCacheModel.class);
        cacheModel.setChangeType(EntryEntityEnum.parentEntry.getChangeType());
        cacheModel.setCheckType("billChartParent");
        e.addValidator((AbstractValidator)new AdminorgChartSaveValidator(entryKey, cacheModel));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject parentChartDy : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection dynamicObjects = parentChartDy.getDynamicObjectCollection("entryentity");
            Long billId = ((DynamicObject)dynamicObjects.get(0)).getLong("billid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
            QFilter qFilter = new QFilter("billid", "=", (Object)billId);
            qFilter.and(new QFilter("changetype", "=", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_ADD));
            DynamicObject[] oldDys = serviceHelper.query("id,adminorg,number,name,parentorg,simplename,adminorgtype,establishmentdate,corporateorg,tobedisableflag,changescene,changereason,changedescription,adminorglayer,adminorgfunction,companyarea,city,workplace,index,safelevel,safetype", qFilter.toArray());
            DynamicObjectCollection entityCollection = new DynamicObjectCollection();
            Map<Long, DynamicObject> map = dynamicObjects.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
            for (DynamicObject oldDy : oldDys) {
                if (!map.containsKey(oldDy.getLong("id"))) continue;
                DynamicObject newDy = map.get(oldDy.getLong("id"));
                oldDy.set("adminorg", newDy.get("adminorg"));
                oldDy.set("number", newDy.get("number"));
                oldDy.set("name", newDy.get("name"));
                oldDy.set("parentorg", newDy.get("parentorg"));
                oldDy.set("simplename", newDy.get("simplename"));
                oldDy.set("adminorgtype", newDy.get("adminorgtype"));
                oldDy.set("establishmentdate", newDy.get("establishmentdate"));
                oldDy.set("corporateorg", newDy.get("corporateorg"));
                oldDy.set("tobedisableflag", newDy.get("tobedisableflag"));
                oldDy.set("changescene", newDy.get("changescene"));
                oldDy.set("changereason", newDy.get("changereason"));
                oldDy.set("changedescription", newDy.get("changedescription"));
                oldDy.set("adminorglayer", newDy.get("adminorglayer"));
                oldDy.set("adminorgfunction", newDy.get("adminorgfunction"));
                oldDy.set("companyarea", newDy.get("companyarea"));
                oldDy.set("city", newDy.get("city"));
                oldDy.set("workplace", newDy.get("workplace"));
                oldDy.set("index", newDy.get("index"));
                oldDy.set("safelevel", newDy.get("safelevel"));
                oldDy.set("safetype", newDy.get("safetype"));
                entityCollection.add((Object)oldDy);
            }
            if (entityCollection.size() <= 0) continue;
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
            DynamicObject[] dyArr = new DynamicObject[entityCollection.size()];
            for (int i = 0; i < entityCollection.size(); ++i) {
                dyArr[i] = (DynamicObject)entityCollection.get(i);
            }
            hrBaseServiceHelper.update(dyArr);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject parentChartDy : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection dynamicObjects = parentChartDy.getDynamicObjectCollection("entryentity");
            Long billId = ((DynamicObject)dynamicObjects.get(0)).getLong("billid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
            QFilter qFilter = new QFilter("billid", "=", (Object)billId);
            qFilter.and(new QFilter("changetype", "=", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_ADD));
            ArrayList orgIds = new ArrayList();
            dynamicObjects.stream().filter(dynamicObject -> dynamicObject.getLong("changetype.id") == OrgBatchChgBillConstants.CHANGE_TYPE_ADD.longValue()).forEach(dynamicObject -> orgIds.add(dynamicObject.getLong("adminorg.id")));
            if (CollectionUtils.isEmpty(orgIds)) {
                return;
            }
            qFilter.and(new QFilter("adminorg", "in", orgIds));
            Date bsed = parentChartDy.getDate("bsed") == null ? new Date() : parentChartDy.getDate("bsed");
            this.saveAddToMaster(qFilter.toArray(), bsed);
        }
    }

    private void saveAddToMaster(QFilter[] filters, Date bsed) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        DynamicObject[] dynAddArr = hrBaseServiceHelper.loadDynamicObjectArray(filters);
        int dataEntitiesLength = dynAddArr.length;
        DynamicObject[] dynMasterArr = new DynamicObject[dataEntitiesLength];
        ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntitiesLength);
        this.infoCopyBoid(dynAddArr, orgIdList, dynMasterArr, bsed);
        AdminOrgOpService.getInstance().saveTemporary(dynMasterArr, Long.valueOf(0L));
    }

    public void infoCopyBoid(DynamicObject[] dynAddArr, List<Long> orgIdList, DynamicObject[] dynMasterArr, Date bsed) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        HashMap<Long, Long> parentIdMap = new HashMap<Long, Long>(dynAddArr.length * 2);
        for (int i = 0; i < dynAddArr.length; ++i) {
            DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
            DynamicObject dyn = dynAddArr[i];
            dyn.set("bsed", (Object)bsed);
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)emptyDynamicObject);
            long orgId = dyn.getLong("orgid");
            if (orgId == 0L) {
                orgId = dyn.getLong("adminorg.boid");
            }
            orgIdList.add(orgId);
            emptyDynamicObject.set("id", (Object)orgId);
            emptyDynamicObject.set("boid", (Object)orgId);
            dynMasterArr[i] = emptyDynamicObject;
            dyn.set("adminorg", (Object)orgId);
            parentIdMap.put(orgId, dyn.getLong("parentorg.boid"));
        }
        Map parents = AdminOrgHisServiceHelper.getEntityInfoByOrgId((List)Lists.newArrayList(parentIdMap.values()), (String)AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), (String)"boid");
        for (DynamicObject dyn : dynMasterArr) {
            long id = dyn.getLong("id");
            Long parentId = (Long)parentIdMap.get(id);
            if (!parents.containsKey(parentId)) continue;
            dyn.set("parentorg", parents.get(parentId));
        }
    }
}

