/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgbatch;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchBillCheckContext;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckCacheModel;

public class OrgBatchBillSaveAndSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(OrgBatchBillSaveAndSubmitValidator.class);
    private String operateKey;

    public OrgBatchBillSaveAndSubmitValidator() {
    }

    public OrgBatchBillSaveAndSubmitValidator(String operateKey) {
        this.operateKey = operateKey;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        long startTime = System.currentTimeMillis();
        ValidateResultCollection validateResultCollection = this.getValidateContext().getValidateResults();
        if (validateResultCollection != null && !CollectionUtils.isEmpty((Collection)validateResultCollection.getValidateErrors()) && !CollectionUtils.isEmpty((Collection)((ValidateResult)validateResultCollection.getValidateErrors().get(0)).getAllErrorInfo())) {
            return;
        }
        OrgBatchCheckCacheModel cacheModel = new OrgBatchCheckCacheModel();
        cacheModel.setOperateType(2);
        cacheModel.setCheckType("billBatch");
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject checkObject = dataEntity.getDataEntity();
            String message = this.showMessageBeforeCheck(checkObject);
            if (HRStringUtils.isEmpty((String)message)) {
                cacheModel.setCurrentBillId(Long.valueOf(checkObject.getLong("id")));
                cacheModel.setEffectDate(checkObject.getDate("effdt"));
                OrgBatchBillCheckContext context = new OrgBatchBillCheckContext(checkObject, cacheModel);
                List beanList = context.handle();
                if (CollectionUtils.isEmpty((Collection)beanList)) continue;
                beanList.forEach(bean -> this.addErrorMessage(dataEntity, bean.getMessage("odc-homs-business")));
                continue;
            }
            this.addErrorMessage(dataEntity, message);
        }
        logger.info(String.format(Locale.ROOT, "OrgBatchBillSaveAndSubmitValidator() time cost is: %s", System.currentTimeMillis() - startTime));
    }

    private String showMessageBeforeCheck(DynamicObject checkObject) {
        String message = null;
        boolean isChange = this.isChange(checkObject);
        switch (this.operateKey = HRStringUtils.isEmpty((String)this.operateKey) ? this.getOperateKey() : this.operateKey) {
            case "save": {
                if (isChange) break;
                message = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u7ec4\u7ec7\u8c03\u6574\u201d\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u201c\u4fdd\u5b58\u201d\u3002", (String)"OrgBatchBillSaveAndSubmitValidator_04", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                break;
            }
            case "submit": {
                break;
            }
            case "donothing_submit": {
                if (!this.getIsHasWorkFlow()) {
                    message = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u6ca1\u6709\u53ef\u7528\u7684\u5de5\u4f5c\u6d41\uff0c\u8bf7\u4fdd\u5b58\u5355\u636e\u540e\u524d\u5f80\u201c\u6d41\u7a0b\u670d\u52a1\u4e91>\u5de5\u4f5c\u6d41\u670d\u52a1>\u8bbe\u8ba1\u4e2d\u5fc3>\u6d41\u7a0b\u8bbe\u8ba1\u201d\u4e2d\u65b0\u589e\u6216\u53d1\u5e03\u6d41\u7a0b\u3002", (String)"OrgBatchBillSaveAndSubmitValidator_02", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                }
            }
            case "wftask_save": {
                if (isChange) break;
                message = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u7ec4\u7ec7\u8c03\u6574\u201d\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u201c\u63d0\u4ea4\u201d\u3002", (String)"OrgBatchBillSaveAndSubmitValidator_01", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                break;
            }
            case "donothing_submiteffect": {
                if (isChange) break;
                message = ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u7ec4\u7ec7\u8c03\u6574\u201d\u7684\u6570\u636e\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u64cd\u4f5c\u201c\u63d0\u4ea4\u5e76\u751f\u6548\u201d\u3002", (String)"OrgBatchBillSaveAndSubmitValidator_03", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        return message;
    }

    private boolean getIsHasWorkFlow() {
        String entityNumber = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        HRBaseServiceHelper wfHelper = new HRBaseServiceHelper("wf_model");
        QFilter qFilter = new QFilter("entrabill", "=", (Object)entityNumber);
        qFilter.and("publish", "=", (Object)Character.valueOf('1')).and("discard", "=", (Object)Character.valueOf('0'));
        return wfHelper.isExists(qFilter);
    }

    private boolean isChange(DynamicObject checkObject) {
        List entryKeys = EntryEntityEnum.getEntryKeysWithExt();
        logger.info("isChange entryKeys:{}", (Object)JSONObject.toJSONString((Object)entryKeys));
        for (String entryKey : entryKeys) {
            DynamicObjectCollection entryColl = checkObject.getDynamicObjectCollection(entryKey);
            if (CollectionUtils.isEmpty((Collection)entryColl)) continue;
            return true;
        }
        return false;
    }
}

