/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgchart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgChartCardStyleDisableValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String operationName = "";
        if ("delete".equals(this.getOperateKey())) {
            operationName = ResManager.loadKDString((String)"\u5220\u9664", (String)"OrgChartCardStyleDisableValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]);
        } else if ("disable".equals(this.getOperateKey())) {
            operationName = ResManager.loadKDString((String)"\u7981\u7528", (String)"OrgChartCardStyleDisableValidator_3", (String)"odc-homs-opplugin", (Object[])new Object[0]);
        }
        this.validateCardStyleDisable(dataEntities, operationName);
        this.validateIssyspreset(dataEntities, operationName);
    }

    private void validateIssyspreset(ExtendedDataEntity[] dataEntities, String operationName) {
        QFilter issyspresetFilter;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardstyle");
        List cardids = Arrays.stream(dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", cardids);
        DynamicObject[] dynamicObjects = helper.queryOriginalArray("issyspreset, number, id", idFilter.and(issyspresetFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'))).toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        List collect = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy2 = dataEntity.getDataEntity();
            long id = dy2.getLong("id");
            if (!collect.contains(id)) continue;
            String message = ResManager.loadKDString((String)"\u8be5\u5361\u7247\u6837\u5f0f\u4e3a\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"OrgChartCardStyleDisableValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[]{operationName});
            this.addFatalErrorMessage(dataEntity, message);
        }
    }

    private void validateCardStyleDisable(ExtendedDataEntity[] dataEntities, String operationName) {
        List<Long> cardids = Arrays.stream(dataEntities).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select fcardstyleid from t_homs_chartstyleentry where fcardstyleid in (");
        cardids.forEach(cardstyleid -> selectSql.append('?').append(','));
        selectSql.deleteCharAt(selectSql.length() - 1);
        selectSql.append(')');
        DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_chartstyleentry", (DBRoute)new DBRoute("haos"), (String)selectSql.toString(), (Object[])cardids.toArray(new Long[0]));
        Iterator iterator = rs.iterator();
        ArrayList<Long> usingCards = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long cardstyleid2 = row.getLong("fcardstyleid");
            usingCards.add(cardstyleid2);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject cardStyle = dataEntity.getDataEntity();
            if (!usingCards.contains(cardStyle.getLong("id"))) continue;
            String message = ResManager.loadKDString((String)"\u8be5\u5361\u7247\u6837\u5f0f\u5df2\u88ab\u7ed3\u6784\u56fe\u6837\u5f0f\u5f15\u7528\uff0c\u4e0d\u80fd\u201c%s\u201d\u3002", (String)"OrgChartCardStyleDisableValidator_0", (String)"odc-homs-opplugin", (Object[])new Object[]{operationName});
            this.addFatalErrorMessage(dataEntity, message);
        }
    }
}

