/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgchart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgChartCardStyleNumberValidator
extends HRDataBaseValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"enable", (String)operateKey)) {
            HashMap<String, List> map = new HashMap<String, List>(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                if ("1".equals(dataEntity.getDataEntity().getString("enable"))) continue;
                String number2 = dataEntity.getDataEntity().getString("number");
                List list2 = map.getOrDefault(number2, new ArrayList());
                list2.add(dataEntity);
                map.put(number2, list2);
            }
            map.forEach((number, list) -> {
                if (list.size() > 1) {
                    list.forEach(dataEntity -> {
                        String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartCardStyleValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, String.format(Locale.ROOT, errorMsg, number));
                    });
                } else {
                    this.validateNumberUnique((ExtendedDataEntity)list.get(0));
                }
            });
        }
    }

    private void validateNumberUnique(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardstyle");
        QFilter numberFilter = new QFilter("number", "=", (Object)dy.getString("number"));
        long id = dy.getLong("id");
        DynamicObject[] querys = helper.query("number,id, carddimension.id, enable", numberFilter.toArray());
        if (querys != null && querys.length > 0) {
            Map<Long, List<DynamicObject>> cardMap = Arrays.stream(querys).collect(Collectors.groupingBy(card -> card.getLong("carddimension.id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : cardMap.entrySet()) {
                List<DynamicObject> cards = entry.getValue();
                Optional<DynamicObject> current = cards.stream().filter(card -> card.getLong("id") == id).findAny();
                if (!current.isPresent() || !cards.stream().filter(card -> "1".equals(card.getString("enable")) && card.getLong("id") != id).findAny().isPresent()) continue;
                String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartCardStyleValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, dy.getString("number")));
                break;
            }
        }
    }
}

