/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgchart;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgChartCardStyleValidator
extends HRDataBaseValidator {
    private static final char[] SPECIAL_SEPARATORS = new char[]{'!', '_', '/', '\\'};
    private static final Pattern SPECIAL_SEPARATORS_REGEX;

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.validateCardStyle(dataEntities);
    }

    private void validateCardStyle(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection orgentryentity = dataEntity.getDataEntity().getDynamicObjectCollection("orgentryentity");
            DynamicObjectCollection cardentryentity = dataEntity.getDataEntity().getDynamicObjectCollection("cardentryentity");
            this.validateOrgentryentity(orgentryentity, dataEntity);
            this.validateCardentryentity(cardentryentity, dataEntity);
            this.validateCardNameEffective(dataEntity);
            this.validateNumberUnique(dataEntity);
        }
    }

    private void validateNumberUnique(ExtendedDataEntity dataEntity) {
        QFilter idFilter;
        QFilter numberFilter;
        QFilter enableFilter;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardstyle");
        DynamicObject dy = dataEntity.getDataEntity();
        long carddimension = dy.getLong("carddimension.id");
        QFilter carddimensionFilter = new QFilter("carddimension", "=", (Object)carddimension);
        DynamicObject[] querys = helper.query("number,id", new QFilter[]{carddimensionFilter, enableFilter = new QFilter("enable", "=", (Object)"1"), numberFilter = new QFilter("number", "=", (Object)dy.getString("number")), idFilter = new QFilter("id", "!=", (Object)dy.getLong("id"))});
        if (querys != null && querys.length > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartCardStyleValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, dy.getString("number")));
        }
    }

    private void validateCardNameEffective(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        String localeValue = dy.getString("name");
        if (HRStringUtils.isNotEmpty((String)localeValue)) {
            Matcher matcher = SPECIAL_SEPARATORS_REGEX.matcher(localeValue);
            if (matcher.find()) {
                String message = ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartCardStyleValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(dataEntity, message);
            }
            String name = dy.getString("name");
            QFilter fieldFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("name", "=", (Object)name));
            fieldFilter.and(new QFilter("carddimension", "=", (Object)dy.getLong("carddimension.id")));
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardstyle");
            DynamicObject objColl = helper.queryOne("id,name", new QFilter[]{fieldFilter});
            if (objColl != null && dy.getLong("id") != objColl.getLong("id")) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u5361\u7247\u7ef4\u5ea6\u4e0b\uff0c\u5361\u7247\u6837\u5f0f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"OrgChartCardStyleValidator_3", (String)"odc-homs-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateCardentryentity(DynamicObjectCollection cardentryentity, ExtendedDataEntity dataEntity) {
        if (cardentryentity.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5361\u7247\u6837\u5f0f\u3002", (String)"OrgChartCardStyleValidator_0", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, message);
        }
    }

    private void validateOrgentryentity(DynamicObjectCollection orgentryentity, ExtendedDataEntity dataEntity) {
        if (orgentryentity.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"OrgChartCardStyleValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, message);
        }
    }

    static {
        StringBuilder stringBuffer = new StringBuilder();
        for (int i = 0; i < SPECIAL_SEPARATORS.length; ++i) {
            stringBuffer.append('\\').append(SPECIAL_SEPARATORS[i]).append('+');
            if (i >= SPECIAL_SEPARATORS.length - 1) continue;
            stringBuffer.append('|');
        }
        SPECIAL_SEPARATORS_REGEX = Pattern.compile(stringBuffer.toString());
    }
}

