/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgchart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class OrgChartStyleCheckValidator
extends HRDataBaseValidator {
    private static final String SPECIAL_REGEX = "[!_/\\\\\uff01]";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) || HRStringUtils.equals((String)"enable", (String)operateKey)) {
            this.saveAndEnableValidate(operateKey);
            this.checkNumber();
        }
    }

    private void checkNumber() {
        List ids = Arrays.stream(this.dataEntities).map(dy -> dy.getDataEntity().getLong("id")).collect(Collectors.toList());
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        if (!ids.isEmpty()) {
            enableQFilter.and(new QFilter("id", "not in", ids));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_chartstyle");
        DynamicObject[] numbers = helper.query("number", enableQFilter.toArray());
        Map numberMap = Arrays.stream(numbers).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (oldVal, newVal) -> oldVal));
        HashMap<String, List> map = new HashMap<String, List>();
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            String number2 = extendedDataEntity.getDataEntity().getString("number");
            if (numberMap.containsKey(number2)) {
                String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartCardStyleValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, String.format(Locale.ROOT, errorMsg, number2));
            }
            if (!"enable".equals(this.getOperateKey())) continue;
            List list2 = map.getOrDefault(number2, new ArrayList(8));
            list2.add(extendedDataEntity);
            map.put(number2, list2);
        }
        if ("enable".equals(this.getOperateKey())) {
            map.forEach((number, list) -> {
                if (list.size() > 1) {
                    list.forEach(ex -> {
                        String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartCardStyleValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage((ExtendedDataEntity)ex, String.format(Locale.ROOT, errorMsg, number));
                    });
                }
            });
        }
    }

    private void saveAndEnableValidate(String operateKey) {
        List nameList = Arrays.asList(this.dataEntities).stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getDataEntity().getString("name"))).map(item -> item.getDataEntity().getString("name")).collect(Collectors.toList());
        Map<String, List<String>> nameMapList = nameList.stream().collect(Collectors.groupingBy(item -> item));
        QFilter fieldFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("name", "in", nameList));
        if (HRStringUtils.equals((String)"homs_position_chartstyle", (String)this.entityKey)) {
            fieldFilter.and(new QFilter("carddimensionid", "=", (Object)Long.parseLong("1110")));
        } else {
            fieldFilter.and(new QFilter("carddimensionid", "!=", (Object)Long.parseLong("1110")));
        }
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)this.entityKey, (String)"id,name,carddimensionid", (QFilter[])new QFilter[]{fieldFilter});
        String errorMsg = HRStringUtils.equals((String)"enable", (String)operateKey) ? ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u540d\u79f0\u4e0e\u73b0\u6709\u6570\u636e\u91cd\u590d\u3002", (String)"OrgChartStyleCheckValidator_0", (String)"odc-homs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartStyleCheckValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[0]);
        Map<String, DynamicObject> nameMap = objColl != null && objColl.size() > 0 ? objColl.stream().collect(Collectors.toMap(item -> item.getString("name"), item -> item, (v1, v2) -> v1)) : new HashMap<String, DynamicObject>();
        this.checkName(operateKey, nameMapList, nameMap, errorMsg);
    }

    private void checkName(String operateKey, Map<String, List<String>> nameMapList, Map<String, DynamicObject> nameMap, String errorMsg) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String name;
            DynamicObject obj = dataEntity.getDataEntity();
            String enable = obj.getString("enable");
            if (HRStringUtils.equals((String)"enable", (String)operateKey) && HRStringUtils.equals((String)enable, (String)"1") || !HRStringUtils.isNotEmpty((String)(name = obj.getString("name")))) continue;
            long id = obj.getLong("id");
            DynamicObject dynamicObject = nameMap.get(name);
            if (dynamicObject != null && id != dynamicObject.getLong("id") || nameMapList.get(name).size() > 1) {
                this.addFatalErrorMessage(dataEntity, errorMsg);
                continue;
            }
            Pattern pattern = Pattern.compile(SPECIAL_REGEX);
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            String message = ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26(!_/\\)\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgChartStyleCheckValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
    }
}

