/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgdifftemp;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.orgdifftemp.SynHrEffectController;
import kd.hr.homs.business.service.orgdifftemp.SynPlatform2HrHelper;
import kd.hr.homs.opplugin.web.orgdifftemp.validate.OrgDiffTempEnableValidator;

public class OrgDiffTempEnableOp
extends HRCoreBaseBillOp {
    private SynHrEffectController synHrEffectController;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrgDiffTempEnableValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("enable", "establishmentdate", "adminorgtype", "parentorg", "tobedisableflag", "tobedisabledate", "org"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Set idSet = Arrays.stream(dataEntities).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] tOrgDys = SynPlatform2HrHelper.loadTempOrgById(idSet);
        DynamicObject userDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        userDy.set("id", (Object)RequestContext.get().getCurrUserId());
        DynamicObject billDy = BusinessDataServiceHelper.newDynamicObject((String)"homs_orgbatchchgbill");
        billDy.set("billtype", (Object)"3");
        billDy.set("creator", (Object)userDy);
        billDy.set("effdt", (Object)Date.from(ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).toInstant()));
        DynamicObject[] entityDys = SynPlatform2HrHelper.buildEntityAndInsertAdminOrg(idSet, (DynamicObject[])tOrgDys);
        this.synHrEffectController = SynHrEffectController.createSynHrEffectController((DynamicObject)billDy, (DynamicObject[])entityDys);
        Map sceneSubMap = new ChangeSceneSubService().getSceneSubId(Arrays.asList(entityDys));
        this.synHrEffectController.syn();
        AdminChgDetailService adminChgDetailService = new AdminChgDetailService();
        adminChgDetailService.saveAdminOrgChgDetail(billDy, entityDys);
        SynPlatform2HrHelper.updateTmp(idSet, (DynamicObject[])tOrgDys);
        TransactionModelService transactionService = new TransactionModelService();
        transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(this.synHrEffectController.getEventId()), false, entityDys, sceneSubMap);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.synHrEffectController.afterSyn();
    }
}

