/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgdifftemp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.orgdifftemp.SynPlatform2HrHelper;
import kd.hr.homs.business.service.orgdifftemp.bean.OrgTempBean;
import kd.hr.homs.common.constants.orgdifftemp.OrgDiffTempConstants;
import kd.hr.homs.opplugin.web.orgdifftemp.validate.OrgDiffTempSaveValidator;

public class OrgDiffTempSaveOp
extends HRCoreBaseBillOp
implements OrgDiffTempConstants {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new OrgDiffTempSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("status", "enable", "parent", "ischange", "org", "adminorgtype", "corporateorg", "adminorglayer", "adminorgfunction", "companytype", "departmenttype", "safelevel", "safetype", "workplace"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList orgTempList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        Map<Long, Long> id4OldParentIdMap = this.getId4OldParentIdMap(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            this.setCompanyArea(dataEntity);
            dataEntity.set("ischange", (Object)"1");
            this.assembleOrgTempList(orgTempList, id4OldParentIdMap, dataEntity);
        }
        DynamicObject[] structArrays = SynPlatform2HrHelper.getChangedStructs((List)orgTempList);
        if (structArrays != null && structArrays.length > 0) {
            SaveServiceHelper.update((DynamicObject[])structArrays);
        }
    }

    private void assembleOrgTempList(List<OrgTempBean> orgTempList, Map<Long, Long> id4OldParentIdMap, DynamicObject dataEntity) {
        long id = dataEntity.getLong("id");
        Long oldParentOrgId = id4OldParentIdMap.get(id);
        long curParentOrgId = dataEntity.getLong("parentorg.id");
        OrgTempBean orgTempBean = new OrgTempBean(Long.valueOf(id), oldParentOrgId, Long.valueOf(curParentOrgId));
        orgTempList.add(orgTempBean);
    }

    private Map<Long, Long> getId4OldParentIdMap(DynamicObject[] dataEntities) {
        Set idSet = Arrays.stream(dataEntities).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper orgDiffTempHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        QFilter idFilter = new QFilter("id", "in", idSet);
        DynamicObject[] orgDiffTempDyns = orgDiffTempHelper.query("id, parentorg", new QFilter[]{idFilter});
        Map<Long, Long> id4OldParentIdMap = Arrays.stream(orgDiffTempDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("parentorg.id")));
        return id4OldParentIdMap;
    }

    private void setCompanyArea(DynamicObject dataEntity) {
        DynamicObject cityDyn = dataEntity.getDynamicObject("city");
        if (Objects.nonNull(cityDyn)) {
            long countryId = cityDyn.getLong("country.id");
            dataEntity.set("companyarea", (Object)countryId);
        }
    }
}

