/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgdifftemp.validate;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgdifftemp.OrgDiffTempHelper;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.common.constants.orgdifftemp.OrgDiffTempConstants;
import kd.hr.homs.common.enums.OrgDiffTempRequiredEnum;

public class OrgDiffTempEnableValidator
extends AbstractValidator
implements OrgDiffTempConstants {
    private final List<String> requiredFieldsList = Arrays.asList("number", "name", "establishmentdate", "adminorgtype", "parentorg");
    private Map<Long, String> id4FailureReasonMap = Maps.newHashMapWithExpectedSize((int)16);

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        Set parentOrgIdSet = Arrays.stream(extendedDataEntities).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg"))).map(ex -> ex.getDataEntity().getLong("parentorg.id")).collect(Collectors.toSet());
        Set parentOrgExistFromMasterIdSet = OrgDiffTempHelper.getParentOrgExistFromMasterIdSet(parentOrgIdSet);
        Map parentId4NameListFromApplyingMap = OrgDiffTempHelper.getParentId4NameListFromApplyingMap((Set)parentOrgExistFromMasterIdSet);
        Map parentBoId4AdminOrgFromMasterListMap = OrgDiffTempHelper.getParentBoId4AdminOrgFromMasterListMap((ExtendedDataEntity[])extendedDataEntities, parentOrgIdSet);
        Map parentId4NameFromCurListMap = OrgDiffTempHelper.getParentId4NameListFromCurMap((ExtendedDataEntity[])extendedDataEntities, parentOrgIdSet);
        Map id4ParentOrgTypeStdIdMap = OrgDiffTempHelper.getId4ParentOrgTypeStdIdMap((ExtendedDataEntity[])extendedDataEntities);
        Map id4OrgTypeStdIdFromMasterMap = OrgDiffTempHelper.getId4ParentOrgTypeStdIdFromMasterMap((ExtendedDataEntity[])extendedDataEntities);
        Set<Long> disableParentOrgIdSet = this.getDisableParentOrgIdSet(extendedDataEntities);
        Set<Long> applyingParentOrgIdSet = this.getApplyingParentOrgIdSet(extendedDataEntities);
        Map orgIdNodesMap = OrgDiffTempHelper.getOrgId4NodesMap((ExtendedDataEntity[])extendedDataEntities);
        HasPermOrgResult hasHrOrgResult = OrgPermHelper.getHRPermOrg((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_orgdifftemp", (String)"47150e89000000ac");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            boolean isPass;
            this.isHasPermHrOrg(hasHrOrgResult, extendedDataEntity, extendedDataEntity.getDataEntity());
            boolean bl = isPass = this.enableCheck(extendedDataEntity) && this.requiredCheck(extendedDataEntity);
            if (!isPass) continue;
            this.repeatNameCheck(extendedDataEntity, parentOrgExistFromMasterIdSet, parentId4NameListFromApplyingMap, parentBoId4AdminOrgFromMasterListMap, parentId4NameFromCurListMap);
            this.orgLevel4ModelCheck(extendedDataEntity, id4ParentOrgTypeStdIdMap, id4OrgTypeStdIdFromMasterMap);
            this.toBeDisableCheck(extendedDataEntity);
            this.parentOrgCheck(extendedDataEntity, disableParentOrgIdSet, applyingParentOrgIdSet);
            this.cycleCheck(extendedDataEntity, orgIdNodesMap);
        }
        this.parentIsEnabledCheck(extendedDataEntities);
        this.writeFailReasion();
    }

    private void isHasPermHrOrg(HasPermOrgResult hasHrOrgResult, ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        List permOrgs;
        long orgId = dataEntity.getLong("org.id");
        if (!hasHrOrgResult.hasAllOrgPerm() && !(permOrgs = hasHrOrgResult.getHasPermOrgs()).contains(orgId)) {
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u7684\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgDiffTempEnableValidator_15", (String)"odc-homs-opplugin", (Object[])new Object[0]), dataEntity.getString("name")));
        }
    }

    private void repeatNameCheck(ExtendedDataEntity extendedDataEntity, Set<Long> parentOrgExistFromMasterIdSet, Map<Long, List<String>> parentId4NameListFromApplyingMap, Map<Long, List<DynamicObject>> parentBoId4AdminOrgFromMasterListMap, Map<Long, List<String>> parentId4NameFromCurListMap) {
        boolean isRepeat;
        List<String> nameList;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        DynamicObject parentOrgDyn = dataEntity.getDynamicObject("parentorg");
        Date establishmentDate = dataEntity.getDate("establishmentdate");
        if (Objects.isNull(parentOrgDyn) || Objects.isNull(establishmentDate)) {
            return;
        }
        long parentOrgId = parentOrgDyn.getLong("id");
        String name = dataEntity.getString("name");
        if (PatternUtil.valideName((String)name)) {
            String content = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_01", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
        if (parentOrgExistFromMasterIdSet.contains(parentOrgId)) {
            List<DynamicObject> adminOrgList;
            nameList = parentId4NameListFromApplyingMap.get(parentOrgId);
            if (!CollectionUtils.isEmpty(nameList) && nameList.contains(name)) {
                String content = ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\u4e2d\uff0c\u540c\u4e00\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5b58\u5728\u540c\u540d\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_02", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.appendFailReason(id, content);
                this.addErrorMessage(extendedDataEntity, content);
            }
            if (!CollectionUtils.isEmpty(adminOrgList = parentBoId4AdminOrgFromMasterListMap.get(parentOrgId))) {
                for (DynamicObject adminOrg : adminOrgList) {
                    Date bsled = adminOrg.getDate("bsled");
                    if (!bsled.after(establishmentDate)) continue;
                    String content = ResManager.loadKDString((String)"\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u4e2d\u5df2\u5b58\u5728\u540c\u540d\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_03", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                    this.appendFailReason(id, content);
                    this.addErrorMessage(extendedDataEntity, content);
                }
            }
        }
        boolean bl = isRepeat = !CollectionUtils.isEmpty(nameList = parentId4NameFromCurListMap.get(parentOrgId)) && nameList.contains(name);
        if (isRepeat) {
            String content = ResManager.loadKDString((String)"\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u4e2d\u5df2\u5b58\u5728\u540c\u540d\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_03", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
    }

    private void cycleCheck(ExtendedDataEntity extendedDataEntity, Map<Long, List<CycleOrgBean>> orgIdNodesMap) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        DynamicObject parentOrgDyn = dataEntity.getDynamicObject("parentorg");
        if (Objects.isNull(parentOrgDyn)) {
            return;
        }
        long parentId = parentOrgDyn.getLong("id");
        CycleOrgBean cycleOrgBean = OrgDiffTempHelper.assembleCurrentCycleOrg((Long)id, (Long)parentId);
        Deque cycleOrgBeans = OrgBatchBillCheckHelper.containsCycle((CycleOrgBean)cycleOrgBean, orgIdNodesMap, (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)cycleOrgBeans)) {
            String content = ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_04", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
    }

    private Set<Long> getApplyingParentOrgIdSet(ExtendedDataEntity[] extendedDataEntities) {
        Set parentOrgId = Arrays.stream(extendedDataEntities).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg"))).map(ex -> ex.getDataEntity().getLong("parentorg.id")).collect(Collectors.toSet());
        HRBaseServiceHelper orgBatchChgBillHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter auditStatusFilter = new QFilter("auditstatus", "in", Arrays.asList("B", "D"));
        DynamicObject[] orgBatchChgBillDyns = orgBatchChgBillHelper.query("id", new QFilter[]{auditStatusFilter});
        Set applyingBillIdSet = Arrays.stream(orgBatchChgBillDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper batchOrgEntityHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter applyingBillFilter = new QFilter("billid", "in", applyingBillIdSet);
        QFilter changeTypeFilter = new QFilter("changetype", "in", (Object)1040L);
        QFilter parentIdFilter = new QFilter("adminorg.boid", "in", parentOrgId);
        DynamicObject[] batchOrgEntityDyns = batchOrgEntityHelper.query("id, adminorg.boid", new QFilter[]{applyingBillFilter, parentIdFilter, changeTypeFilter});
        return Arrays.stream(batchOrgEntityDyns).map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toSet());
    }

    private Set<Long> getDisableParentOrgIdSet(ExtendedDataEntity[] extendedDataEntities) {
        Set parentOrgId = Arrays.stream(extendedDataEntities).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg"))).map(ex -> ex.getDataEntity().getLong("parentorg.id")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", parentOrgId);
        QFilter enableFilter = new QFilter("enable", "in", (Object)"0");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        DynamicObject[] disableParentOrgDyns = adminOrgDetailHelper.query("id", new QFilter[]{idFilter, enableFilter, isCurrentVersionFilter});
        Set<Long> disableParentOrgIdSet = Arrays.stream(disableParentOrgDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        return disableParentOrgIdSet;
    }

    private void parentOrgCheck(ExtendedDataEntity extendedDataEntity, Set<Long> disableParentOrgIdSet, Set<Long> applyingParentOrgIdSet) {
        long id = extendedDataEntity.getDataEntity().getLong("id");
        DynamicObject parentOrgDyn = extendedDataEntity.getDataEntity().getDynamicObject("parentorg");
        if (Objects.nonNull(parentOrgDyn)) {
            String content;
            long parentOrgId = parentOrgDyn.getLong("id");
            if (disableParentOrgIdSet.contains(parentOrgId)) {
                content = ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_05", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.appendFailReason(id, content);
                this.addErrorMessage(extendedDataEntity, content);
            }
            if (applyingParentOrgIdSet.contains(parentOrgId)) {
                content = ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u5728\u9014\u7981\u7528\u5355\u636e\u4e2d\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_06", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.appendFailReason(id, content);
                this.addErrorMessage(extendedDataEntity, content);
            }
        }
    }

    private void toBeDisableCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        boolean toBeDiableFlag = dataEntity.getBoolean("tobedisableflag");
        Date toBeDisableDate = dataEntity.getDate("tobedisabledate");
        if (toBeDiableFlag && Objects.isNull(toBeDisableDate)) {
            String content = ResManager.loadKDString((String)"\u662f\u5426\u5f85\u505c\u7528\u4e3a\u201c\u662f\u201d\uff0c\u5f85\u505c\u7528\u65e5\u671f\u5fc5\u586b\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_07", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        } else if (!toBeDiableFlag && Objects.nonNull(toBeDisableDate)) {
            String content = ResManager.loadKDString((String)"\u662f\u5426\u5f85\u505c\u7528\u4e3a\u201c\u5426\u201d\uff0c\u5f85\u505c\u7528\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_08", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
    }

    private void orgLevel4ModelCheck(ExtendedDataEntity extendedDataEntity, Map<Long, Long> id4ParentOrgTypeStdIdMap, Map<Long, Long> id4OrgTypeStdIdFromMasterMap) {
        Long parentOrgTypeStdId;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        String enable = dataEntity.getString("parentorg.enable");
        DynamicObject adminOrgTypeDyn = dataEntity.getDynamicObject("adminorgtype");
        long adminOrgTypeStdId = adminOrgTypeDyn.getLong("adminorgtypestd.id");
        if (HRStringUtils.equals((String)"0", (String)enable)) {
            parentOrgTypeStdId = id4ParentOrgTypeStdIdMap.get(id);
            if (parentOrgTypeStdId == null || parentOrgTypeStdId == 0L) {
                String content = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u672a\u586b\u5199\uff0c\u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_09", (String)"odc-homs-opplugin", (Object[])new Object[0]);
                this.appendFailReason(id, content);
                this.addErrorMessage(extendedDataEntity, content);
                return;
            }
        } else {
            long parentOrgId = dataEntity.getLong("parentorg.id");
            parentOrgTypeStdId = id4OrgTypeStdIdFromMasterMap.get(parentOrgId);
        }
        if (ADMINORG_TYPE_GROUP == adminOrgTypeStdId && !Arrays.asList(ADMINORG_TYPE_GROUP, ADMINORG_TYPE_AREA).contains(parentOrgTypeStdId)) {
            String content = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u96c6\u56e2\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u96c6\u56e2\u3001\u533a\u57df\uff0c \u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_10", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        } else if (ADMINORG_TYPE_CONPANEY == adminOrgTypeStdId && !Arrays.asList(ADMINORG_TYPE_GROUP, ADMINORG_TYPE_AREA, ADMINORG_TYPE_CONPANEY).contains(parentOrgTypeStdId)) {
            String content = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u516c\u53f8\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u96c6\u56e2\u3001\u533a\u57df\u3001\u516c\u53f8\uff0c \u8bf7\u4fee\u6539;", (String)"OrgDiffTempEnableValidator_11", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
    }

    private void writeFailReasion() {
        DynamicObject[] orgDiffTempDyns;
        HRBaseServiceHelper orgDiffTempHelper = new HRBaseServiceHelper("homs_orgdifftemp");
        Set<Long> idSet = this.id4FailureReasonMap.keySet();
        QFilter idFilter = new QFilter("id", "in", idSet);
        for (DynamicObject orgDiffTempDyn : orgDiffTempDyns = orgDiffTempHelper.loadDynamicObjectArray(new QFilter[]{idFilter})) {
            long id = orgDiffTempDyn.getLong("id");
            String content = this.id4FailureReasonMap.get(id);
            orgDiffTempDyn.set("changedescription", (Object)content);
        }
        orgDiffTempHelper.save(orgDiffTempDyns);
    }

    private boolean requiredCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        boolean isPass = true;
        StringBuilder errorField = new StringBuilder();
        for (IDataEntityProperty property : properties) {
            Object fieldValue;
            String fieldCode = property.getName();
            if (!this.requiredFieldsList.contains(fieldCode) || (!((fieldValue = dataEntity.get(fieldCode)) instanceof String) || !HRStringUtils.isEmpty((String)((String)fieldValue))) && !Objects.isNull(fieldValue)) continue;
            isPass = false;
            String fieldName = OrgDiffTempRequiredEnum.getFieldNameByFieldCode((String)fieldCode);
            errorField.append(fieldName).append(",");
        }
        if (errorField.length() > 0) {
            errorField.deleteCharAt(errorField.length() - 1);
            String content = String.format(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\uff1a%s;", (String)"OrgDiffTempEnableValidator_12", (String)"odc-homs-opplugin", (Object[])new Object[0]), errorField.toString());
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
        return isPass;
    }

    private void parentIsEnabledCheck(ExtendedDataEntity[] extendedDataEnties) {
        Set idSet = Arrays.stream(extendedDataEnties).map(ex -> ex.getDataEntity().getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper orgDiffStructHelper = new HRBaseServiceHelper("homs_orgdiffstruct");
        QFilter idFilter = new QFilter("adminorg", "in", idSet);
        DynamicObject[] orgDiffStructDyns = orgDiffStructHelper.query("id, adminorg, parentorg, level", new QFilter[]{idFilter}, "level asc");
        HashMap parentOrgId4EnableMap = Maps.newHashMapWithExpectedSize((int)orgDiffStructDyns.length);
        for (DynamicObject orgDiffStructDyn : orgDiffStructDyns) {
            if (!Objects.nonNull(orgDiffStructDyn.getDynamicObject("parentorg"))) continue;
            parentOrgId4EnableMap.put(orgDiffStructDyn.getLong("parentorg.id"), orgDiffStructDyn.getString("parentorg.enable"));
        }
        Map<Long, ExtendedDataEntity> id4ExtendedDataEntityMap = Arrays.stream(extendedDataEnties).collect(Collectors.toMap(ex -> ex.getDataEntity().getLong("id"), dyn -> dyn));
        for (DynamicObject orgDiffStructDyn : orgDiffStructDyns) {
            boolean flag;
            long adminOrgId = orgDiffStructDyn.getLong("adminorg.id");
            DynamicObject parentOrg = orgDiffStructDyn.getDynamicObject("parentorg");
            if (!Objects.nonNull(parentOrg)) continue;
            long parentOrgId = parentOrg.getLong("id");
            String enable = (String)parentOrgId4EnableMap.get(parentOrgId);
            boolean bl = flag = !idSet.contains(parentOrgId) || this.id4FailureReasonMap.containsKey(parentOrgId);
            if (!HRStringUtils.equals((String)enable, (String)"0") || !flag) continue;
            ExtendedDataEntity extendedDataEntity = id4ExtendedDataEntityMap.get(adminOrgId);
            String content = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u5148\u542f\u7528\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u3002", (String)"OrgDiffTempEnableValidator_13", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(adminOrgId, content);
            this.addErrorMessage(extendedDataEntity, content);
        }
    }

    private boolean enableCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        String enable = dataEntity.getString("enable");
        if (HRStringUtils.equals((String)enable, (String)"1")) {
            String content = ResManager.loadKDString((String)"\u6240\u9009\u884c\u653f\u7ec4\u7ec7\u5df2\u542f\u7528\uff0c\u65e0\u9700\u518d\u6b21\u542f\u7528\u3002", (String)"OrgDiffTempEnableValidator_14", (String)"odc-homs-opplugin", (Object[])new Object[0]);
            this.appendFailReason(id, content);
            this.addErrorMessage(extendedDataEntity, content);
            return false;
        }
        return true;
    }

    private void appendFailReason(Long id, String content) {
        String contentFromMap = this.id4FailureReasonMap.get(id);
        if (HRStringUtils.isEmpty((String)contentFromMap)) {
            this.id4FailureReasonMap.put(id, content);
        } else {
            contentFromMap = contentFromMap + content;
            this.id4FailureReasonMap.put(id, contentFromMap);
        }
    }
}

