/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgdifftemp.validate;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.util.tree.Tree;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.orgdifftemp.OrgDiffTempHelper;
import kd.hr.homs.business.service.utils.OrgDiffPermHelper;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.business.service.validcommon.CycleOrgBean;
import kd.hr.homs.common.constants.orgdifftemp.OrgDiffTempConstants;

public class OrgDiffTempSaveValidator
extends AbstractValidator
implements OrgDiffTempConstants {
    Set<Long> successPkIds;

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        this.successPkIds = Arrays.stream(extendedDataEntities).map(ex -> ex.getDataEntity().getLong("id")).collect(Collectors.toSet());
        Set parentOrgIdSet = Arrays.stream(extendedDataEntities).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg"))).map(ex -> ex.getDataEntity().getLong("parentorg.id")).collect(Collectors.toSet());
        Map<Long, ExtendedDataEntity> id4ExMap = Arrays.stream(extendedDataEntities).collect(Collectors.toMap(ex -> ex.getDataEntity().getLong("id"), ex -> ex));
        Set parentOrgExistFromMasterIdSet = OrgDiffTempHelper.getParentOrgExistFromMasterIdSet(parentOrgIdSet);
        Map parentId4NameListFromApplyingMap = OrgDiffTempHelper.getParentId4NameListFromApplyingMap((Set)parentOrgExistFromMasterIdSet);
        Map parentBoId4AdminOrgFromMasterListMap = OrgDiffTempHelper.getParentBoId4AdminOrgFromMasterListMap((ExtendedDataEntity[])extendedDataEntities, parentOrgIdSet);
        Map parentId4NameFromCurListMap = OrgDiffTempHelper.getParentId4NameListFromCurMap((ExtendedDataEntity[])extendedDataEntities, parentOrgIdSet);
        Map parentId4NameListFromTempMap = OrgDiffTempHelper.getParentId4NameListFromTempMap((ExtendedDataEntity[])extendedDataEntities);
        Map id4AdminOrgTypeStdIdMap = OrgDiffTempHelper.getId4AdminOrgTypeStdIdMap((ExtendedDataEntity[])extendedDataEntities);
        Map orgIdNodesMap = OrgDiffTempHelper.getOrgId4NodesMap((ExtendedDataEntity[])extendedDataEntities);
        Map<Long, Long> adminOrgId4StdIdMap = this.getAdminOrgId4StdIdMap(extendedDataEntities);
        List<Long> disableOrgIdList = this.getDisableOrgIdList();
        HasPermOrgResult hasPermOrg = OrgDiffPermHelper.getHasPermOrg();
        HasPermOrgResult hasHrOrgResult = OrgPermHelper.getHRPermOrg((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_orgdifftemp", (String)"47150e89000000ac");
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String status = dataEntity.getString("status");
            String enable = dataEntity.getString("enable");
            if (!this.isHasPermOrg(hasPermOrg, extendedDataEntity)) {
                return;
            }
            if (!this.isHasPermHrOrg(hasHrOrgResult, extendedDataEntity, dataEntity)) {
                return;
            }
            BASE_DATA_MAP.forEach((k, v) -> this.baseDataUseRange(extendedDataEntity, (String)k, (String)v));
            if ("E".equals(status)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u884c\u653f\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5", (String)"OrgDiffTempSaveValidator_01", (String)"odc-homs-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("1".equals(enable)) {
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s/%2$s\uff0c\u5728\u884c\u653f\u7ec4\u7ec7\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgDiffTempSaveValidator_02", (String)"odc-homs-opplugin", (Object[])new Object[0]), extendedDataEntity.getDataEntity().getString("number"), extendedDataEntity.getDataEntity().getString("name")));
                continue;
            }
            this.repeatNameCheck(extendedDataEntity, parentOrgExistFromMasterIdSet, parentId4NameListFromApplyingMap, parentBoId4AdminOrgFromMasterListMap, parentId4NameFromCurListMap, parentId4NameListFromTempMap);
            this.toBeDisableCheck(extendedDataEntity);
            this.parentOrgCheck(extendedDataEntity, disableOrgIdList);
            this.fieldFillInByOrgTypeCheck(extendedDataEntity);
            this.countryToCityCheck(extendedDataEntity);
            this.establishmentDateCheck(extendedDataEntity);
            this.indexCheck(extendedDataEntity);
            this.cycleCheck(extendedDataEntity, orgIdNodesMap);
        }
        this.orgLevel4ModelCheck(extendedDataEntities, id4ExMap, id4AdminOrgTypeStdIdMap, adminOrgId4StdIdMap);
    }

    private boolean isHasPermHrOrg(HasPermOrgResult hasHrOrgResult, ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        List permOrgs;
        long orgId = dataEntity.getLong("org.id");
        if (!hasHrOrgResult.hasAllOrgPerm() && !(permOrgs = hasHrOrgResult.getHasPermOrgs()).contains(orgId)) {
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_23", (String)"odc-homs-opplugin", (Object[])new Object[0]), dataEntity.getString("org.name")));
            return false;
        }
        return true;
    }

    private void baseDataUseRange(ExtendedDataEntity extendedDataEntity, String entityName, String fieldName) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject baseData = dataEntity.getDynamicObject(fieldName);
        if (baseData == null) {
            return;
        }
        long id = baseData.getLong("id");
        if (id == 0L) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        DynamicObject org = dataEntity.getDynamicObject("org");
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)org.getLong("id"));
        DynamicObject[] objects = helper.queryOriginalArray("id", filter == null ? new QFilter[]{} : filter.toArray());
        Set idSet = Arrays.stream(objects).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        if (!idSet.contains(id)) {
            String baseDataName = baseData.getDynamicObjectType().getDisplayName().getLocaleValue();
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"%1$s\uff1a%2$s\uff0c\u4e0d\u5728\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%s\u201d\u7684\u4f7f\u7528\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgDiffTempSaveValidator_24", (String)"odc-homs-opplugin", (Object[])new Object[]{baseDataName, baseData.getString("name"), org.getString("name")}));
        }
    }

    private List<Long> getDisableOrgIdList() {
        HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] adminOrgDetailDyns = adminOrgDetailHelper.query("id", new QFilter[]{enableFilter, isCurrentVersionFilter});
        List<Long> disableOrgIdList = Arrays.stream(adminOrgDetailDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        return disableOrgIdList;
    }

    private boolean isHasPermOrg(HasPermOrgResult hasPermOrg, ExtendedDataEntity extendedDataEntity) {
        if (hasPermOrg.hasAllOrgPerm()) {
            return true;
        }
        boolean flag = true;
        long id = extendedDataEntity.getDataEntity().getLong("id");
        long parentOrgId = extendedDataEntity.getDataEntity().getLong("parentorg.id");
        List hasPermOrgs = hasPermOrg.getHasPermOrgs();
        if (!hasPermOrgs.contains(id)) {
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_03", (String)"odc-homs-opplugin", (Object[])new Object[0]), extendedDataEntity.getDataEntity().getString("name")));
            flag = false;
        }
        if (!hasPermOrgs.contains(parentOrgId)) {
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_04", (String)"odc-homs-opplugin", (Object[])new Object[0]), extendedDataEntity.getDataEntity().getString("parentorg.name")));
            flag = false;
        }
        return flag;
    }

    private Map<Long, Long> getAdminOrgId4StdIdMap(ExtendedDataEntity[] extendedDataEntities) {
        Set adminrOrgTypeId = Arrays.stream(extendedDataEntities).filter(ex -> Objects.nonNull(ex.getDataEntity().getDynamicObject("parentorg.adminorgtype"))).map(ex -> ex.getDataEntity().getLong("parentorg.adminorgtype.id")).collect(Collectors.toSet());
        QFilter ifFilter = new QFilter("id", "in", adminrOrgTypeId);
        HRBaseServiceHelper adminOrgTypeHelper = new HRBaseServiceHelper("haos_adminorgtype");
        DynamicObject[] adminOrgTypeDyns = adminOrgTypeHelper.query("id, adminorgtypestd", new QFilter[]{ifFilter});
        return Arrays.stream(adminOrgTypeDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("adminorgtypestd.id")));
    }

    private void indexCheck(ExtendedDataEntity extendedDataEntity) {
        int index = extendedDataEntity.getDataEntity().getInt("index");
        if (index < 0 || index > 99999) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6392\u5e8f\u53f7\u53ea\u80fd\u586b\u51991-99999\u4e4b\u95f4\u7684\u6574\u6570\uff0c \u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_05", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void orgLevel4ModelCheck(ExtendedDataEntity[] extendedDataEntities, Map<Long, ExtendedDataEntity> id4ExMap, Map<Long, Long> id4AdminOrgTypeStdIdMap, Map<Long, Long> adminOrgId4StdIdMap) {
        this.getValidateResult().getAllErrorInfo().forEach(error -> this.successPkIds.remove(error.getPkValue()));
        Map<Long, Long> idParentIdMap = Arrays.stream(extendedDataEntities).filter(ex -> this.successPkIds.contains(ex.getDataEntity().getLong("id"))).collect(Collectors.toMap(ex -> ex.getDataEntity().getLong("id"), ex -> ex.getDataEntity().getLong("parentorg.id")));
        Tree tree = new Tree(idParentIdMap);
        List levelTraverseIdList = tree.levelTraverse();
        Iterator idIterator = levelTraverseIdList.iterator();
        while (idIterator.hasNext()) {
            Long parentOrgTypeStdId;
            Long id = (Long)idIterator.next();
            ExtendedDataEntity extendedDataEntity = id4ExMap.get(id);
            long curAdminOrgTypeId = extendedDataEntity.getDataEntity().getLong("adminorgtype.adminorgtypestd.id");
            DynamicObject parentOrgDyn = extendedDataEntity.getDataEntity().getDynamicObject("parentorg");
            long parentOrgId = parentOrgDyn.getLong("id");
            String enable = parentOrgDyn.getString("enable");
            String status = parentOrgDyn.getString("status");
            if ("1".equals(enable) || "E".equals(status)) {
                parentOrgTypeStdId = id4AdminOrgTypeStdIdMap.get(parentOrgId);
            } else if (levelTraverseIdList.contains(parentOrgId)) {
                ExtendedDataEntity parentExtendedDataEntity = id4ExMap.get(parentOrgId);
                Long adminOrgTypeId = parentExtendedDataEntity.getDataEntity().getLong("adminorgtype.id");
                parentOrgTypeStdId = adminOrgId4StdIdMap.get(adminOrgTypeId);
            } else {
                Long adminOrgTypeId = parentOrgDyn.getLong("adminorgtype.id");
                parentOrgTypeStdId = adminOrgId4StdIdMap.get(adminOrgTypeId);
            }
            if (ADMINORG_TYPE_GROUP == curAdminOrgTypeId && !Arrays.asList(ADMINORG_TYPE_GROUP, ADMINORG_TYPE_AREA).contains(parentOrgTypeStdId)) {
                idIterator.remove();
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u96c6\u56e2\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u96c6\u56e2\u201d\u3001\u201c\u533a\u57df\u201d\uff0c \u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_06", (String)"odc-homs-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (ADMINORG_TYPE_CONPANEY != curAdminOrgTypeId || Arrays.asList(ADMINORG_TYPE_GROUP, ADMINORG_TYPE_AREA, ADMINORG_TYPE_CONPANEY).contains(parentOrgTypeStdId)) continue;
            idIterator.remove();
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u201c\u516c\u53f8\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c\u96c6\u56e2\u201d\u3001\u201c\u533a\u57df\u201d\u3001\u201c\u516c\u53f8\u201d\uff0c \u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_07", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void parentOrgCheck(ExtendedDataEntity extendedDataEntity, List<Long> disableOrgIdList) {
        long id = extendedDataEntity.getDataEntity().getLong("id");
        DynamicObject parentOrgDyn = extendedDataEntity.getDataEntity().getDynamicObject("parentorg");
        Boolean parentOrgIsFreeze = extendedDataEntity.getDataEntity().getBoolean("parentorg.isfreeze");
        long parentOrgId = parentOrgDyn.getLong("id");
        if (parentOrgIsFreeze.booleanValue()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u5c01\u5b58\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_25", (String)"odc-homs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (disableOrgIdList.contains(parentOrgId)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5728\u4e3b\u6570\u636e\u4e2d\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_08", (String)"odc-homs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (id == parentOrgId) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u586b\u5199\u5f53\u524d\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_09", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
        String status = parentOrgDyn.getString("status");
        DynamicObject adminOrgTypeDyn = parentOrgDyn.getDynamicObject("adminorgtype");
        if ("C".equals(status) && Objects.isNull(adminOrgTypeDyn)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3002", (String)"OrgDiffTempSaveValidator_10", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void cycleCheck(ExtendedDataEntity extendedDataEntity, Map<Long, List<CycleOrgBean>> orgIdNodesMap) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        long id = dataEntity.getLong("id");
        DynamicObject parentOrgDyn = dataEntity.getDynamicObject("parentorg");
        if (Objects.isNull(parentOrgDyn)) {
            return;
        }
        long parentId = parentOrgDyn.getLong("id");
        CycleOrgBean cycleOrgBean = OrgDiffTempHelper.assembleCurrentCycleOrg((Long)id, (Long)parentId);
        Deque cycleOrgBeans = OrgBatchBillCheckHelper.containsCycle((CycleOrgBean)cycleOrgBean, orgIdNodesMap, (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)cycleOrgBeans)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_11", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void establishmentDateCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        Date establishmentdate = dataEntity.getDate("establishmentdate");
        if (!HRObjectUtils.isEmpty((Object)establishmentdate) && HRDateTimeUtils.dayBefore((Date)new Date(), (Date)establishmentdate)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6210\u7acb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_12", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void fieldFillInByOrgTypeCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject adminOrgTypeDyn = dataEntity.getDynamicObject("adminorgtype");
        if (Objects.nonNull(adminOrgTypeDyn)) {
            long adminOrgTypeStdId = adminOrgTypeDyn.getLong("adminorgtypestd.id");
            AdminOrgType orgType = AdminOrgType.getById((long)adminOrgTypeStdId);
            switch (orgType) {
                case GROUP: {
                    this.shouldNotFillPropCheck(extendedDataEntity, adminOrgTypeDyn, Lists.newArrayList((Object[])new String[]{"departmenttype"}));
                    break;
                }
                case COMPANY: {
                    this.shouldNotFillPropCheck(extendedDataEntity, adminOrgTypeDyn, Lists.newArrayList((Object[])new String[]{"groupvision", "groupmission", "departmenttype"}));
                    break;
                }
                case REGION: {
                    this.shouldNotFillPropCheck(extendedDataEntity, adminOrgTypeDyn, Lists.newArrayList((Object[])new String[]{"companytype", "industrytype", "groupvision", "groupmission", "departmenttype"}));
                    break;
                }
                case DEPARTMENT: {
                    this.shouldNotFillPropCheck(extendedDataEntity, adminOrgTypeDyn, Lists.newArrayList((Object[])new String[]{"companytype", "industrytype", "groupvision", "groupmission"}));
                    break;
                }
            }
        }
    }

    private void shouldNotFillPropCheck(ExtendedDataEntity extendedDataEntity, DynamicObject adminOrgTypeDyn, List<String> propNames) {
        for (String propName : propNames) {
            String value;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            IDataEntityProperty property = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)propName);
            if (property instanceof BasedataProp) {
                DynamicObject basedataDyn = dataEntity.getDynamicObject(propName);
                if (!Objects.nonNull(basedataDyn)) continue;
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u4e0d\u53ef\u586b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_13", (String)"odc-homs-opplugin", (Object[])new Object[0]), adminOrgTypeDyn.getString("name"), property.getDisplayName().getLocaleValue()));
                continue;
            }
            if (!(property instanceof MuliLangTextProp) || !HRStringUtils.isNotEmpty((String)(value = dataEntity.getString(propName)))) continue;
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\uff0c\u201c%2$s\u201d\u4e0d\u53ef\u586b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_13", (String)"odc-homs-opplugin", (Object[])new Object[0]), adminOrgTypeDyn.getString("name"), property.getDisplayName().getLocaleValue()));
        }
    }

    private void toBeDisableCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        boolean toBeDiableFlag = dataEntity.getBoolean("tobedisableflag");
        Date toBeDisableDate = dataEntity.getDate("tobedisabledate");
        if (toBeDiableFlag && Objects.isNull(toBeDisableDate)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u201c\u662f\u5426\u5f85\u505c\u7528\u201c\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u5f85\u505c\u7528\u65e5\u671f\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_14", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        } else if (toBeDiableFlag && Objects.nonNull(toBeDisableDate)) {
            Date establishmentdate = dataEntity.getDate("establishmentdate");
            if (HRDateTimeUtils.dayBefore((Date)toBeDisableDate, (Date)establishmentdate)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f85\u505c\u7528\u65e5\u671f\u5e94\u665a\u4e8e\u6210\u7acb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_15", (String)"odc-homs-opplugin", (Object[])new Object[0]));
            }
        } else if (!toBeDiableFlag && Objects.nonNull(toBeDisableDate)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u662f\u5426\u5f85\u505c\u7528\u4e3a\u201c\u5426\u201d\u65f6\uff0c\u65e0\u9700\u586b\u5199\u5f85\u505c\u7528\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_16", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }

    private void countryToCityCheck(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject companyArea = dataEntity.getDynamicObject("companyarea");
        DynamicObject city = dataEntity.getDynamicObject("city");
        if (Objects.nonNull(companyArea) && Objects.nonNull(city)) {
            long countryId = city.getLong("country.id");
            if (companyArea.getLong("id") != countryId) {
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u56fd\u5bb6/\u5730\u533a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_17", (String)"odc-homs-opplugin", (Object[])new Object[0]), city.getString("name"), companyArea.getString("name")));
            }
        }
    }

    private void repeatNameCheck(ExtendedDataEntity extendedDataEntity, Set<Long> parentOrgExistFromMasterIdSet, Map<Long, List<String>> parentId4NameListFromApplyingMap, Map<Long, List<DynamicObject>> parentBoId4AdminOrgFromMasterListMap, Map<Long, List<String>> parentId4NameFromCurListMap, Map<Long, List<String>> parentId4NameFromTempListMap) {
        boolean isRepeat;
        List<String> nameList;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject parentOrgDyn = dataEntity.getDynamicObject("parentorg");
        Date establishmentDate = dataEntity.getDate("establishmentdate");
        if (Objects.isNull(parentOrgDyn) || Objects.isNull(establishmentDate)) {
            return;
        }
        long parentOrgId = parentOrgDyn.getLong("id");
        String name = dataEntity.getString("name");
        if (PatternUtil.valideName((String)name)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08!_/\\\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_18", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
        if (parentOrgExistFromMasterIdSet.contains(parentOrgId)) {
            List<DynamicObject> adminOrgList;
            nameList = parentId4NameListFromApplyingMap.get(parentOrgId);
            if (!CollectionUtils.isEmpty(nameList) && nameList.contains(name)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5728\u9014\u5355\u636e\u4e2d\uff0c\u540c\u4e00\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e0b\u5b58\u5728\u540c\u540d\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_19", (String)"odc-homs-opplugin", (Object[])new Object[0]));
            }
            if (!CollectionUtils.isEmpty(adminOrgList = parentBoId4AdminOrgFromMasterListMap.get(parentOrgId))) {
                for (DynamicObject adminOrg : adminOrgList) {
                    Date bsled = adminOrg.getDate("bsled");
                    if (!bsled.after(establishmentDate)) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5728\u884c\u653f\u7ec4\u7ec7\u4e3b\u6570\u636e\u4e2d\uff0c\u540c\u4e00\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e0b\u5b58\u5728\u540c\u540d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_20", (String)"odc-homs-opplugin", (Object[])new Object[0]));
                }
            }
        }
        boolean bl = isRepeat = !CollectionUtils.isEmpty(nameList = parentId4NameFromCurListMap.get(parentOrgId)) && nameList.contains(name);
        if (isRepeat) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5728\u4e0a\u7ea7\u7ec4\u7ec7\u4e2d\u5df2\u5b58\u5728\u540c\u540d\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_21", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
        List<String> nameListFromTemp = parentId4NameFromTempListMap.get(parentOrgId);
        nameListFromTemp.remove(name);
        if (!CollectionUtils.isEmpty(nameListFromTemp) && nameListFromTemp.contains(name)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\uff0c\u540c\u4e00\u4e0a\u7ea7\u5b58\u5728\u540c\u540d\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgDiffTempSaveValidator_22", (String)"odc-homs-opplugin", (Object[])new Object[0]));
        }
    }
}

