/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgfast;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.homs.business.domain.repository.OrgOperateTaskRepository;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.opplugin.web.help.AdminFastChgSaveHelper;

public class AdminOrgDisableValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ExtendedDataEntity bill = dataEntities[0];
        this.orgValidate(bill);
    }

    private void orgValidate(ExtendedDataEntity bill) {
        DynamicObjectCollection entryentityCollection = bill.getDataEntity().getDynamicObjectCollection("entryentity");
        AdminFastChgSaveHelper.baseDataWithBuCheck(bill, entryentityCollection).forEach(bean -> this.addErrorMessage(bill, bean.getMessage("odc-homs-business")));
        HashMap orgIdBsedMap = Maps.newHashMapWithExpectedSize((int)entryentityCollection.size());
        Long buOrgId = bill.getDataEntity().getDynamicObject("org") != null ? bill.getDataEntity().getLong("org.id") : 100000L;
        HashSet ownDisableBoIdSet = Sets.newHashSetWithExpectedSize((int)entryentityCollection.size());
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)entryentityCollection.size());
        entryentityCollection.stream().forEach(dyn -> {
            adminOrgIds.add(dyn.getLong("adminorg.id"));
            orgIdBsedMap.put(dyn.getLong("adminorg.boid"), dyn.getDate("adminorg.bsed"));
            ownDisableBoIdSet.add(dyn.getLong("adminorg.boid"));
        });
        Map orgInfoLatestBsedMap = OrgBatchBillCheckHelper.getOrgInfoLatestBsed((Map)orgIdBsedMap);
        Map orgIdPersonMap = OrgBatchBillCheckHelper.invokePersonService(orgIdBsedMap.keySet(), (Long)bill.getDataEntity().getLong("org.id"));
        List orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        HashMap<Object, OrgBatchCheckDto> parentToInWayChildren = new HashMap<Object, OrgBatchCheckDto>(16);
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            Long parentOrgBoId = dto.getParentOrgId();
            if (!adminOrgIds.contains(parentOrgBoId)) continue;
            parentToInWayChildren.put(parentOrgBoId, dto);
        }
        ArrayList<Long> inWaryOrgIds = new ArrayList<Long>();
        HashMap<Long, OrgBatchCheckDto> orgIdToOrgBatchCheckDto = new HashMap<Long, OrgBatchCheckDto>(16);
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            if (!adminOrgIds.contains(dto.getOrgId())) continue;
            orgIdToOrgBatchCheckDto.put(dto.getOrgId(), dto);
            inWaryOrgIds.add(dto.getOrgId());
        }
        Map<Long, DynamicObject> boidToOrg = AdminOrgFastChgHelper.getOrgDyCollectionByIds(new ArrayList(ownDisableBoIdSet)).stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        Map<Long, List<DynamicObject>> parentToChildren = this.enabledChildren(orgIdBsedMap.keySet());
        Map parentOrgIdOrgIdSetMap = OrgBatchBillCheckHelper.getParentOrgIdOrgIdSetMap(parentToChildren);
        Map parentOrg2SubNames = OrgBatchBillCheckHelper.getParentOrg2SubNames(parentToChildren);
        Map positionCountByOrg = OrgBatchBillCheckHelper.getPositionCountByOrg(new ArrayList(ownDisableBoIdSet));
        Date effdtDate = bill.getDataEntity().getDate("effdt");
        DynamicObject[] operateTaskIng = OrgOperateTaskRepository.getInstance().getAllOrgTaskByIng();
        for (DynamicObject dy2 : entryentityCollection) {
            Long orgId = dy2.getLong("adminorg.id");
            DynamicObject adminorgDy = dy2.getDynamicObject("adminorg");
            String orgNumber = adminorgDy.getString("number");
            String orgName = adminorgDy.getString("name");
            Long orgBoid = adminorgDy.getLong("boid");
            this.checkOrgOperateTask(adminorgDy, operateTaskIng, bill);
            this.adminDisabledCheck(bill, adminorgDy, orgName, boidToOrg);
            this.personCheck(bill, orgName, (List)orgIdPersonMap.get(adminorgDy.getLong("boid")));
            this.inWayBillCheck(bill, inWaryOrgIds, orgIdToOrgBatchCheckDto, orgName, orgId);
            this.subAdminEnableCheck(bill, ownDisableBoIdSet, orgName, (Set)parentOrgIdOrgIdSetMap.get(orgBoid), (OrgBatchBillCheckHelper.EnableSubValidate)parentOrg2SubNames.get(orgBoid));
            this.enabledPositionCheck(bill, buOrgId, positionCountByOrg, orgName, orgBoid);
            this.inWayBillSubAdminCheck(bill, orgName, (OrgBatchCheckDto)parentToInWayChildren.get(orgId));
            this.effectDataCheck(bill, effdtDate, orgNumber, (Date)orgInfoLatestBsedMap.get(orgBoid));
        }
    }

    private void enabledPositionCheck(ExtendedDataEntity bill, Long buOrgId, Map<Long, Long> positionCountByOrg, String orgName, Long orgBoid) {
        if (!SystemParamHelper.getAllowEnabledPosition((Long)buOrgId) && positionCountByOrg.getOrDefault(orgBoid, 0L).intValue() > 0) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u542f\u7528\u4e2d\u7684\u5c97\u4f4d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u3002", (String)"AdminOrgDisableValidator_10", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgName);
            this.addErrorMessage(bill, message);
        }
    }

    private void effectDataCheck(ExtendedDataEntity bill, Date effdtDate, String orgNumber, Date lastEffect) {
        if (!Objects.isNull(lastEffect) && effdtDate.before(lastEffect)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u8c03\u6574\u5185\u5bb9\u7684\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgDisableValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgNumber, DateUtils.formatDate((Date)lastEffect, (Object[])new Object[0]));
            this.addErrorMessage(bill, message);
        }
    }

    private void inWayBillSubAdminCheck(ExtendedDataEntity bill, String orgName, OrgBatchCheckDto orgBatchCheckDto) {
        if (!Objects.isNull(orgBatchCheckDto)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u5728\u9014\u5355\u636e\uff08\u7f16\u53f7\uff1a%2$s\uff09\u5b58\u5728\u5176\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u3002", (String)"AdminOrgDisableValidator_9", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgName, orgBatchCheckDto.getBillNo());
            this.addErrorMessage(bill, message);
        }
    }

    private void subAdminEnableCheck(ExtendedDataEntity bill, Set<Long> ownDisableBoIdSet, String orgName, Set<Long> children, OrgBatchBillCheckHelper.EnableSubValidate enableSubValidate) {
        if (!CollectionUtils.isEmpty(children) && !ownDisableBoIdSet.containsAll(children)) {
            String toNow = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"OrgBatchDisableCheckServiceImpl_9", (String)"odc-homs-business", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            for (String name : enableSubValidate.getBoidToNames().values()) {
                sb.append(name).append(",");
            }
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d-\u201c%3$s\u201d\u5b58\u5728\u542f\u7528\u4e2d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgDisableValidator_8", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgName, DateUtils.formatDate((Date)bill.getDataEntity().getDate("effdt"), (Object[])new Object[]{"yyyy-MM-dd"}), OrgBatchBillCheckHelper.lastDate.equals(enableSubValidate.getEndTime()) ? toNow : DateUtils.formatDate((Date)enableSubValidate.getEndTime(), (Object[])new Object[]{"yyyy-MM-dd"}), sb.toString());
            this.addErrorMessage(bill, message);
        }
    }

    private void inWayBillCheck(ExtendedDataEntity bill, List<Long> inWaryOrgIds, Map<Long, OrgBatchCheckDto> orgIdToOrgBatchCheckDto, String orgName, Long orgId) {
        if (!CollectionUtils.isEmpty(inWaryOrgIds) && inWaryOrgIds.contains(orgId)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u5df2\u5b58\u5728\u5355\u636e\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u505c\u7528\u3002", (String)"AdminOrgDisableValidator_7", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgName, orgIdToOrgBatchCheckDto.get(orgId).getBillNo(), BillEntryHelperEnum.getEntryDescriptionByChangeType((Long)orgIdToOrgBatchCheckDto.get(orgId).getChangeTypeId()));
            this.addErrorMessage(bill, message);
        }
    }

    private void personCheck(ExtendedDataEntity bill, String orgName, List<String> personNames) {
        if (!CollectionUtils.isEmpty(personNames)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5b58\u5728\u5728\u804c\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgDisableValidator_6", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgName);
            this.addErrorMessage(bill, message);
        }
    }

    private void adminDisabledCheck(ExtendedDataEntity bill, DynamicObject adminorgDy, String orgName, Map<Long, DynamicObject> boidToOrg) {
        if ("0".equals(boidToOrg.get(adminorgDy.getLong("boid")).getString("enable"))) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u505c\u7528\u3002", (String)"AdminOrgDisableValidator_5", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgName);
            this.addErrorMessage(bill, message);
        }
    }

    private Map<Long, List<DynamicObject>> enabledChildren(Set<Long> orgIdSet) {
        HashMap parentOrgIdOrgIdSetMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter orgIdFilter = new QFilter("parentorg", "in", orgIdSet);
        orgIdFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("enable", "=", (Object)"1"));
        orgIdFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        orgIdFilter.and("boid", "not in", orgIdSet);
        DynamicObjectCollection orgColl = serviceHelper.queryOriginalCollection("boid,name,parentorg,bsed,bsled", new QFilter[]{orgIdFilter});
        if (CollectionUtils.isEmpty((Collection)orgColl)) {
            return parentOrgIdOrgIdSetMap;
        }
        return orgColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong("parentorg")));
    }

    private void checkOrgOperateTask(DynamicObject adminorgDy, DynamicObject[] operateTaskIng, ExtendedDataEntity bill) {
        if (operateTaskIng.length == 0) {
            return;
        }
        Long orgId = adminorgDy.getLong("boid");
        for (DynamicObject orgOperateTask : operateTaskIng) {
            if (!orgId.equals(orgOperateTask.getLong("adminorgid.id"))) continue;
            this.addErrorMessage(bill, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u201c\u53d8\u66f4\u201d\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"AdminorgDetailListPlugin_37", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
    }
}

