/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgfast;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.homs.business.domain.repository.OrgOperateTaskRepository;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckDto;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;

public class AdminOrgEnableValidator
extends HRDataBaseValidator {
    public void validate() {
        List validateErrors = this.getValidateContext().getValidateResults().getValidateErrors();
        if (validateErrors != null && validateErrors.size() != 0) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ExtendedDataEntity bill = dataEntities[0];
        this.orgValidate(bill);
    }

    private void orgValidate(ExtendedDataEntity bill) {
        DynamicObjectCollection dynamicObjectCollection = bill.getDataEntity().getDynamicObjectCollection("entryentity");
        HashMap<Long, Long> boidToId = new HashMap<Long, Long>(dynamicObjectCollection.size());
        HashMap orgIdBsedMap = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        HashMap orgIdToName = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        HashSet parentBoids = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        HashMap parentIdToName = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        HashMap orgIdToParentAdminTypeId = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        HashMap parentIdToLowerNames = Maps.newHashMapWithExpectedSize((int)dynamicObjectCollection.size());
        HashMap<Long, Set<Long>> parentToChildren = new HashMap<Long, Set<Long>>();
        HashMap<Long, Long> childrenToParent = new HashMap<Long, Long>();
        dynamicObjectCollection.stream().forEach(dyn -> {
            DynamicObject adminorg = dyn.getDynamicObject("adminorg");
            Set orDefault = parentToChildren.getOrDefault(dyn.getLong("parentorg.id"), new HashSet());
            orDefault.add(adminorg.getLong("id"));
            parentBoids.add(dyn.getLong("parentorg.boid"));
            orgIdToParentAdminTypeId.put(adminorg.getLong("id"), dyn.getLong("parentorg.adminorgtype.id"));
            parentToChildren.put(dyn.getLong("parentorg.id"), orDefault);
            parentIdToName.put(dyn.getLong("parentorg.id"), dyn.getString("parentorg.name"));
            orgIdBsedMap.put(adminorg.getLong("boid"), dyn.getDate("adminorg.bsed"));
            childrenToParent.put(adminorg.getLong("id"), dyn.getLong("parentorg.id"));
            boidToId.put(adminorg.getLong("boid"), adminorg.getLong("id"));
            orgIdToName.put(adminorg.getLong("id"), adminorg.getString("name"));
            List ormLocaleValues = parentIdToLowerNames.computeIfAbsent(dyn.getLong("parentorg.id"), k -> new ArrayList());
            ormLocaleValues.add((OrmLocaleValue)adminorg.get("name"));
        });
        Map orgInfoLatestBsedMap = OrgBatchBillCheckHelper.getOrgInfoLatestBsed((Map)orgIdBsedMap);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter idFilter = new QFilter("id", "in", orgIdToParentAdminTypeId.values());
        Map<Long, DynamicObject> parentAdminIdToAdminStdId = serviceHelper.queryOriginalCollection("id,adminorgtypestd.id", new QFilter[]{idFilter}).stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        HashMap orgIdToParentAdminTypeStdId = Maps.newHashMapWithExpectedSize((int)orgIdToParentAdminTypeId.size());
        orgIdToParentAdminTypeId.forEach((id, typeId) -> orgIdToParentAdminTypeStdId.put(id, ((DynamicObject)parentAdminIdToAdminStdId.get(typeId)).getLong("adminorgtypestd.id")));
        List orgBatchCheckDtos = OrgBatchBillCheckHelper.queryBillOrgList();
        Map<Long, DynamicObject> parentMap = AdminOrgFastChgHelper.getOrgDyCollectionByIds(new ArrayList(parentToChildren.keySet())).stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dy -> dy));
        Map adminOrgTypeNameMap = OrgBatchBillCheckHelper.queryAdminOrgTypeNameMap((long)bill.getDataEntity().getLong("org.id"));
        Map orgTypeStdIdMap = OrgBatchBillCheckHelper.queryOrgTypeTypeStdIdMap();
        Map<Long, DynamicObject> boidToOrg = AdminOrgFastChgHelper.getOrgDyCollectionByIds(new ArrayList(boidToId.keySet())).stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        Date effdtDate = bill.getDataEntity().getDate("effdt");
        List adminOrgList = OrgBatchBillCheckHelper.queryAdminOrgLocaleNames((Set)Sets.newHashSet((Iterable)parentBoids), (Date)effdtDate, (boolean)true);
        List billOrgList = OrgBatchBillCheckHelper.queryBillOrgLocaleNames((Set)Sets.newHashSet(parentToChildren.keySet()));
        Map orgBoIdToCoop = AdminOrgBatchChgHelper.getOrgId2CoopDynsMapIngnoreEnabled(boidToId.keySet());
        List checkDtoList = OrgBatchBillCheckHelper.queryBillOrgList();
        DynamicObject[] operateTaskIng = OrgOperateTaskRepository.getInstance().getAllOrgTaskByIng();
        for (DynamicObject dyn2 : dynamicObjectCollection) {
            DynamicObject adminorg = dyn2.getDynamicObject("adminorg");
            Long orgId = adminorg.getLong("id");
            this.checkOrgOperateTask(adminorg, operateTaskIng, bill);
            this.orgEnabledCheck(bill, adminorg, boidToOrg);
            this.parentEnabledCheck(bill, boidToId, orgIdToName, orgIdToName.keySet(), childrenToParent, parentMap, orgId);
            this.repeatedNameCheck(bill, dyn2, adminOrgList, billOrgList);
            this.parentLevel4ModelCheck(bill, dyn2, checkDtoList, orgTypeStdIdMap, adminOrgTypeNameMap, orgIdToParentAdminTypeStdId);
            this.effectCheck(bill, orgInfoLatestBsedMap, effdtDate, adminorg);
            this.cooperEffectCheck(bill, effdtDate, orgBoIdToCoop, adminorg);
        }
        this.repeatedNameCheckThisBill(bill, parentIdToLowerNames, parentIdToName);
        this.enabledInwayCheck(bill, orgIdToName, parentToChildren, orgBatchCheckDtos, parentIdToName);
    }

    private void repeatedNameCheckThisBill(ExtendedDataEntity bill, Map<Long, List<OrmLocaleValue>> parentIdToLowerNames, Map<Long, String> parentIdToName) {
        parentIdToLowerNames.forEach((key, value) -> {
            if (value == null || value.isEmpty() || value.size() == 1) {
                return;
            }
            AtomicBoolean isSameName = new AtomicBoolean(false);
            for (int i = 0; i < value.size(); ++i) {
                for (int j = 0; !(j >= value.size() || i != j && this.validateNameRepeatedThisBill(bill, parentIdToName, (Long)key, (List<OrmLocaleValue>)value, isSameName, i, j)); ++j) {
                }
            }
        });
    }

    private boolean validateNameRepeatedThisBill(ExtendedDataEntity bill, Map<Long, String> parentIdToName, Long key, List<OrmLocaleValue> value, AtomicBoolean isSameName, int i, int j) {
        if (isSameName.get()) {
            return true;
        }
        OrmLocaleValue ormLocaleValue1 = value.get(i);
        OrmLocaleValue ormLocaleValue2 = value.get(j);
        ormLocaleValue1.forEach((code, nameVal) -> {
            if (HRStringUtils.equals((String)"GLang", (String)code) || HRStringUtils.isEmpty((String)nameVal)) {
                return;
            }
            String anotherValue = ormLocaleValue2.get(code);
            if (HRStringUtils.equals((String)nameVal, (String)anotherValue)) {
                this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%3$s\u201d\u8bed\u8a00\u73af\u5883\u4e0b\uff0c\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u201c%4$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"AdminOrgEnableValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]), nameVal, parentIdToName.get(key) == null ? "" : parentIdToName.get(key), MultiLangEnum.getName((String)code), nameVal));
                isSameName.set(true);
            }
        });
        return false;
    }

    private void cooperEffectCheck(ExtendedDataEntity bill, Date effdtDate, Map<Long, List<DynamicObject>> orgBoIdToCoop, DynamicObject adminorg) {
        List<DynamicObject> dynamicObjects = orgBoIdToCoop.get(adminorg.getLong("boid"));
        if (Objects.isNull(dynamicObjects)) {
            return;
        }
        for (DynamicObject dy : dynamicObjects) {
            Date coopBsed = dy.getDate("cooporgteam.bsed");
            if (coopBsed == null || !effdtDate.before(coopBsed)) continue;
            this.addErrorMessage(bill, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u7684\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FastOrgEffectDateCheckServiceImpl_3", (String)"odc-homs-business", (Object[])new Object[0]), dy.getString("coopreltype.name"), dy.getString("cooporgteam.name"), DateUtils.formatDate((Date)coopBsed, (Object[])new Object[0])));
        }
    }

    private void effectCheck(ExtendedDataEntity bill, Map<Long, Date> orgInfoLatestBsedMap, Date effdtDate, DynamicObject adminorg) {
        Date lastEffect = orgInfoLatestBsedMap.get(adminorg.getLong("boid"));
        if (!Objects.isNull(lastEffect) && effdtDate.before(lastEffect)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u8c03\u6574\u5185\u5bb9\u7684\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgDisableValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]), adminorg.getString("name"), DateUtils.formatDate((Date)lastEffect, (Object[])new Object[0]));
            this.addErrorMessage(bill, message);
        }
    }

    private void parentLevel4ModelCheck(ExtendedDataEntity bill, DynamicObject dynamicObject, List<OrgBatchCheckDto> billOrgList, Map<Long, Long> orgTypeStdIdMap, Map<String, String> adminOrgTypeNameMap, Map<Long, Long> orgIdToParentAdminTypeStdId) {
        DynamicObject orgtype = dynamicObject.getDynamicObject("adminorgtype");
        long orgtypeStdId = orgtype.getLong("adminorgtypestd.id");
        String orgTypeName = orgtype.getString("name");
        Long parentOrgtypeStdId = orgIdToParentAdminTypeStdId.get(dynamicObject.getLong("adminorg.id"));
        if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentOrgtypeStdId)) {
            this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgEnableValidator_6", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgTypeName, adminOrgTypeNameMap.get("level4_above_group")));
        } else if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentOrgtypeStdId)) {
            this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgEnableValidator_6", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgTypeName, adminOrgTypeNameMap.get("level4_above_company")));
        }
        Long parentId = dynamicObject.getLong("parentorg.id");
        billOrgList.forEach(dto -> {
            Long parentStdId;
            if (parentId.equals(dto.getOrgId()) && !Objects.isNull(parentStdId = (Long)orgTypeStdIdMap.get(dto.getOrgTypeId()))) {
                if (AdminOrgType.GROUP.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_GROUP.contains(parentStdId)) {
                    this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgEnableValidator_7", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgTypeName, adminOrgTypeNameMap.get("level4_above_group"), dto.getBillNo()));
                } else if (AdminOrgType.COMPANY.getId() == orgtypeStdId && !OrgBatchCheckConstants.LEVEL4_ABOVE_COMPANY.contains(parentStdId)) {
                    this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%2$s\u201d\uff0c\u76ee\u524d\u6709\u5728\u9014\u5355\u201c%3$s\u201d\u6570\u636e\u4e0d\u6ee1\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgEnableValidator_7", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgTypeName, adminOrgTypeNameMap.get("level4_above_company"), dto.getBillNo()));
                }
            }
        });
    }

    private void orgEnabledCheck(ExtendedDataEntity bill, DynamicObject adminorg, Map<Long, DynamicObject> boidToOrg) {
        if ("1".equals(boidToOrg.get(adminorg.getLong("boid")).getString("enable"))) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u7ec4\u7ec7\u5df2\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u542f\u7528\u3002", (String)"AdminOrgEnableValidator_1", (String)"odc-homs-opplugin", (Object[])new Object[0]), adminorg.getString("name"));
            this.addErrorMessage(bill, message);
        }
    }

    private void parentEnabledCheck(ExtendedDataEntity bill, Map<Long, Long> boidToId, Map<Long, String> orgIdToName, Set<Long> oweEnableIds, Map<Long, Long> childrenToParent, Map<Long, DynamicObject> parentMap, Long orgId) {
        Long parentId = childrenToParent.get(orgId);
        DynamicObject dynamicObject = parentMap.get(parentId);
        if (Objects.nonNull(dynamicObject) && HRStringUtils.equals((String)dynamicObject.getString("enable"), (String)"0") && !oweEnableIds.contains(parentId)) {
            this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"AdminOrgEnableValidator_2", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgIdToName.get(orgId)));
        }
    }

    private void enabledInwayCheck(ExtendedDataEntity bill, Map<Long, String> orgIdToName, Map<Long, Set<Long>> parentToChildren, List<OrgBatchCheckDto> orgBatchCheckDtos, Map<Long, String> parentIdToName) {
        for (OrgBatchCheckDto dto : orgBatchCheckDtos) {
            Long orgId = dto.getOrgId();
            if (!parentToChildren.containsKey(orgId) || !OrgBatchChgBillConstants.CHANGE_TYPE_DISABLE.equals(dto.getChangeTypeId())) continue;
            for (Long child : parentToChildren.get(orgId)) {
                this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\u5728\u7533\u8bf7\u5355\u201c%3$s\u201d\u4e2d\u88ab\u505c\u7528\uff0c\u4e0d\u5141\u8bb8\u542f\u7528\u3002", (String)"AdminOrgEnableValidator_3", (String)"odc-homs-opplugin", (Object[])new Object[0]), orgIdToName.get(child), parentIdToName.get(orgId), dto.getBillNo()));
            }
        }
    }

    private void repeatedNameCheck(ExtendedDataEntity bill, DynamicObject dynentry, List<OrgBatchCheckDto> adminOrgList, List<OrgBatchCheckDto> billOrgList) {
        DynamicObject dyn = dynentry.getDynamicObject("adminorg");
        Long orgId = dyn.getLong("id");
        Long orgBoId = dyn.getLong("boid");
        DynamicObject parentOrg = dynentry.getDynamicObject("parentorg");
        if (parentOrg == null) {
            return;
        }
        long parentOrgId = parentOrg.getLong("boid");
        String parentOrgName = parentOrg.getString("name");
        Map<String, List<OrgBatchCheckDto>> adminGroupMap = adminOrgList.stream().filter(dto -> !Objects.isNull(dto.getLocaleId())).filter(dto -> !dto.getOrgBoId().equals(orgBoId)).collect(Collectors.groupingBy(OrgBatchCheckDto::getLocaleId));
        Map<String, List<OrgBatchCheckDto>> billGroupMap = billOrgList.stream().filter(dto -> !Objects.isNull(dto.getLocaleId())).filter(dto -> !dto.getOrgId().equals(orgId)).collect(Collectors.groupingBy(OrgBatchCheckDto::getLocaleId));
        ILocaleString orgNameLocale = dyn.getLocaleString("name");
        orgNameLocale.forEach((code, nameVal) -> {
            if (HRStringUtils.equals((String)"GLang", (String)code) || HRStringUtils.isEmpty((String)nameVal)) {
                return;
            }
            List adminDtoList = adminGroupMap.getOrDefault(code, new ArrayList(48));
            for (OrgBatchCheckDto dto2 : adminDtoList) {
                if (!dto2.getParentOrgId().equals(parentOrgId) || !HRStringUtils.equals((String)nameVal, (String)dto2.getName())) continue;
                this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%3$s\u201d\u8bed\u8a00\u73af\u5883\u4e0b\uff0c\u201c%2$s\u201d\u4e0b\u5df2\u5b58\u5728\u540d\u79f0\u4e3a\u201c%4$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"AdminOrgEnableValidator_4", (String)"odc-homs-opplugin", (Object[])new Object[0]), nameVal, parentOrgName, MultiLangEnum.getName((String)code), nameVal));
                break;
            }
            List billDtoList = billGroupMap.getOrDefault(code, new ArrayList(48));
            billDtoList.forEach(dto -> {
                if (HRStringUtils.equals((String)nameVal, (String)dto.getName())) {
                    this.addErrorMessage(bill, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u201c%2$s\u201d\u5728\u5355\u636e\uff08\u7f16\u53f7\uff1a%3$s\uff09\u4e2d\u5df2\u5b58\u5728\u201c%s\u201d\u540d\u79f0\u201c%4$s\u201d\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"AdminOrgEnableValidator_5", (String)"odc-homs-opplugin", (Object[])new Object[0]), nameVal, parentOrgName, dto.getBillNo(), MultiLangEnum.getName((String)code), nameVal));
                }
            });
        });
    }

    private void checkOrgOperateTask(DynamicObject adminorgDy, DynamicObject[] operateTaskIng, ExtendedDataEntity bill) {
        if (operateTaskIng.length == 0) {
            return;
        }
        Long orgId = adminorgDy.getLong("boid");
        for (DynamicObject orgOperateTask : operateTaskIng) {
            if (!orgId.equals(orgOperateTask.getLong("adminorgid.id"))) continue;
            this.addErrorMessage(bill, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u201c\u53d8\u66f4\u201d\uff0c\u8bf7\u7a0d\u540e\u8fdb\u884c\u64cd\u4f5c\u3002\u53ef\u901a\u8fc7\u201c\u7ec4\u7ec7\u53d1\u5c55\u4e91>\u7ec4\u7ec7\u7ba1\u7406>\u7ec4\u7ec7\u5feb\u901f\u7ef4\u62a4\u201d\u70b9\u51fb\u201c\u66f4\u591a>\u67e5\u770b\u7ec4\u7ec7\u53d8\u52a8\u5f02\u6b65\u5904\u7406\u7ed3\u679c\u201d\u67e5\u770b\u5904\u7406\u8fdb\u5ea6\u3002", (String)"AdminorgDetailListPlugin_37", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
    }
}

