/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgfast;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.service.impl.orgmsg.CompanychangeMsgService;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ChangeSceneSubService;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.batcheffect.BatchEffectController;
import kd.hr.homs.business.service.chgbill.AdminChgDetailService;
import kd.hr.homs.business.service.chgbill.AdminOrgChgBillSaveService;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.AdminOrgFastChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchValidateHelper;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingReformHelper;
import kd.hr.homs.business.service.orgfast.async.AsyncEffectingTask;

public class AdminOrgFastChgBaseSaveOp
extends HRCoreBaseBillOp {
    private BatchEffectController effectController;
    private static final HRBaseServiceHelper BILL_ENTRY = OrgBatchValidateHelper.BATCHORGENTITY_HELPER;
    private static final HRBaseServiceHelper ADMIN_ORG = OrgBatchValidateHelper.ADMIN_ORG;
    private DynamicObject dataEntity;
    private Map<Long, List<Long>> sceneSubMap;
    private DynamicObject[] thisDataEntities;
    private DynamicObject thisBill;
    private AdminChgDetailService adminChgDetailService;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject bill = e.getDataEntities()[0];
        String entityName = bill.getDataEntityType().getName();
        if (bill.getLong("id") == 0L) {
            bill.set("id", (Object)ORM.create().genLongId(entityName));
        }
        String openApiFlag = null;
        if ("homs_orgfastchginfo".equals(entityName) || "homs_orgfastchgparent".equals(entityName)) {
            openApiFlag = bill.getString("openapiflag");
        }
        this.dataEntity = BILL_ENTRY.generateEmptyDynamicObject();
        bill.set("billstatus", (Object)"C");
        DynamicObject dynamicObjectFromDB = ADMIN_ORG.loadDynamicObject(new QFilter("id", "=", (Object)bill.getLong("adminorg.id")));
        HRDynamicObjectUtils.copy((DynamicObject)dynamicObjectFromDB, (DynamicObject)this.dataEntity);
        HRDynamicObjectUtils.copy((DynamicObject)bill, (DynamicObject)this.dataEntity);
        this.dataEntity.set("bsled", (Object)OrgDateTimeUtil.BSLED);
        this.dataEntity.set("bsed", bill.get("effdt"));
        this.dataEntity.set("billid", (Object)bill.getLong("id"));
        long entryId = bill.getLong("entryid") == 0L ? ORM.create().genLongId("homs_batchorgentity") : bill.getLong("entryid");
        this.dataEntity.set("id", (Object)entryId);
        Date tobeDisableDate = null;
        if (this.dataEntity.getBoolean("tobedisableflag") && (tobeDisableDate = this.dataEntity.getDate("tobedisabledate")) == null) {
            tobeDisableDate = bill.getDate("effdt");
        }
        this.dataEntity.set("tobedisabledate", (Object)tobeDisableDate);
        this.dataEntity.set("adminorg", (Object)dynamicObjectFromDB);
        this.beforeEffect(this.dataEntity);
        DynamicObject[] dataEntities = new DynamicObject[]{this.dataEntity};
        AdminOrgChgBillSaveService service = AdminOrgChgBillSaveService.getInstance();
        ArrayList allBoids = Lists.newArrayListWithExpectedSize((int)1);
        HashSet structProjectIdSet = Sets.newHashSetWithExpectedSize((int)1);
        this.dataEntity.getDynamicObjectCollection("struct_project_entry").stream().map(structRow -> structRow.getLong("struct_project.id")).forEach(structProjectIdSet::add);
        allBoids.add(this.dataEntity.getLong("adminorg.boid"));
        this.adminChgDetailService = new AdminChgDetailService(AdminOrgFastChgHelper.getCompanyMap((List)allBoids, (String)"1"), AdminOrgFastChgHelper.getGroupMap((List)allBoids, (String)"1"), AdminOrgFastChgHelper.getDepartmentMap((List)allBoids, (String)"1"), AdminOrgBatchChgHelper.getOrgId2CoopDynsMap((List)allBoids), (List)allBoids);
        this.adminChgDetailService.setNewOrgId2structDynMap(AdminOrgFastChgHelper.getStructEntryMapFromOrgEntry((DynamicObject[])dataEntities));
        this.adminChgDetailService.setOldOrgId2structDynMap(AdminOrgFastChgHelper.getStructMap((List)allBoids, (Set)structProjectIdSet));
        List<Long> orgIdList = Collections.singletonList(this.dataEntity.getLong("adminorg.boid"));
        Map oldVersionMap = service.getOrgRelateVersion(orgIdList);
        Map oldOrgBasicInfo = service.getOrgBeforeChangeVersionBasicInfo(orgIdList);
        service.setBeforeBillEntryVersionId(dataEntities, oldVersionMap, oldOrgBasicInfo);
        if (this.operateOption.containsVariable("async_save") && "true".equals(this.operateOption.getVariableValue("async_save"))) {
            AsyncEffectingTask task = new AsyncEffectingTask.AsyncEffectingTaskBuilder().adminChgDetailService(this.adminChgDetailService).thisDataEntities(dataEntities).thisBill(bill).dataEntity(this.dataEntity).build();
            AsyncEffectingReformHelper.SUBMIT_TASK_THREAD_POOL.execute((Runnable)task);
        } else {
            this.sceneSubMap = new ChangeSceneSubService().getSceneSubId(Collections.singletonList(this.dataEntity));
            this.effectController = BatchEffectController.createBatchEffectController((DynamicObject)bill, (DynamicObject[])dataEntities, (String)openApiFlag);
            this.effectController.saveAdminOrgAndBillEntry();
            this.thisBill = bill;
            this.thisDataEntities = dataEntities;
            TransactionModelService transactionService = new TransactionModelService();
            transactionService.changeTransactionSave(Long.valueOf(1010L), Long.valueOf(bill.getLong("id")), false, dataEntities, this.sceneSubMap);
        }
    }

    protected void beforeEffect(DynamicObject dataEntity) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (this.operateOption.containsVariable("async_save") && "true".equals(this.operateOption.getVariableValue("async_save"))) {
            return;
        }
        List companyChangeOrgList = this.effectController.getCompanyChangeOrgList();
        this.sendEffectMsg(this.dataEntity, this.sceneSubMap);
        this.adminChgDetailService.saveAdminOrgChgDetail(this.thisBill, this.thisDataEntities);
        this.sendCompanyChangeMsg(companyChangeOrgList);
    }

    private void sendCompanyChangeMsg(List<DynamicObject> companyChangeOrgList) {
        CompanychangeMsgService companychangeMsgService = new CompanychangeMsgService();
        companychangeMsgService.handleChangeMsg(companyChangeOrgList, null, "C");
    }

    protected void sendEffectMsg(DynamicObject dataEntity, Map<Long, List<Long>> sceneSubMap) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs operationArgs) {
        if (this.operateOption.containsVariable("async_save") && "true".equals(this.operateOption.getVariableValue("async_save"))) {
            return;
        }
        this.effectController.afterEffectBill();
    }

    public BatchEffectController getEffectController() {
        return this.effectController;
    }
}

