/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgfast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.haos.business.domain.service.impl.orgmsg.CompanychangeMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgDisableMsgService;
import kd.hr.haos.business.util.AdminStructLongNumberUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.opplugin.web.help.AdminFastChgSaveHelper;
import kd.hr.homs.opplugin.web.orgfast.AdminOrgDisableValidator;

public class AdminOrgFastDisableSaveOp
extends HRCoreBaseBillOp {
    private AdminFastChgSaveHelper helper;

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AdminOrgDisableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String isOnlyValidator = this.getOption().getVariableValue("isOnlyValidator", "false");
        if (StringUtils.isNotEmpty((CharSequence)isOnlyValidator) && "true".equals(isOnlyValidator)) {
            args.setCancel(true);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        this.helper = new AdminFastChgSaveHelper();
        this.helper.enableAndDisableBeforeSave(args, "disabled");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs operationArgs) {
        if (Objects.nonNull(this.helper.getEffectController())) {
            this.helper.getEffectController().afterEffectBill();
            this.helper.saveAdminOrgChgDetail();
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        List companyChangeOrgList = this.helper.getEffectController().getCompanyChangeOrgList();
        CompanychangeMsgService companychangeMsgService = new CompanychangeMsgService();
        companychangeMsgService.handleChangeMsg(companyChangeOrgList, null, "C");
        DynamicObject billDyn = args.getDataEntities()[0];
        DynamicObjectCollection entryEntity = billDyn.getDynamicObjectCollection("entryentity");
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
        orgList.addAll(Arrays.stream(this.helper.getDataEntities()).collect(Collectors.toList()));
        OrgDisableMsgService changeMsgService = new OrgDisableMsgService();
        AdminStructLongNumberUtils.sortBatchEntityByAdminStructLongNumber((List)orgList, (boolean)true);
        changeMsgService.handleChangeMsg((List)orgList, this.helper.getSceneSubMap(), "C");
    }
}

