/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.orgfast;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.haos.business.domain.service.impl.orgmsg.CompanychangeMsgService;
import kd.hr.haos.business.domain.service.impl.orgmsg.OrgChangeMsgService;
import kd.hr.haos.business.util.AdminStructLongNumberUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.opplugin.web.help.AdminFastChgSaveHelper;
import kd.hr.homs.opplugin.web.orgfast.AdminOrgEnableValidator;

public class AdminOrgFastEnableSaveOp
extends HRCoreBaseBillOp {
    private AdminFastChgSaveHelper helper;

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new AdminOrgEnableValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        this.helper = new AdminFastChgSaveHelper();
        this.helper.enableAndDisableBeforeSave(args, "enabled");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs operationArgs) {
        if (Objects.nonNull(this.helper.getEffectController())) {
            this.helper.getEffectController().afterEffectBill();
            this.helper.saveAdminOrgChgDetail();
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        List companyChangeOrgList = this.helper.getEffectController().getCompanyChangeOrgList();
        CompanychangeMsgService companychangeMsgService = new CompanychangeMsgService();
        companychangeMsgService.handleChangeMsg(companyChangeOrgList, null, "C");
        DynamicObject billDyn = args.getDataEntities()[0];
        DynamicObjectCollection entryEntity = billDyn.getDynamicObjectCollection("entryentity");
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
        orgList.addAll(Arrays.stream(this.helper.getDataEntities()).collect(Collectors.toList()));
        OrgChangeMsgService changeMsgService = new OrgChangeMsgService();
        AdminStructLongNumberUtils.sortBatchEntityByAdminStructLongNumber((List)orgList, (boolean)false);
        changeMsgService.handleChangeMsg((List)orgList, this.helper.getSceneSubMap(), "C");
    }
}

