/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplication;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplicationAdapt;
import kd.hr.homs.opplugin.web.validate.position.BosPositionBillValidator;
import kd.hr.homs.opplugin.web.validate.position.PositionBillChangeValidator;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionFutureVersionExistValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;

public class PositionBillChangeOp
extends HRCoreBaseBillOp {
    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        super.onAddValidators(addValidatorsEventArgs);
        addValidatorsEventArgs.addValidator((AbstractValidator)new PositionBillChangeValidator());
        String changeType = this.getOption().getVariableValue("changetype", "propertychange");
        if (HRStringUtils.equals((String)changeType, (String)"propertychange")) {
            new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(addValidatorsEventArgs.getDataEntities());
            addValidatorsEventArgs.addValidator((AbstractValidator)new PositionFutureVersionExistValidator("hisnewversion"));
            addValidatorsEventArgs.addValidator((AbstractValidator)new PositionHisLoopValidator(null, "hisnewversion").checkHis());
        } else {
            addValidatorsEventArgs.addValidator((AbstractValidator)new PositionHisLoopValidator(null, "hisnewversion").checkTeamUpRel());
        }
        addValidatorsEventArgs.addValidator((AbstractValidator)new BosPositionBillValidator());
        addValidatorsEventArgs.getValidators().forEach(validator -> validator.setAddBillNoForContent(false));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        args.setCancelOperation(true);
        DynamicObject[] positionBills = args.getDataEntities();
        String changeType = this.getOption().getVariableValue("changetype", "propertychange");
        if (HRStringUtils.equals((String)changeType, (String)"propertychange")) {
            PositionBillServiceApplicationAdapt positionBillServiceApplicationAdapt = new PositionBillServiceApplicationAdapt();
            positionBillServiceApplicationAdapt.batchChangePosition(positionBills);
        } else {
            PositionBillServiceApplication positionBillServiceApplication = new PositionBillServiceApplication();
            List positions = PositionServiceHelper.transferPositionBillToPositionForModify((DynamicObject[])positionBills);
            Map<String, DynamicObjectCollection> reportRelationEntryEntityMap = positionBillServiceApplication.reportRelationEntryEntity(positionBills);
            positionBillServiceApplication.batchChangePositionRelation(positions, reportRelationEntryEntityMap, true);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        List positionIds = PositionQueryRepository.getInstance().queryPositionIdByBills(e.getDataEntities());
        IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
    }
}

