/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplicationAdapt;
import kd.hr.homs.opplugin.web.validate.position.BosPositionBillValidator;
import kd.hr.homs.opplugin.web.validate.position.PositionBillSaveValidator;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;

public class PositionBillSaveOp
extends HRCoreBaseBillOp {
    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        super.onAddValidators(addValidatorsEventArgs);
        new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(addValidatorsEventArgs.getDataEntities());
        addValidatorsEventArgs.addValidator((AbstractValidator)new PositionBillSaveValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new BosPositionBillValidator());
        addValidatorsEventArgs.getValidators().forEach(validator -> validator.setAddBillNoForContent(false));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] positionBills = args.getDataEntities();
        PositionBillServiceApplicationAdapt positionBillServiceApplication = new PositionBillServiceApplicationAdapt();
        positionBillServiceApplication.batchSavePositionBill(positionBills);
        args.setCancelOperation(true);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl msg = new ChangeMsgServiceImpl();
        msg.sendMsg();
        List positionIds = PositionQueryRepository.getInstance().queryPositionIdByBills(e.getDataEntities());
        IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
    }
}

