/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.business.application.impl.position.PositionImptServiceApplication;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.position.PreviousPositionServiceApplication;
import kd.hrmp.hbpm.business.application.position.IPositionServiceApplication;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionBillServiceApplication {
    public List<DynamicObject> batchSavePositionBill(DynamicObject[] positionBills) {
        if (ArrayUtils.isEmpty((Object[])positionBills)) {
            return null;
        }
        List positions = PositionServiceHelper.transferPositionBillToPosition((DynamicObject[])positionBills, (long)1010L);
        Map<String, DynamicObjectCollection> reportRelationEntryEntity = this.reportRelationEntryEntity(positionBills);
        Map<String, Object> result = this.doSavePositions((IPositionServiceApplication)new PositionServiceApplicationImpl(), positions, reportRelationEntryEntity);
        this.handlePositionBill(positionBills, this.buildBoIdAndHisVersionIdMap((List)result.get("hisVersions")), (Map)result.get("workRoleMap"));
        this.savePositionBill(positionBills);
        return (List)result.get("hisVersions");
    }

    public Map<Long, DynamicObject> batchSaveImportPosition(DynamicObject[] positionBills, DynamicObject[] hisVersion) {
        if (ArrayUtils.isEmpty((Object[])positionBills)) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        List positions = PositionServiceHelper.transferPositionBillToPosition((DynamicObject[])positionBills, (long)1010L);
        Map<String, DynamicObjectCollection> reportRelationEntryEntity = this.reportRelationEntryEntity(positionBills);
        Map<String, Object> result = this.doSavePositions((IPositionServiceApplication)new PositionImptServiceApplication(hisVersion), positions, reportRelationEntryEntity);
        Map workRoleMap = (Map)result.get("workRoleMap");
        this.handlePositionBill(positionBills, this.buildBoIdAndHisVersionIdMap(Arrays.asList(hisVersion)), workRoleMap);
        this.savePositionBill(positionBills);
        return workRoleMap;
    }

    public void batchModifyImptPosition(List<DynamicObject> hisVersion) {
        if (CollectionUtils.isEmpty(hisVersion)) {
            return;
        }
        PositionImptServiceApplication positionImptServiceApplication = new PositionImptServiceApplication(hisVersion.toArray(new DynamicObject[0]));
        positionImptServiceApplication.modifyPosition(hisVersion);
        List newPositionBills = PositionServiceHelper.transferPositionToPositionBill(hisVersion);
        this.savePositionBill(newPositionBills.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> batchChangePosition(DynamicObject[] positionBills) {
        if (ArrayUtils.isEmpty((Object[])positionBills)) {
            return null;
        }
        List positions = PositionServiceHelper.transferPositionBillToPositionForModify((DynamicObject[])positionBills);
        List<DynamicObject> newDynamicObjects = this.changePosition(positions);
        List newPositionBills = PositionServiceHelper.transferPositionToPositionBill(newDynamicObjects);
        this.savePositionBill(newPositionBills.toArray(new DynamicObject[0]));
        return newDynamicObjects;
    }

    private List<DynamicObject> changePosition(List<DynamicObject> positions) {
        ArrayList<DynamicObject> previousPositions = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> currentPositions = new ArrayList<DynamicObject>(16);
        this.resolvePositionGroup(positions, previousPositions, currentPositions);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(previousPositions)) {
            DynamicObject[] previousResult = this.doChangePosition((IPositionServiceApplication)new PreviousPositionServiceApplication(), previousPositions);
            result.addAll(Arrays.asList(previousResult));
        }
        if (!CollectionUtils.isEmpty(currentPositions)) {
            DynamicObject[] currentResult = this.doChangePosition((IPositionServiceApplication)new PositionServiceApplicationImpl(), currentPositions);
            result.addAll(Arrays.asList(currentResult));
        }
        return result;
    }

    public void batchChangePositionRelation(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity, boolean saveEvent) {
        PositionServiceApplicationImpl serviceApplication = new PositionServiceApplicationImpl();
        for (DynamicObject position : positions) {
            position.set("changetype", (Object)1030L);
        }
        serviceApplication.changePositionRelation(positions, reportRelationEntryEntity, saveEvent);
    }

    private Map<String, Object> doSavePositions(IPositionServiceApplication positionServiceApplication, List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity) {
        return positionServiceApplication.savePosition(positions, reportRelationEntryEntity);
    }

    private DynamicObject[] doChangePosition(IPositionServiceApplication positionServiceApplication, List<DynamicObject> positions) {
        return positionServiceApplication.changePosition(positions, true);
    }

    public Map<String, DynamicObjectCollection> reportRelationEntryEntity(DynamicObject[] positionBills) {
        HashMap reportRelationEntryEntity = Maps.newHashMapWithExpectedSize((int)positionBills.length);
        Arrays.stream(positionBills).forEach(positionBill -> {
            DynamicObjectCollection entryEntity = positionBill.getDynamicObjectCollection("entryentity");
            if (entryEntity != null && entryEntity.size() > 0) {
                reportRelationEntryEntity.put(positionBill.getString("number"), entryEntity);
            }
        });
        return reportRelationEntryEntity;
    }

    private void handlePositionBill(DynamicObject[] positionBills, Map<Long, Long> hisVersionResponse, Map<Long, DynamicObject> workRoleMap) {
        Arrays.stream(positionBills).forEach(positionBill -> {
            positionBill.set("workrole", workRoleMap.get(positionBill.getLong("id")));
            positionBill.set("hisnewversion", hisVersionResponse.get(positionBill.getLong("id")));
        });
    }

    private Map<Long, Long> buildBoIdAndHisVersionIdMap(List<DynamicObject> hisVersions) {
        HashMap boIdAndHisVersionIdMap = Maps.newHashMapWithExpectedSize((int)hisVersions.size());
        for (DynamicObject hisVersion : hisVersions) {
            if (hisVersion.getBoolean("iscurrentversion")) continue;
            boIdAndHisVersionIdMap.put(hisVersion.getLong("boid"), hisVersion.getLong("id"));
        }
        return boIdAndHisVersionIdMap;
    }

    private void savePositionBill(DynamicObject[] positionBills) {
        HRBaseServiceHelper positionBillServiceHelper = new HRBaseServiceHelper("homs_positionbill");
        positionBillServiceHelper.save(positionBills);
    }

    private void resolvePositionGroup(List<DynamicObject> positions, List<DynamicObject> previousPositions, List<DynamicObject> currentPositions) {
        Date currentDate = PositionUtils.getCurrentDate();
        for (DynamicObject position : positions) {
            if (currentDate.after(position.getDate("bsed"))) {
                previousPositions.add(position);
                continue;
            }
            currentPositions.add(position);
        }
    }

    public void relationImport(DynamicObject[] positions) {
        for (DynamicObject pos : positions) {
            pos.set("bsed", (Object)pos.getDate("bsed"));
        }
        Map<String, DynamicObjectCollection> reportRelationEntryEntityMap = this.reportRelationEntryEntity(positions);
        this.batchChangePositionRelation(Arrays.asList(positions), reportRelationEntryEntityMap, false);
    }
}

