/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplicationAdapt;
import kd.hr.homs.opplugin.web.validate.position.BosPositionBillValidator;
import kd.hr.homs.opplugin.web.validate.position.PositionFutureModifyValidator;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IPositionServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;

public class PositionFutureModifyOp
extends HRCoreBaseBillOp {
    private IPositionServiceApplication positionServiceApplication = new PositionServiceApplicationImpl();
    private PositionBillServiceApplicationAdapt positionBillServiceApplicationAdapt = new PositionBillServiceApplicationAdapt();

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new PositionFutureModifyValidator());
        evt.addValidator((AbstractValidator)new PositionHisLoopValidator(null, "hisnewversion").checkHis());
        evt.addValidator((AbstractValidator)new BosPositionBillValidator());
        evt.getValidators().forEach(validator -> validator.setAddBillNoForContent(false));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        DynamicObject[] positionBills = evt.getDataEntities();
        DynamicObject positionBill = positionBills[0];
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionsById(Collections.singletonList(positionBill.getLong("hisnewversion")));
        DynamicObject position = positions[0];
        this.positionServiceApplication.positionFutureRevoke(Collections.singletonList(position.getLong("boid")), true);
        this.positionServiceApplication.setFutureEffectChangeProp(positionBills);
        this.positionBillServiceApplicationAdapt.batchChangePosition(positionBills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        List positionIds = PositionQueryRepository.getInstance().queryPositionIdByBills(e.getDataEntities());
        IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
    }
}

