/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.homs.opplugin.web.validate.position.BosPositionBillValidator;
import kd.hr.homs.opplugin.web.validate.position.PositionReviseImptValidator;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.opplugin.web.position.validate.JobLevelGradeRangeImportValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;

public class PositionReviseImportOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        DynamicObject[] positions = args.getDataEntities();
        this.resetBsedAndBsled(positions);
        args.addValidator((AbstractValidator)new BosPositionBillValidator());
        args.addValidator((AbstractValidator)new PositionReviseImptValidator());
        args.addValidator((AbstractValidator)new JobLevelGradeRangeImportValidator(true));
        args.addValidator((AbstractValidator)new PositionHisLoopValidator(null, "id").checkHis());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] positions = args.getDataEntities();
        PositionServiceApplicationImpl positionServiceApplication = new PositionServiceApplicationImpl();
        positionServiceApplication.revisePosition(positions);
    }

    private void resetBsedAndBsled(DynamicObject[] positions) {
        HashMap<Long, Date> boIdAndBSedMap = new HashMap<Long, Date>();
        for (DynamicObject position : positions) {
            long boid = position.getLong("boid");
            Date firstBsed = position.getDate("firstbsed");
            Date bsed = position.getDate("bsed");
            boIdAndBSedMap.put(boid, HRDateTimeUtils.dayAfter((Date)firstBsed, (Date)bsed) ? firstBsed : bsed);
        }
        Map longDateMap = PositionQueryRepository.getInstance().queryPositionHisVersionBSled(boIdAndBSedMap);
        for (DynamicObject position : positions) {
            Date versionBsed;
            long boid = position.getLong("boid");
            DynamicObject preVersion = (DynamicObject)longDateMap.get(boid);
            if (preVersion == null) continue;
            Date bsed = position.getDate("bsed");
            position.set("bsed", (Object)(HRDateTimeUtils.dayAfter((Date)bsed, (Date)(versionBsed = preVersion.getDate("bsed"))) ? versionBsed : bsed));
            position.set("bsled", (Object)preVersion.getDate("bsled"));
            position.set("enable", (Object)preVersion.getString("enable"));
            position.set("number", (Object)preVersion.getString("number"));
            String preDatastatus = preVersion.getString("datastatus");
            position.set("datastatus", (Object)preDatastatus);
        }
    }
}

