/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.hr.homs.business.service.position.PositionReviseService;
import kd.hr.homs.opplugin.web.validate.position.BosPositionBillValidator;
import kd.hr.homs.opplugin.web.validate.position.PositionReviseSaveValidator;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.DutyWorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IDarkPositionApplication;
import kd.hrmp.hbpm.business.application.workrole.IDutyWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IReportingRelationServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionChangeEventQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ReviseLogServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.domain.service.position.IPositionService;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.model.ChangeDetailEntity;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionFutureVersionExistValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;

public class PositionReviseOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(PositionReviseOp.class);
    private IDutyWorkRoleServiceApplication dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
    private IWorkRoleServiceApplication workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
    private IPositionService positionService = new PositionServiceImpl();
    private IReportingRelationServiceApplication reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
    private IDarkPositionApplication darkPositionApplication = new DarkPositionApplicationImpl();

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        LOG.info("PositionReviseOp-validator-start");
        long startTime = System.currentTimeMillis();
        super.onAddValidators(addValidatorsEventArgs);
        ArrayList<ExtendedDataEntity> falseDataentity = new ArrayList<ExtendedDataEntity>(8);
        new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(addValidatorsEventArgs.getDataEntities());
        addValidatorsEventArgs.addValidator((AbstractValidator)new PositionReviseSaveValidator(falseDataentity));
        addValidatorsEventArgs.addValidator((AbstractValidator)new PositionFutureVersionExistValidator("hisnewversion"));
        addValidatorsEventArgs.addValidator((AbstractValidator)new PositionHisLoopValidator(falseDataentity, "hisnewversion").checkHis());
        addValidatorsEventArgs.addValidator((AbstractValidator)new BosPositionBillValidator());
        addValidatorsEventArgs.getValidators().forEach(validator -> validator.setAddBillNoForContent(false));
        LOG.info("PositionReviseOp-validator-end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        LOG.info("PositionReviseOp-op-start");
        long startTime = System.currentTimeMillis();
        List revisePositionList = PositionServiceHelper.transferPositionBillToPositionForModify((DynamicObject[])args.getDataEntities());
        DynamicObject reviseBill = args.getDataEntities()[0];
        DynamicObject revisePosition = (DynamicObject)revisePositionList.get(0);
        Long hisId = reviseBill.getLong("hisnewversion");
        DynamicObject oldHis = PositionQueryRepository.getInstance().queryDataById(hisId);
        Set changeType = new PositionReviseService(false).getChangeType(reviseBill);
        this.setChangeFieldValue(revisePosition);
        DynamicObject newVersion = this.revisePosition(revisePosition, oldHis, changeType);
        this.handleLeaderPosition(newVersion, oldHis);
        DynamicObject reviseLog = this.saveReviseLog(newVersion, oldHis, changeType);
        this.saveReviseMsg(newVersion, reviseLog, this.isPositionTypeChanged(reviseBill));
        if (HRStringUtils.equals((String)"1", (String)oldHis.getString("datastatus"))) {
            IBosPositionService.getInstance().addWaitSyncLogs(new DynamicObject[]{oldHis}, new DynamicObject[]{newVersion});
        }
        args.getDataEntities()[0].set("id", (Object)newVersion.getString("id"));
        if (changeType.contains("2") && !changeType.contains("3")) {
            args.getDataEntities()[0].set("isadd", (Object)Boolean.TRUE);
        }
        LOG.info("PositionReviseOp-op-end, cost time {} ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void setChangeFieldValue(DynamicObject revisePosition) {
        PositionChangeEventQueryRepository instance = PositionChangeEventQueryRepository.getInstance();
        DynamicObject changeOperationDy = instance.queryChangeOperation(Long.valueOf(1040L));
        DynamicObject changeSceneDy = instance.queryChangeScene(Long.valueOf(1080L));
        DynamicObject changeTypeDy = instance.queryChangeType(Long.valueOf(1060L));
        revisePosition.set("changeoperate", (Object)changeOperationDy);
        revisePosition.set("changescene", (Object)changeSceneDy);
        revisePosition.set("changetype", (Object)changeTypeDy);
    }

    private DynamicObject revisePosition(DynamicObject revisePosition, DynamicObject oldHis, Set<String> changeType) {
        Date bsled;
        this.updateAllVersionEstdAndFirstBsed(revisePosition, changeType);
        if (changeType.contains("1") && changeType.size() == 1) {
            return oldHis;
        }
        if (changeType.contains("2")) {
            bsled = HRDateTimeUtils.addDay((Date)oldHis.getDate("bsed"), (long)-1L);
            revisePosition.set("bsled", (Object)bsled);
        }
        if (changeType.contains("3")) {
            bsled = oldHis.getDate("bsled");
            revisePosition.set("bsled", (Object)bsled);
        }
        revisePosition.set("sourcevid", (Object)oldHis.getLong("id"));
        this.workRoleServiceApplication.updateWorkRole(Collections.singletonList(revisePosition));
        this.dutyWorkRoleServiceApplication.updateDutyRole(Collections.singletonList(revisePosition));
        this.reportingRelationServiceApplication.reviseSysReportRel(revisePosition, Long.valueOf(oldHis.getLong("parent.workrole.id")));
        DynamicObject newVersion = this.positionService.revisePositionVersion(revisePosition);
        return newVersion;
    }

    private void updateAllVersionEstdAndFirstBsed(DynamicObject revisePosition, Set<String> changeType) {
        if (changeType.contains("1") || changeType.contains("2")) {
            DynamicObject[] positions;
            Long boId = revisePosition.getLong("boid");
            for (DynamicObject pos : positions = PositionQueryRepository.getInstance().queryAllHisData(boId)) {
                if (changeType.contains("1")) {
                    pos.set("establishmentdate", (Object)revisePosition.getDate("establishmentdate"));
                }
                if (!changeType.contains("2")) continue;
                pos.set("firstbsed", (Object)revisePosition.getDate("firstbsed"));
            }
            PositionQueryRepository.getInstance().saveData(positions);
        }
    }

    private DynamicObject saveReviseLog(DynamicObject newVersion, DynamicObject oldHis, Set<String> changeType) {
        if (!changeType.contains("3")) {
            return null;
        }
        long modifier = RequestContext.get().getCurrUserId();
        long boid = newVersion.getLong("boid");
        long changeReasonId = newVersion.getLong("changedesc.id");
        String changeExplain = newVersion.getString("changeexplain");
        Date changeDate = newVersion.getDate("bsed");
        ChangeDetailEntity changeDetailEntity = new ChangeDetailEntity(boid, oldHis, newVersion, 0L, new Date(), modifier, 1040L, 1060L, 1080L, changeReasonId, changeDate, changeExplain);
        ReviseLogServiceImpl reviseLogService = new ReviseLogServiceImpl();
        return reviseLogService.saveReviseLog(changeDetailEntity);
    }

    private void handleLeaderPosition(DynamicObject newVersion, DynamicObject oldHis) {
        if (HRStringUtils.equals((String)"1", (String)oldHis.getString("datastatus")) && !HRStringUtils.equals((String)oldHis.getString("isleader"), (String)newVersion.getString("isleader"))) {
            this.darkPositionApplication.maintainDarkPositionRelation(Collections.singletonList(newVersion), true, false);
        }
    }

    private void saveReviseMsg(DynamicObject newVersion, DynamicObject reviseLog, boolean isPositionTypeChanged) {
        if (reviseLog == null) {
            return;
        }
        this.setChangeFieldValue(newVersion);
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl(newVersion, reviseLog, isPositionTypeChanged ? Collections.singletonList(newVersion.getLong("boid")) : null);
        changeMsgServiceImpl.handleChangeMsg(Collections.singletonList(newVersion));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        IBosPositionService.getInstance().commonSyncPositions();
    }

    private boolean isPositionTypeChanged(DynamicObject reviseBill) {
        for (IDataEntityProperty property : reviseBill.getDataEntityState().getBizChangedProperties()) {
            String propName = property.getName();
            if (!propName.equals("positiontype_id")) continue;
            return true;
        }
        return false;
    }
}

