/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplication;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplicationAdapt;
import kd.hr.homs.opplugin.web.validate.position.PositioImportWithTplValidator;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeCheck;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeImportSaveCheck;
import kd.hrmp.hbpm.opplugin.web.position.validate.BosPositionValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.JobLevelGradeRangeImportValidator;
import kd.hrmp.hbpm.opplugin.web.validate.PositionImptRuleNumberValidator;
import kd.hrmp.hbpm.opplugin.web.validate.PositionSaveImptValidator;

public class PositionSaveImportOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(PositionSaveImportOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(args.getDataEntities());
        args.addValidator((AbstractValidator)new PositioImportWithTplValidator());
        args.addValidator((AbstractValidator)new PositionSaveImptValidator());
        args.addValidator((AbstractValidator)new JobLevelGradeRangeImportValidator((JobLevelGradeRangeCheck)new JobLevelGradeRangeImportSaveCheck()));
        args.addValidator((AbstractValidator)new BosPositionValidator());
        args.addValidator((AbstractValidator)new PositionImptRuleNumberValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] positionList;
        LOGGER.info("--PositionSaveImportOp beginOperationTransaction start--");
        ArrayList positions = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList hisVersionPositions = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject position : positionList = args.getDataEntities()) {
            this.handleOriginPosition(position);
            if ("true".equals(position.getString("iscurrentversion"))) {
                positions.add(position);
                continue;
            }
            hisVersionPositions.add(position);
        }
        if (CollectionUtils.isEmpty((Collection)positions)) {
            return;
        }
        Long startTime = System.currentTimeMillis();
        List positionBills = PositionServiceHelper.transferToPositionBill((List)positions);
        LOGGER.info(String.format("--PositionSaveImportOp transferToPositionBill time : %s", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        PositionBillServiceApplication positionBillServiceApplication = new PositionBillServiceApplication();
        Map<Long, DynamicObject> workRoles = positionBillServiceApplication.batchSaveImportPosition(positionBills.toArray(new DynamicObject[0]), hisVersionPositions.toArray(new DynamicObject[0]));
        LOGGER.info(String.format("--PositionSaveImportOp batchSaveImportPosition time : %s", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        this.handlePosition(positionList, workRoles);
        PositionBillServiceApplicationAdapt positionBillServiceApplicationAdapt = new PositionBillServiceApplicationAdapt();
        positionBillServiceApplicationAdapt.batchSaveImportPosition(Arrays.asList(positionList));
        LOGGER.info(String.format("--PositionSaveImportOp handlePosition time : %s", System.currentTimeMillis() - startTime));
        LOGGER.info("--PositionSaveImportOp beginOperationTransaction end--");
    }

    private void handlePosition(DynamicObject[] positions, Map<Long, DynamicObject> workRoleMap) {
        for (DynamicObject position : positions) {
            position.set("workrole", (Object)workRoleMap.get(position.getLong("boid")));
        }
    }

    private void handleOriginPosition(DynamicObject position) {
        position.set("changetype", (Object)1010L);
        if (HRObjectUtils.isEmpty((Object)position.getDynamicObject("org")) && !HRObjectUtils.isEmpty((Object)position.getDynamicObject("adminorg"))) {
            position.set("org", (Object)position.getDynamicObject("adminorg").getDynamicObject("org"));
        }
        if (position.getDate("establishmentdate") == null) {
            position.set("establishmentdate", (Object)position.getDate("bsed"));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        Set positionIds = Arrays.stream(e.getDataEntities()).map(position -> position.getLong("boid")).collect(Collectors.toSet());
        IBosPositionService.getInstance().addOrUpdatePositions(new ArrayList(positionIds));
    }
}

