/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.homs.opplugin.web.position.PositionBillServiceApplicationAdapt;
import kd.hr.homs.opplugin.web.validate.position.PositioImportWithTplValidator;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.opplugin.web.position.validate.BosPositionValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.JobLevelGradeRangeImportValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionFutureVersionExistValidator;
import kd.hrmp.hbpm.opplugin.web.position.validate.PositionHisLoopValidator;
import kd.hrmp.hbpm.opplugin.web.validate.PositionUpdateImptValidator;

public class PositionUpdateImportOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        new PositionServiceApplicationImpl().setMustInputFieldDefaultValue(args.getDataEntities());
        args.addValidator((AbstractValidator)new PositioImportWithTplValidator());
        args.addValidator((AbstractValidator)new PositionUpdateImptValidator());
        args.addValidator((AbstractValidator)new JobLevelGradeRangeImportValidator());
        args.addValidator((AbstractValidator)new PositionFutureVersionExistValidator());
        args.addValidator((AbstractValidator)new PositionHisLoopValidator(null, "id").checkHis());
        args.addValidator((AbstractValidator)new BosPositionValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] positions = args.getDataEntities();
        ArrayList hisVersionPositions = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject position : positions) {
            if (!"false".equals(position.getString("iscurrentversion"))) continue;
            hisVersionPositions.add(position);
        }
        if (CollectionUtils.isEmpty((Collection)hisVersionPositions)) {
            return;
        }
        this.handlePosition(hisVersionPositions);
        PositionBillServiceApplicationAdapt positionBillServiceApplication = new PositionBillServiceApplicationAdapt();
        positionBillServiceApplication.batchModifyImptPosition(hisVersionPositions);
    }

    private void handlePosition(List<DynamicObject> hisVersionPositions) {
        for (DynamicObject position : hisVersionPositions) {
            position.set("changetype", (Object)1020L);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        changeMsgServiceImpl.sendMsg();
        List positionIds = Arrays.stream(e.getDataEntities()).map(position -> position.getLong("boid")).collect(Collectors.toList());
        IBosPositionService.getInstance().addOrUpdatePositions(positionIds);
    }
}

