/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.opplugin.web.validate.position;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.ext.BosPositionValidateReq;
import kd.hr.hbp.common.ext.BosPositionValidateResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;

public class BosPositionBillReviseSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BosPositionBillReviseSaveValidator.class);

    public void validate() {
        List reqs;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            LOGGER.info("dataEntities is empty");
            return;
        }
        DynamicObject[] positionBills = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        List positionVidList = Arrays.stream(positionBills).map(positionBill -> positionBill.getLong("hisnewversion")).filter(vid -> vid != 0L).collect(Collectors.toList());
        HashMap positionMap = new HashMap(positionVidList.size());
        if (CollectionUtils.isNotEmpty(positionVidList)) {
            LOGGER.info("positionVidList:{}", positionVidList);
            positionMap.putAll(PositionQueryRepository.getInstance().queryVersionIdAndPositionMap(positionVidList));
        }
        if ((reqs = Arrays.stream(positionBills).filter(positionBill -> {
            Boolean dateFilter = !HRDateTimeUtils.dayAfter((Date)positionBill.getDate("bsed"), (Date)HRDateTimeUtils.getNowDate());
            Boolean currentFilter = Boolean.FALSE;
            long positionVid = positionBill.getLong("hisnewversion");
            if (positionMap.containsKey(positionVid)) {
                boolean iscurrentversion = ((DynamicObject)positionMap.get(positionVid)).getBoolean("iscurrentversion");
                String datastatusStr = ((DynamicObject)positionMap.get(positionVid)).getString("datastatus");
                currentFilter = !iscurrentversion && HRStringUtils.equals((String)"1", (String)datastatusStr);
            }
            return dateFilter != false && currentFilter != false;
        }).map(positionBill -> {
            BosPositionValidateReq req = new BosPositionValidateReq();
            long positionVid = positionBill.getLong("hisnewversion");
            if (positionMap.containsKey(positionVid)) {
                req.setPositionId(((DynamicObject)positionMap.get(positionVid)).getLong("boid"));
            }
            req.setPositionName(positionBill.getLocaleString("name"));
            req.setPositionNumber(positionBill.getString("number"));
            req.setPositionOrgId(positionBill.getLong("adminorg.id"));
            return req;
        }).collect(Collectors.toList())).size() == 0) {
            LOGGER.info("Revise Save reqs is empty");
            return;
        }
        List results = IBosPositionService.getInstance().bosPositionValidate(reqs);
        if (results.size() == 0) {
            LOGGER.error("results is empty");
            return;
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            BosPositionValidateResult result = (BosPositionValidateResult)results.get(i);
            ExtendedDataEntity dataEntity = dataEntities[i];
            if (!result.getResult()) {
                this.addFatalErrorMessage(dataEntity, result.getMessage());
                continue;
            }
            DynamicObject positionBill2 = dataEntity.getDataEntity();
            long positionVid = positionBill2.getLong("hisnewversion");
            long bosPositionId = result.getBosPositionId();
            if (positionVid != 0L || bosPositionId == 0L) continue;
            positionBill2.set("id", (Object)bosPositionId);
        }
    }
}

